/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.px;

import com.tridium.hx.px.BHxPxLabel;
import com.tridium.util.BISubstitutableOrdScheme;
import com.tridium.web.WebUtil;
import com.tridium.web.servlets.ViewAllOrdServlet;
import java.util.Arrays;
import java.util.Optional;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.PropertiesCollection;
import javax.baja.hx.px.MouseEventCommand;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BHyperlinkLabel;
import javax.baja.ui.BValueBinding;
import javax.servlet.http.HttpServletRequest;

public class BHxPxHyperlinkLabel
extends BHxPxLabel {
    public static final BHxPxHyperlinkLabel INSTANCE = new BHxPxHyperlinkLabel();
    public static final Type TYPE = Sys.loadType(BHxPxHyperlinkLabel.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxPxHyperlinkLabel() {
    }

    @Override
    public MouseEventCommand getMouseEventHandler() {
        return null;
    }

    @Override
    public void write(HxOp op) throws Exception {
        super.write(op);
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<a ").attr("id", op.scope("anchor")).attr("class", "hxpx-anchor").w((Object)">");
        out.w((Object)"</a>");
    }

    @Override
    public void update(int width, int height, boolean forceUpdate, HxOp op) throws Exception {
        boolean hyperlinkAvailable;
        super.update(width, height, forceUpdate, op);
        PropertiesCollection.Styles style = new PropertiesCollection.Styles();
        PropertiesCollection.Properties properties = new PropertiesCollection.Properties();
        PropertiesCollection.Events events = new PropertiesCollection.Events();
        BHyperlinkLabel label = (BHyperlinkLabel)op.get();
        BOrd hyperlinkOrd = label.getOrd();
        if (hyperlinkOrd.isNull()) {
            Optional<BValueBinding> valueBinding = this.getValueBinding(op);
            hyperlinkOrd = valueBinding.isPresent() ? valueBinding.get().getHyperlink() : hyperlinkOrd;
        }
        boolean bl = hyperlinkAvailable = label.getEnabled() && !hyperlinkOrd.isNull();
        if (hyperlinkAvailable) {
            properties.setSnoopEnabled(false);
            if (!ViewAllOrdServlet.DISABLE_HYPERLINK_ORD_SUBSTITUTION && BISubstitutableOrdScheme.findSubstitutableOrdScheme((BOrd)hyperlinkOrd).isPresent()) {
                events.add("onclick", "hx.hyperlink('" + HxUtil.escapeJsStringLiteral(WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)BOrd.make((BOrd)op.getOrd(), (BOrd)hyperlinkOrd).normalize())) + "'); return false;");
            } else {
                events.add("onclick", "");
            }
            properties.addUnsafe("href", WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)BOrd.make((BOrd)op.getOrd(), (BOrd)hyperlinkOrd).normalize()));
            style.add("cursor", "pointer");
        } else {
            properties.add("href", "javascript:;");
            style.add("cursor", "default");
            events.add("onclick", "");
        }
        properties.write(op.scope("anchor"), op);
        ((PropertiesCollection)style).write(op.scope("anchor"), op);
        ((PropertiesCollection)events).write(op.scope("anchor"), op);
    }

    private Optional<BValueBinding> getValueBinding(HxOp op) {
        BHyperlinkLabel label = (BHyperlinkLabel)op.get();
        Optional<BValueBinding> valueBinding = Arrays.stream(label.getBindings()).filter(binding -> binding instanceof BValueBinding && !((BValueBinding)binding).getHyperlink().isNull()).findFirst().map(binding -> (BValueBinding)binding);
        return valueBinding;
    }
}

