/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.px;

import com.tridium.hx.px.BHxPxExpanderPaneButton;
import com.tridium.hx.util.HxUtils;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.PropertiesCollection;
import javax.baja.hx.px.BHxPxWidget;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BExpandablePane;

@NiagaraType(agent={@AgentOn(types={"bajaui:ExpandablePane"})})
@NiagaraSingleton
public class BHxPxExpandablePane
extends BHxPxWidget {
    public static final BHxPxExpandablePane INSTANCE = new BHxPxExpandablePane();
    public static final Type TYPE = Sys.loadType(BHxPxExpandablePane.class);
    private ToggleExpansion toggleExpansion = new ToggleExpansion(this);

    @Override
    public Type getType() {
        return TYPE;
    }

    private BHxPxExpandablePane() {
        this.registerEvent(this.toggleExpansion);
    }

    @Override
    public void write(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div ").attr("id", op.scope("sb")).attr(" class", "hxpx-expander").w((Object)">");
        BHxPxExpanderPaneButton.INSTANCE.write(op);
        out.w((Object)"<span ").attr("id", op.scope("cursor"));
        out.w((Object)" onclick='").w((Object)this.toggleExpansion.getInvokeCode(op)).w((Object)"'>");
        out.w((Object)"</span>");
        out.w((Object)"</div>");
    }

    @Override
    public void update(int width, int height, boolean forcedUpdate, HxOp op) throws Exception {
        BHxPxExpanderPaneButton.INSTANCE.update(width, height, forcedUpdate, op);
        BExpandablePane pane = (BExpandablePane)op.get();
        int expanderWidth = (int)(pane.getButtonGeom().width() + pane.getButtonGeom().x());
        int expanderHeight = (int)(pane.getButtonGeom().height() + pane.getButtonGeom().y());
        BWidget summaryWidget = pane.getSummary();
        PropertiesCollection.Styles summaryStyle = new PropertiesCollection.Styles();
        HxUtil.makeBackground(pane.getSummaryBackground(), null, summaryStyle, op);
        summaryStyle.append("height", Math.max(summaryWidget.getHeight(), (double)expanderHeight) + "px");
        ((PropertiesCollection)summaryStyle).write(op.scope("sb"), op);
        PropertiesCollection.Properties expander = new PropertiesCollection.Properties();
        expander.add("className", !this.isMouseEnabled(op) || !pane.isExpanderVisible() ? "pxDisabled" : "");
        expander.write(op.scope("cursor"), op);
        PropertiesCollection.Styles expanderStyle = new PropertiesCollection.Styles();
        expanderStyle.add("width", expanderWidth + "px");
        expanderStyle.add("height", expanderHeight + "px");
        ((PropertiesCollection)expanderStyle).write(op.scope("cursor"), op);
    }

    private class ToggleExpansion
    extends Command {
        private ToggleExpansion(BHxView view) {
            super(view);
        }

        @Override
        public void handle(HxOp op) throws Exception {
            BExpandablePane pane = (BExpandablePane)op.get();
            if (BHxPxExpandablePane.this.isMouseEnabled(op) && pane.isExpanderVisible()) {
                boolean newExpandedState = !pane.isExpanded();
                pane.setExpanded(newExpandedState);
                if (!newExpandedState) {
                    pane.relayoutSync();
                }
                HxUtils.forceUpdate(op);
            }
        }
    }
}

