/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.gx;

import com.tridium.gx.util.GeomUtil;
import com.tridium.hx.gx.HtmlAbstractPainter;
import javax.baja.gx.Point;
import javax.baja.io.HtmlWriter;

public class HtmlCanvasPainter
extends HtmlAbstractPainter {
    private final HtmlWriter out;
    private final String varName;
    private final boolean fill;

    public HtmlCanvasPainter(HtmlWriter out, String varName, boolean fill) {
        this.out = out;
        this.varName = varName;
        this.fill = fill;
    }

    public void arcTo(double x, double y, double rx, double ry, double angleDegrees, boolean largeArcFlag, boolean sweepFlag) {
        Point lastPoint = this.getLastPoint();
        double lastX = lastPoint.x;
        double lastY = lastPoint.y;
        double rad = rx > ry ? rx : ry;
        double sx = rx > ry ? 1.0 : rx / ry;
        double sy = rx > ry ? ry / rx : 1.0;
        GeomUtil.ArcDefinition def = GeomUtil.calculateArc((double)lastX, (double)lastY, (double)x, (double)y, (double)rx, (double)ry, (double)angleDegrees, (boolean)largeArcFlag, (boolean)sweepFlag);
        this.push();
        this.translate(def.centerX, def.centerY);
        this.rotate(angleDegrees);
        this.scale(sx, sy);
        this.arc(0.0, 0.0, rad, def.startAngleDegrees, def.endAngleDegrees, !sweepFlag);
        this.pop();
    }

    public void beginPath() {
        this.call("beginPath();");
    }

    public void bezierCurveTo(double x, double y, double x1, double y1, double x2, double y2) {
        this.call("bezierCurveTo(" + x1 + "," + y1 + "," + x2 + "," + y2 + "," + x + "," + y + ");");
    }

    public void closePath() {
        this.call("closePath();");
        this.draw();
    }

    public void finish() {
        if (this.getLastPoint() != null) {
            this.draw();
            this.call("closePath();");
        }
    }

    public void lineTo(double x, double y) {
        this.call("lineTo(" + x + "," + y + ");");
    }

    public void moveTo(double x, double y) {
        this.call("moveTo(" + x + "," + y + ");");
    }

    public void quadraticCurveTo(double x, double y, double x1, double y1) {
        this.call("quadraticCurveTo(" + x1 + "," + y1 + "," + x + "," + y + ");");
    }

    public void arc(double centerX, double centerY, double radius, double startAngleDegrees, double endAngleDegrees, boolean anticlockwise) {
        this.call("arc(" + centerX + "," + centerY + "," + radius + "," + Math.toRadians(startAngleDegrees) + "," + Math.toRadians(endAngleDegrees) + "," + anticlockwise + ");");
    }

    @Override
    public void ellipse(double centerX, double centerY, double rx, double ry, double angleDegrees) {
        double radius = Math.max(rx, ry);
        double scaleX = rx > ry ? 1.0 : rx / ry;
        double scaleY = rx > ry ? ry / rx : 1.0;
        this.push();
        this.translate(centerX, centerY);
        this.scale(scaleX, scaleY);
        this.rotate(angleDegrees);
        this.beginPath();
        this.arc(0.0, 0.0, radius, 0.0, 360.0, false);
        this.pop();
        this.closePath();
    }

    @Override
    public void push() {
        this.call("save();");
    }

    @Override
    public void pop() {
        this.call("restore();");
    }

    @Override
    public void rotate(double angleDegrees) {
        this.call("rotate(" + Math.toRadians(angleDegrees) + ");");
    }

    @Override
    public void scale(double scaleX, double scaleY) {
        this.call("scale(" + scaleX + "," + scaleY + ");");
    }

    @Override
    public void translate(double x, double y) {
        this.call("translate(" + x + "," + y + ");");
    }

    private void draw() {
        if (this.fill) {
            this.call("fill();");
        } else {
            this.call("stroke();");
        }
    }

    private void call(String methodCall) {
        this.out.w((Object)this.varName).w('.').w((Object)methodCall).nl();
    }
}

