/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.fieldeditors;

import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHxStringFE
extends BHxFieldEditor {
    public static final BHxStringFE INSTANCE = new BHxStringFE();
    public static final Type TYPE = Sys.loadType(BHxStringFE.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxStringFE() {
    }

    @Override
    public void write(HxOp op) throws Exception {
        BString value = (BString)op.get();
        HtmlWriter out = op.getHtmlWriter();
        boolean multLine = ((BBoolean)op.getFacets().get("multiLine", (BObject)BBoolean.FALSE)).getBoolean();
        int width = ((BInteger)op.getFacets().get("fieldWidth", (BObject)BInteger.make((int)40))).getInt();
        if (!multLine) {
            out.w((Object)"<input type='text' size='").w(width).w((Object)"'");
            out.w((Object)" ").attr("name", op.scope("value"));
            out.w((Object)" ").attr("id", op.scope("value"));
            out.w((Object)" ").attr("value", value.toString());
            if (!op.canWrite()) {
                out.w((Object)" readonly='readonly'");
            }
            out.w((Object)"/>");
        } else {
            out.w((Object)"<textarea rows='3' cols='").w(width).w((Object)"'");
            out.w((Object)" ").attr("name", op.scope("value"));
            out.w((Object)" ").attr("id", op.scope("value"));
            if (!op.canWrite()) {
                out.w((Object)" readonly='readonly'");
            }
            out.w((Object)">");
            out.safe((Object)value.getString());
            out.w((Object)"</textarea>");
        }
    }

    @Override
    public void update(HxOp op) throws Exception {
        if (!op.canWrite()) {
            BString value = (BString)op.get();
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)HxUtil.getUpdateValueInvokeCode(op.scope("value"), value.toString(), "'", op));
        }
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        String value = op.getUnsafeFormValue("value");
        return BString.make((String)value);
    }
}

