/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.fieldeditors;

import com.tridium.web.WebUtil;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.security.BPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;
import javax.servlet.http.HttpServletRequest;

public class BHxPasswordFE
extends BHxFieldEditor {
    public static final BHxPasswordFE INSTANCE = new BHxPasswordFE();
    public static final Type TYPE = Sys.loadType(BHxPasswordFE.class);
    static final LexiconModule lex = LexiconModule.make((String)"bajaui");
    protected static final char SUBSTITUTE = '\ufffd';

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxPasswordFE() {
    }

    @Override
    public void write(HxOp op) throws Exception {
        boolean readOnly = !WebUtil.isPasswordChangeAllowed((HttpServletRequest)op.getRequest());
        this.write(lex.getText("user.password", (Context)op), lex.getText("user.confirm", (Context)op), op, readOnly);
    }

    public void write(String passwordLex, String confirmLex, HxOp op, boolean readOnly) throws Exception {
        BPassword value = (BPassword)op.get();
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table>");
        out.w((Object)"<tr>");
        out.w((Object)" <td>").safe((Object)passwordLex).w((Object)": ").w((Object)"</td>");
        out.w((Object)" <td>");
        this.writeField(out, "value", value, op, readOnly);
        out.w((Object)" </td>");
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)" <td>").safe((Object)confirmLex).w((Object)": ").w((Object)"</td>");
        out.w((Object)" <td>");
        this.writeField(out, "confirm", value, op, readOnly);
        out.w((Object)" </td>");
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
    }

    void writeField(HtmlWriter out, String name, BPassword value, HxOp op, boolean readOnly) {
        String encoded = this.getEncoding(value, op);
        out.w((Object)"<input type='password' size='20' autocomplete='off'");
        if (!op.canWrite() || readOnly) {
            out.w((Object)" disabled='disabled'");
        }
        out.w((Object)" ").attr("name", op.scope(name));
        out.w((Object)" ").attr("value", encoded);
        out.w((Object)" ").attr("autocomplete", "off");
        String modifiedInvokeCode = "hx.setFormValue(&quot;" + op.scope("modified") + "&quot;, true);";
        out.w((Object)" onkeydown='var key=window.event?window.event.keyCode:event.which; ");
        if (encoded.length() == 0) {
            out.w((Object)("if(key > 46){" + modifiedInvokeCode + "}"));
        }
        out.w((Object)"if(this.value.indexOf(String.fromCharCode(").w(65533).w((Object)"))!=-1) { if(key > 46 || key == 8) this.value=this.value.substring(0,0); else if(key != 9){this.select(); return false;}};'");
        out.w((Object)" onfocus='if(this.value.indexOf(String.fromCharCode(").w(65533).w((Object)"))!=-1){this.select();}'");
        out.w((Object)" onclick='if(this.value.indexOf(String.fromCharCode(").w(65533).w((Object)"))!=-1){this.select();}'");
        out.w((Object)(" onchange='" + modifiedInvokeCode + "'"));
        out.w((Object)"/>");
    }

    public String getEncoding(BPassword password, HxOp op) {
        int length = 8;
        String encoding = "";
        length = password.isDefault() ? 0 : 8;
        for (int i = 0; i < length; ++i) {
            encoding = encoding + '\ufffd';
        }
        return encoding;
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        BPassword password = (BPassword)op.get();
        if (!WebUtil.isPasswordChangeAllowed((HttpServletRequest)op.getRequest())) {
            return password;
        }
        String encoding = this.getEncoding(password, op);
        String value = op.getUnsafeFormValue("value");
        String confirm = op.getFormValue("confirm");
        String modified = op.getFormValue("modified");
        if (value == null || confirm == null) {
            return op.get();
        }
        if (value.indexOf(65533) > -1 && confirm.indexOf(65533) > -1) {
            return op.get();
        }
        if (value.indexOf(65533) > -1 || confirm.indexOf(65533) > -1) {
            throw new LocalizableException((Lexicon)UiLexicon.bajaui(), "user.passwordMismatch");
        }
        if (!value.equals(confirm)) {
            throw new LocalizableException((Lexicon)UiLexicon.bajaui(), "user.passwordMismatch");
        }
        if (modified == null && password.isDefault()) {
            return op.get();
        }
        return BPassword.make((String)value);
    }
}

