/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.fieldeditors;

import com.tridium.sys.Nre;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;
import javax.baja.workbench.CannotSaveException;

public class BHxNumericFE
extends BHxFieldEditor {
    public static final BHxNumericFE INSTANCE = new BHxNumericFE();
    public static final Type TYPE = Sys.loadType(BHxNumericFE.class);
    Map<String, DecimalFormat> formatters = new HashMap<String, DecimalFormat>();
    private static DecimalFormat fSN = new DecimalFormat("0.###############E0");
    private static final long MAX_LONG_PREC = 0x20000000000000L;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxNumericFE() {
    }

    private Parser getParser(HxOp op) {
        Parser p;
        BNumber num = (BNumber)op.get();
        if (num instanceof BFloat) {
            p = new FloatParser(op);
        } else if (num instanceof BInteger) {
            p = new IntegerParser(op);
        } else if (num instanceof BLong) {
            p = new LongParser(op);
        } else if (num instanceof BDouble) {
            p = new DoubleParser(op);
        } else {
            throw new IllegalStateException("Should never get here!");
        }
        return p;
    }

    public BValue getValue(HxOp op, Convert convert) throws CannotSaveException {
        BNumber num = (BNumber)op.get();
        Parser p = this.getParser(op);
        String s = p.formatValue((BObject)num, convert);
        HxOp opNoConverstion = op.make(op.getBaseOrdTarget()).mergeFacets(BFacets.make((String)"unitConversion", (int)0));
        Parser pNoConversion = this.getParser(opNoConverstion);
        return pNoConversion.parse(s, convert);
    }

    public String getValueAsString(HxOp op, Convert convert) throws CannotSaveException {
        BNumber num = (BNumber)op.get();
        Parser p = this.getParser(op);
        return p.formatPreMeta() + p.formatValue((BObject)num, convert) + p.formatPostMeta();
    }

    @Override
    public void write(HxOp op) throws Exception {
        Parser p = this.getParser(op);
        BNumber num = (BNumber)op.get();
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<span style='white-space:nowrap;'>");
        out.safe((Object)p.formatPreMeta());
        out.w((Object)"<input type='text' size='10'");
        if (!op.canWrite()) {
            out.w((Object)" readonly='readonly'");
        }
        out.w((Object)" ").attr("name", op.scope("value"));
        out.w((Object)" ").attr("id", op.scope("value"));
        out.w((Object)" ").attr("value", p.formatValue((BObject)num));
        out.w((Object)"/>");
        out.safe((Object)p.formatPostMeta());
        out.w((Object)"</span>");
    }

    @Override
    public void update(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        if (!op.canWrite()) {
            BNumber num = (BNumber)op.get();
            Parser p = this.getParser(op);
            out.w((Object)"var editor_value='").w((Object)p.formatValue((BObject)num)).w((Object)"';");
            out.w((Object)"if(document.getElementById('").w((Object)op.scope("value")).w((Object)"').value!=editor_value) {");
            out.w((Object)"document.getElementById('").w((Object)op.scope("value")).w((Object)"').value=editor_value;}");
        }
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        String value = op.getUnsafeFormValue("value");
        Parser p = this.getParser(op);
        BValue parse = p.parse(value);
        return parse;
    }

    DecimalFormat getFormat(int precision, boolean showSeparators) {
        String key = "" + precision + showSeparators;
        DecimalFormat formatter = this.formatters.get(key);
        if (formatter == null) {
            StringBuffer pattern = new StringBuffer(16);
            if (showSeparators) {
                pattern.append("#,##0");
            } else {
                pattern.append("#0");
            }
            if (precision > 0) {
                pattern.append('.');
                for (int i = 0; i < precision; ++i) {
                    pattern.append('0');
                }
            }
            formatter = new DecimalFormat(pattern.toString());
            this.formatters.put(key, formatter);
        }
        return formatter;
    }

    public class LongParser
    extends IntParser {
        public LongParser(HxOp op) {
            super(op);
        }

        @Override
        public double getTypeMin() {
            return -9.223372036854776E18;
        }

        @Override
        public double getTypeMax() {
            return 9.223372036854776E18;
        }

        @Override
        public BValue make(long v) {
            return BLong.make((long)v);
        }

        @Override
        public String formatValue(long x, Convert convert) {
            if (this.displayUnits != this.realUnits) {
                x = convert == Convert.display ? (long)this.realUnits.convertTo(this.displayUnits, (double)x) : (long)this.displayUnits.convertTo(this.realUnits, (double)x);
            }
            if ((double)x == this.getTypeMin()) {
                return "min";
            }
            if ((double)x == this.getTypeMax()) {
                return "max";
            }
            if (this.radix != 10) {
                return Long.toString(x, this.radix);
            }
            if (this.showSeparators) {
                return this.format.format(x);
            }
            return Long.toString(x);
        }
    }

    public class IntegerParser
    extends IntParser {
        public IntegerParser(HxOp op) {
            super(op);
        }

        @Override
        public double getTypeMin() {
            return -2.147483648E9;
        }

        @Override
        public double getTypeMax() {
            return 2.147483647E9;
        }

        @Override
        public BValue make(long v) {
            return BInteger.make((int)((int)v));
        }

        @Override
        public String formatValue(long x, Convert convert) {
            if (this.displayUnits != this.realUnits) {
                x = convert == Convert.display ? (long)this.realUnits.convertTo(this.displayUnits, (double)x) : (long)this.displayUnits.convertTo(this.realUnits, (double)x);
            }
            if ((double)x == this.getTypeMin()) {
                return "min";
            }
            if ((double)x == this.getTypeMax()) {
                return "max";
            }
            if (this.radix != 10) {
                return Long.toString(x & 0xFFFFFFFFL, this.radix);
            }
            if (this.showSeparators) {
                return this.format.format(x);
            }
            return Long.toString(x);
        }
    }

    public abstract class IntParser
    extends Parser {
        protected int radix;

        public abstract BValue make(long var1);

        public abstract String formatValue(long var1, Convert var3);

        @Override
        protected int getPrecision(HxOp op) {
            return 0;
        }

        protected IntParser(HxOp op) {
            super(op);
            BInteger radixFacet = (BInteger)op.getFacet("radix");
            this.radix = radixFacet == null ? 10 : radixFacet.getInt();
        }

        @Override
        public String formatValue(BObject x) {
            return this.formatValue(((BNumber)x).getLong());
        }

        @Override
        public BValue parse(String s, Convert convert) throws CannotSaveException {
            long x;
            s = TextUtil.toLowerCase((String)s);
            try {
                x = s.equals("min") ? (long)this.getTypeMin() : (s.equals("max") ? (long)this.getTypeMax() : (this.radix != 10 ? Long.parseLong(s, this.radix) : (this.showSeparators ? (long)this.format.parse(s).intValue() : Long.parseLong(s))));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CannotSaveException("Invalid format: " + s);
            }
            long minDisplay = (long)this.min;
            long maxDisplay = (long)this.max;
            if (this.displayUnits != this.realUnits) {
                if (convert == Convert.display) {
                    minDisplay = Math.round(this.realUnits.convertTo(this.displayUnits, this.min));
                    maxDisplay = Math.round(this.realUnits.convertTo(this.displayUnits, this.max));
                } else {
                    minDisplay = Math.round(this.displayUnits.convertTo(this.realUnits, this.min));
                    maxDisplay = Math.round(this.displayUnits.convertTo(this.realUnits, this.max));
                }
            }
            if (this.displayUnits != this.realUnits) {
                x = convert == Convert.storage ? Math.round(this.displayUnits.convertTo(this.realUnits, (double)x)) : Math.round(this.realUnits.convertTo(this.displayUnits, (double)x));
            }
            if (x < minDisplay) {
                throw new CannotSaveException(x + " < " + minDisplay + ' ' + this.range);
            }
            if (x > maxDisplay) {
                throw new CannotSaveException(x + " > " + maxDisplay + ' ' + this.range);
            }
            return this.make(x);
        }
    }

    public class DoubleParser
    extends RealParser {
        public DoubleParser(HxOp op) {
            super(op);
        }

        @Override
        public double getTypeMin() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public double getTypeMax() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public BValue make(double d) {
            return BDouble.make((double)d);
        }
    }

    public class FloatParser
    extends RealParser {
        public FloatParser(HxOp op) {
            super(op);
        }

        @Override
        public double getTypeMin() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public double getTypeMax() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public BValue make(double d) {
            return BFloat.make((float)((float)d));
        }
    }

    public abstract class RealParser
    extends Parser {
        public abstract BValue make(double var1);

        @Override
        protected int getPrecision(HxOp op) {
            return op.getFacets().geti("precision", 2);
        }

        protected RealParser(HxOp op) {
            super(op);
        }

        @Override
        public BValue parse(String text, Convert convert) throws CannotSaveException {
            double v = 0.0;
            text = TextUtil.toLowerCase((String)text);
            try {
                v = text.equals("-inf") ? this.getTypeMin() : (text.equals("+inf") ? this.getTypeMax() : (text.equals("nan") ? Double.NaN : (text.indexOf(101) != -1 ? fSN.parse(TextUtil.toUpperCase((String)text)).doubleValue() : this.format.parse(text).doubleValue())));
            }
            catch (NumberFormatException | ParseException nfe) {
                throw new CannotSaveException("Invalid format: " + nfe.getMessage());
            }
            catch (RuntimeException e) {
                throw new CannotSaveException("Invalid format: " + text);
            }
            double minDisplay = this.min;
            double maxDisplay = this.max;
            if (this.displayUnits != this.realUnits) {
                if (convert == Convert.display) {
                    minDisplay = this.realUnits.convertTo(this.displayUnits, this.min);
                    maxDisplay = this.realUnits.convertTo(this.displayUnits, this.max);
                } else {
                    minDisplay = this.displayUnits.convertTo(this.realUnits, this.min);
                    maxDisplay = this.displayUnits.convertTo(this.realUnits, this.max);
                }
            }
            if (this.realUnits != this.displayUnits) {
                v = convert == Convert.storage ? this.displayUnits.convertTo(this.realUnits, v) : this.realUnits.convertTo(this.displayUnits, v);
            }
            if (v < minDisplay) {
                throw new CannotSaveException(v + " < " + minDisplay + ' ' + this.range);
            }
            if (v > maxDisplay) {
                throw new CannotSaveException(v + " > " + maxDisplay + ' ' + this.range);
            }
            return this.make(v);
        }
    }

    public abstract class Parser {
        protected BUnit displayUnits;
        protected int prec;
        protected double min;
        protected double max;
        protected DecimalFormat format;
        protected String range;
        protected String premeta;
        protected String postmeta;
        protected boolean showSeparators;
        protected BUnit realUnits;

        protected Parser(HxOp op) {
            BNumber n;
            BFacets facets = op.getFacets();
            this.showSeparators = facets.getb("showSeparators", false);
            this.format = BHxNumericFE.this.getFormat(this.getPrecision(op), this.showSeparators);
            this.realUnits = (BUnit)facets.get("units");
            if (this.realUnits != null && this.realUnits.isNull()) {
                this.realUnits = null;
            }
            this.min = (n = (BNumber)facets.get("min")) == null ? this.getTypeMin() : (double)n.getFloat();
            n = (BNumber)facets.get("max");
            this.max = n == null ? this.getTypeMax() : (double)n.getFloat();
            int convert = facets.geti("unitConversion", Nre.unitConversion);
            this.prec = facets.geti("precision", 2);
            this.displayUnits = this.realUnits;
            if (convert != 0 && this.realUnits != null) {
                BUnitConversion c = BUnitConversion.make((int)convert);
                this.displayUnits = c.getDesiredUnit(this.realUnits);
            }
            this.premeta = "";
            this.postmeta = "";
            if (this.displayUnits != null) {
                if (this.displayUnits.getIsPrefix()) {
                    this.premeta = ' ' + this.displayUnits.getSymbol() + ' ';
                } else {
                    this.postmeta = ' ' + this.displayUnits.getSymbol();
                }
            }
            if (this.min != this.getTypeMin() || this.max != this.getTypeMax()) {
                this.range = '[' + this.formatValue(this.min) + " - " + this.formatValue(this.max) + ']';
                this.postmeta = this.postmeta + ' ' + this.range;
            }
        }

        public abstract double getTypeMin();

        public abstract double getTypeMax();

        public BValue parse(String s) throws CannotSaveException {
            return this.parse(s, Convert.storage);
        }

        public abstract BValue parse(String var1, Convert var2) throws CannotSaveException;

        protected abstract int getPrecision(HxOp var1);

        public String formatPostMeta() {
            return this.postmeta;
        }

        public String formatPreMeta() {
            return this.premeta;
        }

        public String formatValue(BObject x) {
            return this.formatValue(x, Convert.display);
        }

        public String formatValue(BObject x, Convert convert) {
            return this.formatValue(((BNumber)x).getDouble(), convert);
        }

        public String formatValue(double x) {
            return this.formatValue(x, Convert.display);
        }

        public String formatValue(double x, Convert convert) {
            if (this.displayUnits != this.realUnits) {
                x = convert == Convert.display ? this.realUnits.convertTo(this.displayUnits, x) : this.displayUnits.convertTo(this.realUnits, x);
            }
            if (x == this.getTypeMin()) {
                return "-inf";
            }
            if (x == this.getTypeMax()) {
                return "+inf";
            }
            if (Double.isNaN(x)) {
                return "nan";
            }
            if (Math.IEEEremainder(x, 1.0) == 0.0) {
                if ((long)Math.abs(x) >= 0x20000000000000L) {
                    return fSN.format(x);
                }
                return this.format.format(x);
            }
            return this.format.format(x);
        }
    }

    public static enum Convert {
        display,
        storage;

    }
}

