/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.fieldeditors;

import com.tridium.hx.fieldeditors.BHxBajauxFE;
import java.util.logging.Level;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.HxOp;
import javax.baja.hx.px.BHxPxWidget;
import javax.baja.hx.px.MouseEventCommand;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditorBinding;

public class BHxGenericFE
extends BHxPxWidget {
    public static final BHxGenericFE INSTANCE = new BHxGenericFE();
    public static final Type TYPE = Sys.loadType(BHxGenericFE.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BWidget[] getChildWidgets(BWidget widget, Context cx) {
        return new BWidget[0];
    }

    @Override
    public MouseEventCommand getMouseEventHandler() {
        return null;
    }

    @Override
    public void write(HxOp op) throws Exception {
        BWbEditor fieldEditor = (BWbEditor)op.get();
        BWbFieldEditorBinding bind = this.getBinding((BWidget)fieldEditor);
        HtmlWriter out = op.getHtmlWriter();
        if (bind != null && !bind.getOrd().isNull()) {
            OrdTarget target;
            try {
                target = bind.getOrd().resolve(op.getWebOp().get(), (Context)op);
                if (!target.canRead()) {
                    return;
                }
            }
            catch (Exception ue) {
                if (log.isLoggable(Level.FINE)) {
                    out.w((Object)("\n<!-- generic field editor binding unresolved: " + bind.getOrd() + " -->\n"));
                }
                return;
            }
            HxOp childOp = op.make("value", target);
            childOp = childOp.mergeFacets(target.getFacets());
            BHxFieldEditor editor = BHxFieldEditor.makeForUx(target.get(), childOp);
            BHxGenericFE.matchReadonlyAndEnabled((BWidget)fieldEditor, target, editor, childOp);
            if (log.isLoggable(Level.FINE)) {
                out.w((Object)"\n\n");
                out.w((Object)"<!-- editor: ").w((Object)editor.getType()).w((Object)" -->\n");
                out.w((Object)"<!-- value: ").w((Object)target.get().getType()).w((Object)" -->\n");
            }
            BHxGenericFE.writeFieldEditor(out, childOp, editor);
        } else {
            BObject value = fieldEditor.getCurrentValue();
            HxOp childOp = op.make("value", new OrdTarget((OrdTarget)op, value));
            BHxFieldEditor editor = BHxFieldEditor.makeForUx((BObject)fieldEditor, childOp);
            if (log.isLoggable(Level.FINE)) {
                out.w((Object)"\n\n");
                if (editor != null) {
                    out.w((Object)"<!-- editor: ").w((Object)editor.getType()).w((Object)" -->\n");
                }
                out.w((Object)"<!-- value: ").w((Object)fieldEditor.getCurrentValue().getType()).w((Object)" -->\n");
            }
            BHxGenericFE.writeFieldEditor(out, childOp, editor);
        }
    }

    private static void writeFieldEditor(HtmlWriter out, HxOp childOp, BHxFieldEditor editor) throws Exception {
        out.w((Object)("<span class='-t-hx-generic-fe-wrapper' id='" + childOp.getPath() + "'>"));
        editor.write(childOp);
        out.w((Object)"</span>");
    }

    public static void matchReadonlyAndEnabled(BWidget fieldEditor, OrdTarget target, BHxFieldEditor editor, HxOp childOp) {
        if (editor instanceof BHxBajauxFE) {
            if (!fieldEditor.getEnabled()) {
                childOp.setConfig("enabled", (BValue)BBoolean.FALSE);
            }
            childOp.setReadonly(!target.canWrite());
        } else {
            childOp.setReadonly(!target.canWrite() || !fieldEditor.getEnabled());
        }
    }

    @Override
    public boolean needsUpdate(BAbsTime lastUpdate, BAbsTime lastModified) {
        return true;
    }

    @Override
    public void update(int width, int height, boolean forceUpdate, HxOp op) throws Exception {
        BWbFieldEditor fieldEditor = (BWbFieldEditor)op.get();
        BWbFieldEditorBinding bind = this.getBinding((BWidget)fieldEditor);
        HtmlWriter out = op.getHtmlWriter();
        if (bind != null && !bind.getOrd().isNull()) {
            OrdTarget target;
            try {
                target = bind.getOrd().resolve(op.getWebOp().get(), (Context)op);
            }
            catch (Exception ue) {
                if (log.isLoggable(Level.FINE)) {
                    out.w((Object)("\n// generic field editor binding unresolved: " + bind.getOrd() + " -->\n"));
                }
                return;
            }
            HxOp childOp = op.make("value", target);
            childOp = childOp.mergeFacets(target.getFacets());
            if (!target.canRead()) {
                return;
            }
            BHxFieldEditor editor = BHxFieldEditor.makeForUx(target.get(), childOp);
            BHxGenericFE.matchReadonlyAndEnabled((BWidget)fieldEditor, target, editor, childOp);
            if (log.isLoggable(Level.FINE)) {
                out.w((Object)"\n");
                out.w((Object)"// editor:").w((Object)editor.getType()).w((Object)"\n");
                out.w((Object)"// value:").w((Object)target.get().toString((Context)op)).w((Object)"\n");
            }
            editor.update(childOp);
        } else {
            BObject value = fieldEditor.getCurrentValue();
            HxOp childOp = op.make("value", new OrdTarget((OrdTarget)op, value));
            BHxFieldEditor editor = BHxFieldEditor.makeForUx((BObject)fieldEditor, childOp);
            if (log.isLoggable(Level.FINE)) {
                out.w((Object)"\n");
                out.w((Object)"// editor:").w((Object)editor.getType()).w((Object)"\n");
                out.w((Object)"// value:").safe((Object)fieldEditor.getCurrentValue().toString((Context)op)).w((Object)"\n");
            }
            editor.update(childOp);
        }
    }

    @Override
    public boolean process(HxOp op) throws Exception {
        BWbEditor fieldEditor = (BWbEditor)op.get();
        BWbFieldEditorBinding bind = this.getBinding((BWidget)fieldEditor);
        if (bind != null && !bind.getOrd().isNull()) {
            OrdTarget target;
            try {
                target = bind.getOrd().resolve(op.getWebOp().get(), (Context)op);
            }
            catch (Exception ue) {
                return false;
            }
            HxOp childOp = op.make("value", target);
            childOp = childOp.mergeFacets(target.getFacets());
            BHxFieldEditor editor = BHxFieldEditor.makeForUx(target.get(), childOp);
            BHxGenericFE.matchReadonlyAndEnabled((BWidget)fieldEditor, target, editor, childOp);
            return editor.process(childOp) || super.process(op);
        }
        BObject value = fieldEditor.getCurrentValue();
        HxOp childOp = op.make("value", new OrdTarget((OrdTarget)op, value));
        BHxFieldEditor editor = BHxFieldEditor.makeForUx((BObject)fieldEditor, childOp);
        if (editor.process(childOp)) {
            return true;
        }
        return super.process(op);
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        BWbEditor fieldEditor = (BWbEditor)op.get();
        BWbFieldEditorBinding bind = this.getBinding((BWidget)fieldEditor);
        if (bind != null && !bind.getOrd().isNull()) {
            OrdTarget target;
            try {
                target = bind.getOrd().resolve(op.getWebOp().get(), (Context)op);
            }
            catch (Exception e) {
                return op.get();
            }
            HxOp childOp = op.make("value", target);
            childOp = childOp.mergeFacets(target.getFacets());
            BHxFieldEditor editor = BHxFieldEditor.makeForUx(target.get(), childOp);
            BHxGenericFE.matchReadonlyAndEnabled((BWidget)fieldEditor, target, editor, childOp);
            BObject newValue = editor.fwSave(childOp);
            OrdTarget ord = bind.getTarget();
            if (ord.get() instanceof BComponent) {
                BComponent component = (BComponent)ord.get();
                BComplex parent = component.getParent();
                parent.set(component.getPropertyInParent(), (BValue)newValue, (Context)op);
                this.fw(2, BBinding.ord, null, null, null);
            } else {
                BComponent parent = bind.getTarget().getComponent();
                Property[] props = bind.getTarget().getPropertyPathInComponent();
                for (int i = 0; i < props.length - 1; ++i) {
                    parent = (BComplex)parent.get(props[i]);
                }
                Property prop = props[props.length - 1];
                parent.set(prop, (BValue)newValue, (Context)op);
            }
        } else {
            BObject value = fieldEditor.getCurrentValue();
            HxOp childOp = op.make("value", new OrdTarget((OrdTarget)op, value));
            BHxFieldEditor editor = BHxFieldEditor.makeForUx((BObject)fieldEditor, childOp);
            return editor.save(childOp);
        }
        return op.get();
    }

    private BWbFieldEditorBinding getBinding(BWidget w) {
        BBinding[] bind = w.getBindings();
        for (int i = 0; i < bind.length; ++i) {
            if (!(bind[i] instanceof BWbFieldEditorBinding)) continue;
            return (BWbFieldEditorBinding)bind[i];
        }
        return null;
    }
}

