/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx;

import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.LexiconModule;

public class BHxSlotSheet
extends BHxView {
    public static final BHxSlotSheet INSTANCE = new BHxSlotSheet();
    public static final Type TYPE = Sys.loadType(BHxSlotSheet.class);
    static LexiconModule LEX = LexiconModule.make((String)"bajaui");
    static BImage propertyIcon = BImage.make((String)"module://icons/x16/object.png");
    static BImage actionIcon = BImage.make((String)"module://icons/x16/shapes/circleGreen.png");
    static BImage topicIcon = BImage.make((String)"module://icons/x16/shapes/circleGold.png");

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxSlotSheet() {
    }

    @Override
    public void write(HxOp op) throws Exception {
        int i;
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table width='100%' cellspacing='0' class='table'>");
        out.w((Object)"<tr>");
        out.w((Object)" <th>").safe((Object)LEX.getText("slotsheet.slot", (Context)op)).w((Object)"</th>");
        out.w((Object)" <th>").safe((Object)LEX.getText("slotsheet.index", (Context)op)).w((Object)"</th>");
        out.w((Object)" <th>").safe((Object)LEX.getText("slotsheet.name", (Context)op)).w((Object)"</th>");
        out.w((Object)" <th>").safe((Object)LEX.getText("slotsheet.displayName", (Context)op)).w((Object)"</th>");
        out.w((Object)" <th>").safe((Object)LEX.getText("slotsheet.definition", (Context)op)).w((Object)"</th>");
        out.w((Object)" <th>").safe((Object)LEX.getText("slotsheet.flags", (Context)op)).w((Object)"</th>");
        out.w((Object)" <th>").safe((Object)LEX.getText("slotsheet.type", (Context)op)).w((Object)"</th>");
        out.w((Object)" <th>").safe((Object)LEX.getText("slotsheet.facets", (Context)op)).w((Object)"</th>");
        out.w((Object)"</tr>");
        BIPropertyContainer c = (BIPropertyContainer)op.get();
        Slot[] slots = c.getSlotsArray();
        BNameMap displayNames = null;
        for (i = 0; i < slots.length; ++i) {
            Property prop;
            BValue val;
            if (!slots[i].isProperty() || !slots[i].getName().equals("displayNames") || !((val = c.get(prop = slots[i].asProperty())) instanceof BNameMap)) continue;
            displayNames = (BNameMap)val;
        }
        for (i = 0; i < slots.length; ++i) {
            SlotEntry se = new SlotEntry(c, i, slots[i], displayNames, op);
            String flags = Flags.encodeToString((int)se.flags);
            String facets = se.facetsString;
            out.w((Object)"<tr>");
            out.w((Object)" <td>");
            out.w((Object)" <span style='white-space:nowrap;'>");
            HxUtil.makeImageJS(se.icon, "style='vertical-align:middle;'", null, null, op);
            out.w((Object)"&nbsp;").safe((Object)se.summary);
            out.w((Object)" </span>");
            out.w((Object)" </td>");
            out.w((Object)" <td>").safe((Object)String.valueOf(se.index)).w((Object)"</td>");
            out.w((Object)" <td>").safe((Object)se.slot.getName()).w((Object)"</td>");
            out.w((Object)" <td>").safe((Object)se.toDisplayName()).w((Object)"</td>");
            out.w((Object)" <td>").safe((Object)se.definition).w((Object)"</td>");
            out.w((Object)" <td>").safe((Object)flags).w((Object)"</td>");
            out.w((Object)" <td>").safe((Object)se.type).w((Object)"</td>");
            out.w((Object)" <td>").safe((Object)facets).w((Object)"</td>");
            out.w((Object)"</tr>");
        }
        out.w((Object)"</table>");
    }

    class SlotEntry {
        BIPropertyContainer component;
        String summary;
        int index;
        BImage icon;
        Slot slot;
        String definition;
        int flags;
        String type;
        String facetsString;
        BNameMap displayNames;

        SlotEntry(BIPropertyContainer component, int index, Slot slot, BNameMap displayNames, HxOp op) {
            this.component = component;
            this.slot = slot;
            this.index = index;
            this.flags = component.getFlags(slot);
            this.facetsString = component.getSlotFacets(slot).toString();
            this.displayNames = displayNames;
            String string = this.definition = slot.isFrozen() ? LEX.getText("slotsheet.frozen", (Context)op) : LEX.getText("slotsheet.dynamic", (Context)op);
            if (slot.isAction()) {
                this.summary = LEX.getText("slotsheet.action", (Context)op);
                this.icon = actionIcon;
                this.type = this.typestr(slot.asAction().getReturnType()) + " (" + this.typestr(slot.asAction().getParameterType()) + ")";
            } else if (slot.isTopic()) {
                this.summary = LEX.getText("slotsheet.topic", (Context)op);
                this.icon = topicIcon;
                this.type = this.typestr(slot.asTopic().getEventType());
            } else {
                this.summary = LEX.getText("slotsheet.property", (Context)op);
                this.icon = propertyIcon;
                this.type = slot.isFrozen() ? this.typestr(slot.asProperty().getType()) : component.get(slot.asProperty()).getType().toString();
            }
        }

        boolean isDisplayNameOverridden() {
            return this.displayNames != null && this.displayNames.get(this.slot.getName()) != null;
        }

        String toDisplayName() {
            BFormat format;
            if (this.displayNames != null && (format = this.displayNames.get(this.slot.getName())) != null) {
                return format.getFormat();
            }
            return this.component.getDisplayName(this.slot, null);
        }

        String typestr(Type type) {
            if (type == null) {
                return "void";
            }
            return type.toString();
        }
    }
}

