/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx;

import com.tridium.hx.fieldeditors.BHxBajauxFE;
import com.tridium.hx.fieldeditors.BHxDefaultFE;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BAction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BTopic;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.LexiconModule;
import javax.baja.workbench.CannotSaveException;

public class BHxPropertySheet
extends BHxView {
    public static final BHxPropertySheet INSTANCE = new BHxPropertySheet();
    public static final Type TYPE = Sys.loadType(BHxPropertySheet.class);
    private static final BIcon DEFAULT_ICON = BIcon.std((String)"object.png");
    private static Logger UX_LOGGER = Logger.getLogger("hx.bajauxFE");
    private static LexiconModule HX_LEX = LexiconModule.make((String)"hx");
    private static LexiconModule BAJAUI_LEX = LexiconModule.make((String)"bajaui");

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxPropertySheet() {
    }

    @Override
    public void write(HxOp op) throws Exception {
        op.setDynamic();
        BIPropertyContainer c = (BIPropertyContainer)op.get();
        HtmlWriter out = op.getHtmlWriter();
        String sheetClass = "window-bg hx-PropertySheet";
        String headClass = "window-bg control-border hx-PropertySheet-header";
        String rowClass = "window-bg control-border hx-PropertySheet-row";
        out.w((Object)"<div class='hx-PropertySheet-header'>");
        HxUtil.makeImageJS(BImage.make((BIcon)this.findIcon(c)), "class='hx-PropertySheet-icon' style='vertical-align:middle;'", null, null, op);
        out.println("&nbsp;");
        out.safe((Object)c.getDisplayName((Context)op));
        out.w((Object)" (").safe((Object)c.getType().toString()).println(")");
        out.println("</div>");
        out.w((Object)"<div class='").w((Object)sheetClass);
        out.println("'>");
        out.println("<table width='100%' cellpadding='3' cellspacing='0'>");
        SlotCursor cur = c.getProperties();
        boolean row = false;
        while (cur.next()) {
            Property p = cur.property();
            BValue obj = c.get(p);
            String displayName = c.getDisplayName((Slot)p, (Context)op);
            BImage icon = BImage.make((BIcon)obj.getIcon());
            OrdTarget target = this.handleOrd(c, "slot:" + p.getName()).resolve((BObject)c, (Context)op);
            if (!target.canRead() || (c.getFlags((Slot)p) & 4) != 0 || obj.getType().is(BWsAnnotation.TYPE) || obj.getType().is(BAction.TYPE) || obj.getType().is(BTopic.TYPE) || obj.getType().is(BLink.TYPE)) continue;
            out.println("<tr>");
            out.w((Object)"<td ").attr("class", rowClass).w((Object)">");
            out.w((Object)"<div style=\"position: relative; display: inline-block; width: 16px; height: 16px;\">");
            HxUtil.makeImageJS(icon, op);
            out.w((Object)"</div>");
            out.println("</td>");
            out.w((Object)"<td ").attr("class", rowClass).w((Object)">");
            out.w((Object)"<span style='white-space:nowrap;'>");
            if (obj instanceof BIPropertyContainer) {
                BOrd ord;
                BOrd bOrd = ord = obj instanceof BINavNode ? ((BINavNode)obj).getNavOrd() : null;
                if ((ord == null || ord.isNull()) && c instanceof BINavNode) {
                    ord = BOrd.make((BOrd)((BINavNode)c).getNavOrd(), (String)("slot:" + p.getName()));
                }
                HxUtil.writeSafeAnchor(ord, displayName, op);
            } else {
                out.safe((Object)displayName);
            }
            out.w((Object)"</span>");
            out.println("</td>");
            out.w((Object)"<td ").attr("class", rowClass).w((Object)">&nbsp;</td>");
            out.w((Object)"<td ").attr("class", rowClass).attr(" style", "width:100%").w((Object)">");
            HxOp childOp = op.make(p.getName(), target);
            childOp = childOp.mergeFacets(c.getSlotFacets((Slot)p));
            if ((c.getFlags((Slot)p) & 1) != 0) {
                childOp.setReadonly(true);
            }
            BHxFieldEditor editor = this.makeFor((BObject)obj, childOp, op);
            out.println("<span id='" + childOp.getPath() + "'>");
            if (UX_LOGGER.isLoggable(Level.FINE)) {
                if (editor instanceof BHxBajauxFE) {
                    out.println("ux");
                } else if (editor instanceof BHxDefaultFE) {
                    out.println("hx <b>readonly</b>");
                } else {
                    out.println("hx");
                }
            }
            try {
                editor.write(childOp);
            }
            catch (Exception e) {
                out.safe((Object)BAJAUI_LEX.getText("plugin.load.error", (Context)op));
                e.printStackTrace();
            }
            out.println("</span>");
            out.println("</td>");
            out.println("</tr>");
        }
        out.println("</table>");
        out.println("<br/>");
        out.println("<div style='text-align:center;'>");
        out.println("<input type='button' class='button' value='" + HX_LEX.getHtmlSafe("refresh", (Context)op) + "' onclick='window.location.reload();'/>");
        out.println("<input type='button' class='button' value='" + HX_LEX.getHtmlSafe("save", (Context)op) + "' onclick='hx.save();'/>");
        out.println("</div>");
        out.println("</div>");
    }

    protected BHxFieldEditor makeFor(BObject obj, HxOp op, HxOp parentOp) {
        ViewQuery query = parentOp.getViewQuery();
        if (query == null || query.getParameter("bajaux", "true").equals("true")) {
            op.mergeFacets(BHxFieldEditor.PREFER_BAJAUX);
        }
        try {
            return BHxFieldEditor.makeFor(obj, (Context)op);
        }
        catch (RuntimeException e) {
            return BHxDefaultFE.INSTANCE;
        }
    }

    @Override
    public boolean process(HxOp op) throws Exception {
        if (super.process(op)) {
            return true;
        }
        BIPropertyContainer c = (BIPropertyContainer)op.get();
        HtmlWriter out = op.getHtmlWriter();
        SlotCursor cur = c.getProperties();
        while (cur.next()) {
            Property p = cur.property();
            BValue obj = c.get(p);
            OrdTarget target = this.handleOrd(c, "slot:" + p.getName()).resolve((BObject)c, (Context)op);
            if (!target.canRead() || (c.getFlags((Slot)p) & 4) != 0 || obj.getType().is(BWsAnnotation.TYPE) || obj.getType().is(BAction.TYPE) || obj.getType().is(BTopic.TYPE) || obj.getType().is(BLink.TYPE)) continue;
            HxOp childOp = op.make(p.getName(), target);
            childOp = childOp.mergeFacets(c.getSlotFacets((Slot)p));
            if ((c.getFlags((Slot)p) & 1) != 0) {
                childOp.setReadonly(true);
            }
            BHxFieldEditor editor = this.makeFor((BObject)obj, childOp, op);
            try {
                if (!editor.process(childOp)) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    @Override
    public void update(HxOp op) throws Exception {
        BIPropertyContainer c = (BIPropertyContainer)op.get();
        HtmlWriter out = op.getHtmlWriter();
        SlotCursor cur = c.getProperties();
        while (cur.next()) {
            ViewQuery query;
            Property p = cur.property();
            BValue obj = c.get(p);
            OrdTarget target = this.handleOrd(c, "slot:" + p.getName()).resolve((BObject)c, (Context)op);
            if (!target.canRead() || (c.getFlags((Slot)p) & 4) != 0 || obj.getType().is(BWsAnnotation.TYPE) || obj.getType().is(BAction.TYPE) || obj.getType().is(BTopic.TYPE) || obj.getType().is(BLink.TYPE) || target.canWrite() && obj.isSimple()) continue;
            HxOp childOp = op.make(p.getName(), target);
            childOp = childOp.mergeFacets(c.getSlotFacets((Slot)p));
            if ((c.getFlags((Slot)p) & 1) != 0) {
                childOp.setReadonly(true);
            }
            if ((query = op.getViewQuery()) == null || query.getParameter("bajaux", "true").equals("true")) {
                childOp.mergeFacets(BHxFieldEditor.PREFER_BAJAUX);
            }
            BHxFieldEditor editor = this.makeFor((BObject)obj, childOp, op);
            editor.update(childOp);
        }
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        BIPropertyContainer c = (BIPropertyContainer)op.get();
        HtmlWriter out = op.getHtmlWriter();
        SlotCursor cur = c.getProperties();
        String name = "";
        try {
            while (cur.next()) {
                Property p = cur.property();
                BValue obj = c.get(p);
                name = p.getName();
                OrdTarget target = this.handleOrd(c, "slot:" + p.getName()).resolve((BObject)c, (Context)op);
                if (!target.canRead() || (c.getFlags((Slot)p) & 4) != 0 || (c.getFlags((Slot)p) & 1) != 0 || obj.getType().is(BWsAnnotation.TYPE) || obj.getType().is(BAction.TYPE) || obj.getType().is(BTopic.TYPE) || obj.getType().is(BLink.TYPE)) continue;
                HxOp childOp = op.make(p.getName(), target);
                childOp = childOp.mergeFacets(c.getSlotFacets((Slot)p));
                if ((c.getFlags((Slot)p) & 1) != 0) {
                    childOp.setReadonly(true);
                }
                BHxFieldEditor editor = this.makeFor((BObject)obj, childOp, op);
                BValue oldValue = c.get(p);
                BObject newValue = editor.fwSave(childOp);
                if ((newValue.isSimple() || c instanceof BComplex) && oldValue.equals((Object)newValue)) continue;
                c.set(p, (BValue)newValue, (Context)op);
            }
        }
        catch (CannotSaveException e) {
            String msg = BAJAUI_LEX.getText("plugin.saveProp.error", (Context)op, new Object[]{name}) + "  " + e.getMessage();
            throw new CannotSaveException(msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = BAJAUI_LEX.getText("plugin.saveProp.error", (Context)op, new Object[]{name});
            throw new CannotSaveException(msg, (Throwable)e);
        }
        return (BObject)c;
    }

    private BIcon findIcon(BIPropertyContainer container) {
        if (container instanceof BObject) {
            return ((BObject)container).getIcon();
        }
        if (container instanceof BINavNode) {
            return ((BINavNode)container).getNavIcon();
        }
        return DEFAULT_ICON;
    }

    private BOrd handleOrd(BIPropertyContainer container, String slotOrd) {
        BOrd handleOrd;
        if (container instanceof BComponent && (handleOrd = ((BComponent)container).getHandleOrd()) != null && !handleOrd.isNull()) {
            return BOrd.make((BOrd)handleOrd, (String)slotOrd);
        }
        if (container instanceof BINavNode) {
            return BOrd.make((BOrd)((BINavNode)container).getNavOrd(), (String)slotOrd);
        }
        return BOrd.NULL;
    }
}

