/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_Modbus_Tunnel.Communication;

import com.gc5.iSMA_Modbus_Tunnel.BIsmaModbusTunnel;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;

public class SerialCommunicationParametersModel {
    public String comPort;
    public BSerialBaudRate baudrate;
    public BSerialDataBits dataBits;
    public BSerialStopBits stopBits;
    public BSerialParity parityBits;
    public int timeout;
    public BIsmaModbusTunnel network;

    public SerialCommunicationParametersModel(String comPort, String baudrate, String dataBits, String stopBits, String parityBits, int timeout, BIsmaModbusTunnel network) {
        this.setComPort(comPort);
        this.setBaudrate(baudrate);
        this.setDataBits(dataBits);
        this.setStopBits(stopBits);
        this.setParityBits(parityBits);
        this.timeout = timeout;
        this.network = network;
    }

    private void setComPort(String comPort) {
        this.comPort = comPort.toUpperCase();
    }

    private void setBaudrate(String baudrate) {
        this.baudrate = BSerialBaudRate.make((int)Integer.parseInt(baudrate.replaceAll("[^\\d.]", "")));
    }

    private void setDataBits(String dataBits) {
        this.dataBits = BSerialDataBits.make((int)Integer.parseInt(Character.toString(dataBits.charAt(dataBits.length() - 1))));
    }

    private void setStopBits(String stopBits) {
        this.stopBits = BSerialStopBits.make((int)Integer.parseInt(Character.toString(stopBits.charAt(stopBits.length() - 1))));
    }

    private void setParityBits(String parity) {
        switch (parity.toLowerCase()) {
            case "none": {
                this.parityBits = BSerialParity.make((int)0);
                break;
            }
            case "odd": {
                this.parityBits = BSerialParity.make((int)1);
                break;
            }
            case "even": {
                this.parityBits = BSerialParity.make((int)2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Parity: " + parity);
            }
        }
    }
}

