/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_Modbus_Tunnel;

import com.gc5.iSMA_Modbus_Tunnel.AesHandshakeProvider;
import com.gc5.iSMA_Modbus_Tunnel.Communication.CRC16;
import com.gc5.iSMA_Modbus_Tunnel.Communication.SerialCommunication;
import com.gc5.iSMA_Modbus_Tunnel.Communication.SerialCommunicationParametersModel;
import com.gc5.iSMA_Modbus_Tunnel.SerialPortParameters.BBaudrate;
import com.gc5.iSMA_Modbus_Tunnel.SerialPortParameters.BDataBits;
import com.gc5.iSMA_Modbus_Tunnel.SerialPortParameters.BParityBits;
import com.gc5.iSMA_Modbus_Tunnel.SerialPortParameters.BStopBits;
import com.gc5.iSMA_Modbus_Tunnel.Status;
import com.tridium.nre.firewall.IpProtocol;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.firewall.BServerPort;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.serial.PortDeniedException;
import javax.baja.serial.PortNotFoundException;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", flags=65, defaultValue="BStatus.ok"), @NiagaraProperty(name="faultCause", type="String", flags=65, defaultValue=""), @NiagaraProperty(name="enabled", type="boolean", flags=264, defaultValue="true"), @NiagaraProperty(name="port", type="BServerPort", defaultValue="new BServerPort(502, IpProtocol.TCP)"), @NiagaraProperty(name="portCOM", type="String", defaultValue="COM1"), @NiagaraProperty(name="baudRate", type="BBaudrate", defaultValue="BBaudrate.Baud_115200"), @NiagaraProperty(name="dataBits", type="BDataBits", defaultValue="BDataBits.DataBits8"), @NiagaraProperty(name="stopBits", type="BStopBits", defaultValue="BStopBits.StopBits1"), @NiagaraProperty(name="parityBits", type="BParityBits", defaultValue="BParityBits.None"), @NiagaraProperty(name="retryCount", type="int", defaultValue="2", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="10")}), @NiagaraProperty(name="rsTimeout", type="int", defaultValue="1000", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")"), @Facet(name="BFacets.MIN", value="50")}), @NiagaraProperty(name="sendModbusErrors", type="boolean", defaultValue="true")})
public class BIsmaModbusTunnel
extends BComponent {
    public static final Property status = BIsmaModbusTunnel.newProperty((int)65, (BValue)BStatus.ok, null);
    public static final Property faultCause = BIsmaModbusTunnel.newProperty((int)65, (String)"", null);
    public static final Property enabled = BIsmaModbusTunnel.newProperty((int)264, (boolean)true, null);
    public static final Property port = BIsmaModbusTunnel.newProperty((int)0, (BValue)new BServerPort(502, IpProtocol.TCP), null);
    public static final Property portCOM = BIsmaModbusTunnel.newProperty((int)0, (String)"COM1", null);
    public static final Property baudRate = BIsmaModbusTunnel.newProperty((int)0, (BValue)BBaudrate.Baud_115200, null);
    public static final Property dataBits = BIsmaModbusTunnel.newProperty((int)0, (BValue)BDataBits.DataBits8, null);
    public static final Property stopBits = BIsmaModbusTunnel.newProperty((int)0, (BValue)BStopBits.StopBits1, null);
    public static final Property parityBits = BIsmaModbusTunnel.newProperty((int)0, (BValue)BParityBits.None, null);
    public static final Property retryCount = BIsmaModbusTunnel.newProperty((int)0, (int)2, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)10)));
    public static final Property rsTimeout = BIsmaModbusTunnel.newProperty((int)0, (int)1000, (BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")), (BFacets)BFacets.make((String)"min", (int)50)));
    public static final Property sendModbusErrors = BIsmaModbusTunnel.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BIsmaModbusTunnel.class);
    Runnable StartListening = this::startListening;
    SerialCommunication serialCommunication = null;
    Socket socket = null;
    Thread listenerThread;
    private boolean isNetworkStarted = false;
    private boolean keepAlive = false;
    private boolean failedToOpenComPort = false;
    private boolean failedToOpenSocket = false;
    private final AesHandshakeProvider handshakeProvider = new AesHandshakeProvider();
    private static String[] serialPorts = null;
    private static final int headerSize = 6;
    private final int lengthOfCrc = 2;
    private static final float MaxTimeoutUsedUpToRetry = 0.85f;
    private static final ArrayList<BIsmaModbusTunnel> existingIsmaTunnels = new ArrayList();
    private Status networkStatus;
    protected final Logger log = Logger.getLogger("iSMAModbusTunnel::iSMAModbusTunnel");
    public static final byte TUNNEL_DEVICE_ID = 127;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BServerPort getPort() {
        return (BServerPort)this.get(port);
    }

    public void setPort(BServerPort v) {
        this.set(port, (BValue)v, null);
    }

    public String getPortCOM() {
        return this.getString(portCOM);
    }

    public void setPortCOM(String v) {
        this.setString(portCOM, v, null);
    }

    public BBaudrate getBaudRate() {
        return (BBaudrate)this.get(baudRate);
    }

    public void setBaudRate(BBaudrate v) {
        this.set(baudRate, (BValue)v, null);
    }

    public BDataBits getDataBits() {
        return (BDataBits)this.get(dataBits);
    }

    public void setDataBits(BDataBits v) {
        this.set(dataBits, (BValue)v, null);
    }

    public BStopBits getStopBits() {
        return (BStopBits)this.get(stopBits);
    }

    public void setStopBits(BStopBits v) {
        this.set(stopBits, (BValue)v, null);
    }

    public BParityBits getParityBits() {
        return (BParityBits)this.get(parityBits);
    }

    public void setParityBits(BParityBits v) {
        this.set(parityBits, (BValue)v, null);
    }

    public int getRetryCount() {
        return this.getInt(retryCount);
    }

    public void setRetryCount(int v) {
        this.setInt(retryCount, v, null);
    }

    public int getRsTimeout() {
        return this.getInt(rsTimeout);
    }

    public void setRsTimeout(int v) {
        this.setInt(rsTimeout, v, null);
    }

    public boolean getSendModbusErrors() {
        return this.getBoolean(sendModbusErrors);
    }

    public void setSendModbusErrors(boolean v) {
        this.setBoolean(sendModbusErrors, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!this.isRunning()) {
            return;
        }
        BIsmaModbusTunnel.getAvailableSerialPorts();
        this.listenerThread = new Thread(this.StartListening);
        this.listenerThread.start();
        existingIsmaTunnels.add(this);
        this.isNetworkStarted = true;
        this.updateStatus();
    }

    private void performHandshake(Socket socket, byte[] headerData, byte[] data) {
        byte[] response;
        switch (data[1]) {
            case 3: {
                response = this.handleReadQuery(headerData, data);
                break;
            }
            case 16: {
                response = this.handleWriteQuery(headerData, data);
                break;
            }
            default: {
                response = this.prepareUnauthorizedResponse(headerData, data, (byte)10);
            }
        }
        try {
            socket.getOutputStream().write(response);
        }
        catch (IOException ex) {
            this.log.warning("Cannot respond to handshake: " + ex.getMessage());
        }
    }

    private byte[] handleReadQuery(byte[] headerData, byte[] data) {
        if (data.length != 6) {
            return this.prepareUnauthorizedResponse(headerData, data, (byte)10);
        }
        if (data[2] == 0 && data[3] == 0) {
            return this.prepareHandshakeWhoIsResponse(headerData);
        }
        return this.prepareHandshakeReadEncryptedResponse(headerData);
    }

    private byte[] handleWriteQuery(byte[] headerData, byte[] data) {
        if (data.length == 15) {
            byte[] authBytes = this.extractAuthBytes(data);
            if (this.handshakeProvider.handshakeResponseCheck(authBytes)) {
                return this.prepareAuthSuccessResponse(headerData, data);
            }
            return this.prepareAuthFailedResponse(headerData, data);
        }
        return this.prepareUnauthorizedResponse(headerData, data, (byte)10);
    }

    private byte[] prepareReadResponseData(byte macAddress, byte[] values) {
        byte[] responseData = new byte[3 + values.length];
        responseData[0] = macAddress;
        responseData[1] = 3;
        responseData[2] = (byte)values.length;
        System.arraycopy(values, 0, responseData, 3, values.length);
        return responseData;
    }

    private byte[] prepareWriteResponseData(byte macAddress, byte[] requestData) {
        byte[] responseData = new byte[6];
        responseData[0] = macAddress;
        System.arraycopy(requestData, 1, responseData, 1, 5);
        return responseData;
    }

    private byte[] prepareExceptionResponseData(byte macAddress, byte[] requestData, byte exceptionCode) {
        byte[] responseData = new byte[]{macAddress, (byte)(requestData[1] | 0x80), exceptionCode};
        return responseData;
    }

    private byte[] buildResponseFrame(byte[] requestHeader, byte[] responseData) {
        byte[] response = new byte[6 + responseData.length];
        System.arraycopy(requestHeader, 0, response, 0, requestHeader.length - 1);
        response[5] = (byte)responseData.length;
        System.arraycopy(responseData, 0, response, requestHeader.length, responseData.length);
        return response;
    }

    private byte[] prepareHandshakeWhoIsResponse(byte[] requestHeader) {
        byte[] responseData = this.prepareReadResponseData((byte)1, new byte[]{BIsmaModbusTunnel.getVersion(), 127});
        return this.buildResponseFrame(requestHeader, responseData);
    }

    private byte[] prepareHandshakeReadEncryptedResponse(byte[] requestHeader) {
        byte[] responseData = this.prepareReadResponseData((byte)1, this.handshakeProvider.getHandshakeEncryptedSecret());
        return this.buildResponseFrame(requestHeader, responseData);
    }

    private byte[] prepareAuthSuccessResponse(byte[] requestHeader, byte[] requestData) {
        byte[] responseData = this.prepareWriteResponseData((byte)1, requestData);
        return this.buildResponseFrame(requestHeader, responseData);
    }

    private byte[] prepareAuthFailedResponse(byte[] requestHeader, byte[] requestData) {
        byte[] responseData = this.prepareExceptionResponseData((byte)1, requestData, (byte)10);
        return this.buildResponseFrame(requestHeader, responseData);
    }

    private byte[] prepareUnauthorizedResponse(byte[] requestHeader, byte[] requestData, byte exceptionCode) {
        byte[] responseData = this.prepareExceptionResponseData((byte)1, requestData, exceptionCode);
        return this.buildResponseFrame(requestHeader, responseData);
    }

    private byte[] extractAuthBytes(byte[] requestData) {
        byte[] authBytes = new byte[8];
        System.arraycopy(requestData, 7, authBytes, 0, 8);
        return authBytes;
    }

    private boolean validateComPort() {
        if (serialPorts == null) {
            return false;
        }
        return Arrays.asList(serialPorts).contains(this.getPortCOM());
    }

    private boolean isComPortDuplicated() {
        for (BIsmaModbusTunnel ismaTunnel : existingIsmaTunnels) {
            if (ismaTunnel.equals((Object)this) || !ismaTunnel.getStatus().isOk() || !ismaTunnel.getPortCOM().equalsIgnoreCase(this.getPortCOM())) continue;
            this.networkStatus = Status.DUPLICATED_COM_PORT;
            this.setStatusAndFaultCauseSlots();
            return true;
        }
        return false;
    }

    private static void getAvailableSerialPorts() {
        if (serialPorts != null) {
            return;
        }
        serialPorts = SerialCommunication.getSerialPorts();
    }

    private boolean openSerialPort() {
        try {
            this.serialCommunication = new SerialCommunication(this.getCommunicationParametersModel());
            this.failedToOpenComPort = false;
        }
        catch (PortNotFoundException portNotFound) {
            this.failedToOpenComPort = true;
            this.log.severe("Failed to open " + this.getPortCOM() + " port. Port not found. " + portNotFound.getMessage());
        }
        catch (PortDeniedException portDenied) {
            this.failedToOpenComPort = true;
            this.log.severe("Failed to open " + this.getPortCOM() + " port. Port denied. " + portDenied.getMessage());
        }
        catch (Exception ex) {
            this.failedToOpenComPort = true;
            this.log.warning("Setting serial comm " + ex.getMessage());
        }
        return !this.failedToOpenComPort;
    }

    private void startListening() {
        ServerSocket serverSocket;
        if (!this.getEnabled() || !this.validateComPort() || this.isComPortDuplicated()) {
            return;
        }
        if (!this.openSerialPort()) {
            this.updateStatus();
            return;
        }
        try {
            serverSocket = this.getPort().getBindToLoopback() ? new ServerSocket(this.getPort().getBindingPort(), 1, InetAddress.getByName(null)) : new ServerSocket(this.getPort().getBindingPort(), 1);
            serverSocket.setSoTimeout(1000);
            this.failedToOpenSocket = false;
        }
        catch (Exception ex) {
            this.log.severe("Setting socket " + ex.getMessage());
            this.failedToOpenSocket = true;
            this.updateStatus();
            return;
        }
        byte[] headerData = new byte[6];
        this.keepAlive = true;
        block26: while (this.keepAlive) {
            try {
                this.socket = serverSocket.accept();
                this.socket.setSoTimeout(60000);
                this.log.finest("Accepted socket.");
                this.handshakeProvider.reset();
            }
            catch (SocketTimeoutException timeout) {
                continue;
            }
            catch (Exception ex) {
                this.log.warning("Socket accept and getting input and output streams " + ex.getMessage());
                continue;
            }
            while (this.keepAlive) {
                int retries;
                int dataReadFromTcp;
                block52: {
                    try {
                        dataReadFromTcp = this.socket.getInputStream().read(headerData, 0, headerData.length);
                        if (!this.keepAlive) continue block26;
                        if (dataReadFromTcp == -1) {
                            this.log.warning("End of stream has been reached.");
                            continue block26;
                        }
                        if (!this.validateHeader(headerData)) {
                            this.closeSocket();
                            continue block26;
                        }
                        if (dataReadFromTcp < 6) {
                            this.log.warning("Header length was too short: " + dataReadFromTcp + "(should be " + 6 + ")");
                            this.closeSocket();
                        }
                        break block52;
                    }
                    catch (Exception ex) {
                        this.log.warning("Reading header " + ex.getMessage());
                        this.closeSocket();
                    }
                    continue block26;
                }
                int dataLength = Byte.toUnsignedInt(headerData[5]);
                byte[] data = new byte[dataLength];
                try {
                    dataReadFromTcp = this.socket.getInputStream().read(data, 0, dataLength);
                    if (dataReadFromTcp != dataLength) {
                        this.log.warning("Data read not equal to information from header (" + dataReadFromTcp + "!=" + dataLength + ")");
                        this.closeSocket();
                        continue block26;
                    }
                    this.log.finest("From TCP: " + ByteArrayUtil.toHexString((byte[])headerData) + ByteArrayUtil.toHexString((byte[])data));
                }
                catch (Exception ex) {
                    this.log.warning("Reading content" + ex.getMessage());
                    continue block26;
                }
                if (!this.keepAlive) continue block26;
                if (dataReadFromTcp == -1) {
                    this.log.warning("End of stream has been reached.");
                    continue block26;
                }
                if (!this.handshakeProvider.isAuthorized()) {
                    this.performHandshake(this.socket, headerData, data);
                    continue;
                }
                boolean errorOccurred = false;
                for (retries = 0; retries < this.getRetryCount(); ++retries) {
                    try {
                        boolean didWriteSucceed = this.serialCommunication.write(data);
                        if (didWriteSucceed) break;
                        this.log.warning("Problem with writing to the device with address " + (data[0] & 0xFF));
                        continue;
                    }
                    catch (Exception ex) {
                        this.log.severe("Error in write " + ex.getMessage());
                        errorOccurred = true;
                        break;
                    }
                }
                if (errorOccurred || retries >= this.getRetryCount()) {
                    this.log.severe("Transmission error for device with address " + (data[0] & 0xFF));
                    continue;
                }
                byte[] response = null;
                boolean crcCheckPassed = false;
                if (this.isReadFileCommand(data)) {
                    this.WaitForModbusRtuResponse(data);
                }
                try (ByteArrayOutputStream readDataStream = new ByteArrayOutputStream();){
                    long readStartTime = System.currentTimeMillis();
                    do {
                        byte[] receivedBytes;
                        if ((receivedBytes = this.serialCommunication.receive()) == null) continue;
                        readDataStream.write(receivedBytes);
                    } while (!(crcCheckPassed = this.validateCrcOfResponse(readDataStream.toByteArray())) && (float)(System.currentTimeMillis() - readStartTime) < (float)this.getRsTimeout() * 0.85f);
                    response = readDataStream.toByteArray();
                }
                catch (Exception ex) {
                    this.log.severe("Error in read " + ex.getMessage());
                }
                boolean nullResponseFromRtu = false;
                if (response == null || response.length == 0) {
                    if (this.getSendModbusErrors()) {
                        nullResponseFromRtu = true;
                        this.log.warning("Null response from Serial. Sending back Modbus error.");
                    } else {
                        this.log.warning("Null response from Serial. Coming back to listening from TCP.");
                        continue;
                    }
                }
                try {
                    byte[] responseForTcp;
                    boolean shouldSendModbusError = false;
                    if (nullResponseFromRtu) {
                        shouldSendModbusError = true;
                    } else if (!crcCheckPassed) {
                        this.log.severe("CRC from RTU was invalid.");
                        if (!this.getSendModbusErrors()) continue;
                        shouldSendModbusError = true;
                    }
                    if (!shouldSendModbusError) {
                        responseForTcp = new byte[6 + response.length - 2];
                        System.arraycopy(headerData, 0, responseForTcp, 0, headerData.length - 1);
                        responseForTcp[5] = (byte)(response.length - 2);
                        System.arraycopy(response, 0, responseForTcp, headerData.length, response.length - 2);
                    } else {
                        byte[] modbusErrorFrame = BIsmaModbusTunnel.getModbusErrorFrame(data[0], data[1]);
                        responseForTcp = new byte[6 + modbusErrorFrame.length];
                        System.arraycopy(headerData, 0, responseForTcp, 0, headerData.length - 1);
                        responseForTcp[5] = (byte)modbusErrorFrame.length;
                        System.arraycopy(modbusErrorFrame, 0, responseForTcp, headerData.length, modbusErrorFrame.length);
                    }
                    this.socket.getOutputStream().write(responseForTcp);
                    this.log.finest("TO TCP: " + ByteArrayUtil.toHexString((byte[])responseForTcp));
                }
                catch (Exception ex) {
                    this.log.warning("Writing output stream " + ex.getMessage());
                    continue block26;
                }
            }
        }
        try {
            if (!serverSocket.isClosed()) {
                serverSocket.close();
            }
            this.endTransmission();
        }
        catch (Exception ex) {
            this.log.warning("Closing server socket: " + ex.getMessage());
        }
    }

    private void endTransmission() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception ex) {
            this.log.severe("Closing socket: " + ex.getMessage());
        }
        try {
            if (this.serialCommunication != null) {
                this.serialCommunication.close();
            }
        }
        catch (Exception ex) {
            this.log.severe("Closing COM port: " + ex.getMessage());
        }
    }

    private void closeSocket() {
        try {
            if (this.socket == null || !this.socket.isConnected()) {
                return;
            }
            this.socket.close();
            this.log.warning("Socket closed");
        }
        catch (Exception ex) {
            this.log.warning("Unable to close socket " + ex.getMessage());
        }
    }

    private boolean validateHeader(byte[] tcpHeader) {
        if (tcpHeader == null || tcpHeader.length != 6 || tcpHeader[2] != 0 || tcpHeader[3] != 0 || tcpHeader[4] != 0) {
            this.log.warning("Wrong data in the header, not proper Modbus gateway frame.");
            return false;
        }
        int dataLength = Byte.toUnsignedInt(tcpHeader[5]);
        if (dataLength < 2 || dataLength > 254) {
            this.log.warning("Length of the frame indicated in header was wrong - " + dataLength + " should be between 2 and 254.");
            return false;
        }
        return true;
    }

    private boolean isReadFileCommand(byte[] request) {
        if (request == null || request.length < 2) {
            return false;
        }
        return request[1] == 103;
    }

    private void WaitForModbusRtuResponse(byte[] request) {
        try {
            int expectedFileLength = Byte.toUnsignedInt(request[6]);
            int dataLength = (4 + expectedFileLength + 2) * 10;
            long timeToSleep = (long)((double)((float)dataLength / this.getBaudrateAsFloat() * 1000.0f) * 1.3);
            Thread.sleep(timeToSleep);
        }
        catch (Exception ex) {
            this.log.severe("Waiting for Modbus Rtu response " + ex.getMessage());
        }
    }

    private float getBaudrateAsFloat() {
        String baudrateTag = this.getBaudRate().getTag();
        String[] parts = baudrateTag.split("_");
        try {
            return Float.parseFloat(parts[1]);
        }
        catch (Exception ex) {
            this.log.severe("Getting baudrate " + ex.getMessage());
            return 115200.0f;
        }
    }

    private boolean validateCrcOfResponse(byte[] responseFromRtu) {
        try {
            int crcOfResponse = CRC16.calc(responseFromRtu, 0, responseFromRtu.length - 2);
            byte firstByteOfResponseCrc = (byte)(crcOfResponse & 0xFF);
            byte secondByteOfResponseCrc = (byte)(crcOfResponse >> 8 & 0xFF);
            byte firstByteFromResponseCrc = responseFromRtu[responseFromRtu.length - 2];
            byte secondByteFromResponseCrc = responseFromRtu[responseFromRtu.length - 1];
            return firstByteOfResponseCrc == firstByteFromResponseCrc && secondByteOfResponseCrc == secondByteFromResponseCrc;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static byte[] getModbusErrorFrame(byte slaveAddress, byte function) {
        return new byte[]{slaveAddress, (byte)(function + 128), 11};
    }

    private SerialCommunicationParametersModel getCommunicationParametersModel() {
        return new SerialCommunicationParametersModel(this.getPortCOM(), this.getBaudRate().getTag(), this.getDataBits().getTag(), this.getStopBits().getTag(), this.getParityBits().getTag(), this.getRsTimeout(), this);
    }

    public void changed(Property property, Context context) {
        if (!this.shouldProcessChangedEvent(property)) {
            return;
        }
        if (property == enabled && !this.getEnabled()) {
            this.stopTransmission();
            this.updateStatus();
            return;
        }
        if (property == enabled || property == port || property == portCOM || property == baudRate || property == dataBits || property == stopBits || property == parityBits || property == retryCount || property == rsTimeout) {
            try {
                this.stopTransmission();
                if (this.validateComPort() && !this.isComPortDuplicated()) {
                    this.listenerThread = null;
                    this.listenerThread = new Thread(this.StartListening);
                    this.listenerThread.start();
                }
            }
            catch (Exception ex) {
                this.log.severe("Handling changed event: " + ex.getMessage());
            }
        }
        this.updateStatus();
    }

    public void stopped() {
        this.stopTransmission();
        existingIsmaTunnels.remove((Object)this);
    }

    private void stopTransmission() {
        this.keepAlive = false;
        try {
            this.listenerThread.join();
            this.endTransmission();
        }
        catch (Exception ex) {
            this.log.warning("Stopping transmission: " + ex.getMessage());
        }
        this.log.finest("Stopped transmission");
    }

    private boolean shouldProcessChangedEvent(Property property) {
        return this.isRunning() && this.isNetworkStarted && property != status && property != faultCause;
    }

    private void updateStatus() {
        this.networkStatus = !this.getEnabled() ? Status.DISABLED : (!this.validateComPort() ? Status.INVALID_PORT : (this.isComPortDuplicated() ? Status.DUPLICATED_COM_PORT : (this.failedToOpenComPort ? Status.COULD_NOT_OPEN_COM_PORT : (this.failedToOpenSocket ? Status.COULD_NOT_OPEN_SOCKET : Status.OK))));
        this.setStatusAndFaultCauseSlots();
    }

    protected void setStatusAndFaultCauseSlots() {
        this.setStatus(this.networkStatus.getStatus());
        this.setFaultCause(this.networkStatus.getMessage());
    }

    public static byte getVersion() {
        String versionString = "1.0";
        versionString = versionString.replaceAll("[^0-9]", "");
        try {
            return Byte.parseByte(versionString);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }
}

