/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.iSMA_Modbus_Tunnel;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class AesHandshakeProvider {
    private boolean isAuthorized = false;
    private final byte[] aesKey = new byte[]{25, -60, 7, 38, 111, -34, 30, 6, 56, 41, -22, 111, -92, -87, 121, 99};
    private byte[] handshakeSecret = new byte[8];
    private byte[] handshakeEncryptedSecret;
    protected final Logger log = Logger.getLogger("iSMAModbusTunnel::AesHandshakeProvider");

    public boolean isAuthorized() {
        return this.isAuthorized;
    }

    public byte[] getHandshakeEncryptedSecret() {
        return this.handshakeEncryptedSecret;
    }

    public void reset() {
        try {
            this.isAuthorized = false;
            Random randomGen = new Random(System.currentTimeMillis());
            randomGen.nextBytes(this.handshakeSecret);
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            Cipher aesCipher = Cipher.getInstance("AES");
            aesCipher.init(1, keySpec);
            this.handshakeEncryptedSecret = aesCipher.doFinal(this.handshakeSecret);
            this.log.finest("Initialized new Handshake.");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException ex) {
            this.log.severe("Could not initialize aes cipher: " + ex.getMessage());
        }
        catch (InvalidKeyException ex) {
            this.log.severe("Invalid aes key: " + ex.getMessage());
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            this.log.severe("Error encrypting handshake secret: " + ex.getMessage());
        }
    }

    public boolean handshakeResponseCheck(byte[] decodedSecret) {
        if (Arrays.equals(decodedSecret, this.handshakeSecret)) {
            this.isAuthorized = true;
            return true;
        }
        this.reset();
        return false;
    }
}

