/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaraSystemIndex;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.fox.sys.data.BIPostQueryFilter;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.util.BNiagaraRemoteQueryFilter;
import com.tridium.niagaraSystemIndex.BNiagaraSystemIndexDescriptor;
import com.tridium.niagaraSystemIndex.BNiagaraSystemIndexDeviceExt;
import com.tridium.systemIndex.BLocalSystemIndexer;
import com.tridium.systemIndex.SystemIndexLog;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nav.BINavNode;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BNiagaraSystemIndexExport
extends BNiagaraSystemIndexDescriptor {
    public static final Type TYPE = Sys.loadType(BNiagaraSystemIndexExport.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"index.png"), (BIcon)BIcon.std((String)"badges/export.png"));
    private static final BOrdList exportConsumerOrds = BOrdList.make((BOrd)BOrd.make((String)("slot:" + BNiagaraSystemIndexDeviceExt.TYPE.toString().replace(':', '_'))));
    private static final BNiagaraRemoteQueryFilter exportFilter = BNiagaraRemoteQueryFilter.make((boolean)true, (boolean)false);

    @Override
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeIndex(SystemIndexLog log, Context cx) throws Exception {
        block12: {
            BFoxClientConnection connection = ((BNiagaraStation)this.getDevice()).getClientConnection();
            try {
                connection.engageNoRetry((BFoxClientConnection.Interest)this);
                BDataChannel channel = (BDataChannel)connection.getChannels().get("data", BDataChannel.TYPE);
                if (channel.canExportEntities(exportConsumerOrds)) {
                    try (Stream<Entity> entities = BLocalSystemIndexer.resolveLocalIndexQueries((BOrdList)this.getOperationalIndexQueries(), (boolean)false, (Context)cx);){
                        AtomicInteger counter = new AtomicInteger();
                        if (log.isLoggingEnabled()) {
                            entities = entities.peek(e -> {
                                BOrd o;
                                counter.incrementAndGet();
                                BOrd bOrd = o = e instanceof BINavNode ? ((BINavNode)e).getNavOrd() : (BOrd)e.getOrdToEntity().orElse(null);
                                if (o != null) {
                                    o = o.relativizeToSession();
                                }
                                log.message("niagaraSystemIndex", "niagaraSystemIndex.indexExport.exportedEntity", o.toString());
                            });
                        }
                        channel.exportEntities(exportConsumerOrds, entities, cx, new BIPostQueryFilter[]{exportFilter});
                        if (log.isLoggingEnabled()) {
                            String stationName = ((BINiagaraStation)this.getDevice()).getStationName();
                            log.message("niagaraSystemIndex", "niagaraSystemIndex.indexExport.numEntitiesExported", new String[]{counter.toString(), stationName});
                        }
                        break block12;
                    }
                }
                if (log.isLoggingEnabled()) {
                    log.failed("niagaraDriver", "niagaraSystemIndex.exportDisabled");
                }
                throw new LocalizableRuntimeException("niagaraDriver", "niagaraSystemIndex.exportDisabled");
            }
            finally {
                if (connection != null && connection.isEngaged((BFoxClientConnection.Interest)this)) {
                    connection.disengage((BFoxClientConnection.Interest)this);
                }
            }
        }
    }

    protected String getIndexDescription(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("niagaraSystemIndex.indexExport", new Object[]{this.getDevice().getName()});
    }

    public BIcon getIcon() {
        return icon;
    }
}

