/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaraSystemIndex;

import com.tridium.driver.util.DrUtil;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.fox.sys.data.BIPostQueryFilter;
import com.tridium.fox.sys.data.BIPreQueryValidator;
import com.tridium.fox.sys.data.EntityExportConsumer;
import com.tridium.fox.sys.data.EntityExportSource;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNSpaceScheme;
import com.tridium.nd.BNiagaraEdgeLiteStation;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.util.BNiagaraRemoteQueryFilter;
import com.tridium.nd.virtual.BNiagaraVirtualDeviceExt;
import com.tridium.niagaraSystemIndex.BNiagaraNetworkSystemIndexer;
import com.tridium.niagaraSystemIndex.BNiagaraSystemIndexExport;
import com.tridium.niagaraSystemIndex.BNiagaraSystemIndexImport;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.metrics.BISubLicenseable;
import com.tridium.systemDb.BSystemDb;
import com.tridium.systemIndex.BSystemIndexService;
import com.tridium.systemIndex.BSystemIndexer;
import com.tridium.systemIndex.SystemIndexLog;
import com.tridium.systemIndex.SystemIndexUtil;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.category.BICategorizable;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.util.BDescriptorDeviceExt;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relations;
import javax.baja.tag.Tags;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.virtual.VirtualPath;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraStation"})})
@NiagaraProperties(value={@NiagaraProperty(name="globalIndexStatus", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="globalIndexState", type="BDescriptorState", defaultValue="BDescriptorState.idle", flags=1), @NiagaraProperty(name="globalIndexLastAttempt", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="globalIndexLastSuccess", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="globalIndexLastFailure", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="globalIndexFaultCause", type="String", defaultValue="", flags=3, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="acceptsGlobalIndexRequests", type="boolean", defaultValue="true"), @NiagaraProperty(name="receiveExportedIndexLastAttempt", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="receiveExportedIndexLastSuccess", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="receiveExportedIndexLastFailure", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="receiveExportedIndexFaultCause", type="String", defaultValue="", flags=3, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="receiveExportedIndexFromRemoteStation", type="boolean", defaultValue="false")})
@NiagaraAction(name="executeGlobalIndexOnThisStation", flags=16)
public final class BNiagaraSystemIndexDeviceExt
extends BDescriptorDeviceExt
implements BIStatus,
BINiagaraDeviceExt,
BIMixIn,
BIRestrictedComponent,
BISubLicenseable,
BFoxClientConnection.Interest,
EntityExportConsumer,
EntityExportSource {
    public static final Property globalIndexStatus = BNiagaraSystemIndexDeviceExt.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property globalIndexState = BNiagaraSystemIndexDeviceExt.newProperty((int)1, (BValue)BDescriptorState.idle, null);
    public static final Property globalIndexLastAttempt = BNiagaraSystemIndexDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property globalIndexLastSuccess = BNiagaraSystemIndexDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property globalIndexLastFailure = BNiagaraSystemIndexDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property globalIndexFaultCause = BNiagaraSystemIndexDeviceExt.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property acceptsGlobalIndexRequests = BNiagaraSystemIndexDeviceExt.newProperty((int)0, (boolean)true, null);
    public static final Property receiveExportedIndexLastAttempt = BNiagaraSystemIndexDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property receiveExportedIndexLastSuccess = BNiagaraSystemIndexDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property receiveExportedIndexLastFailure = BNiagaraSystemIndexDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property receiveExportedIndexFaultCause = BNiagaraSystemIndexDeviceExt.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property receiveExportedIndexFromRemoteStation = BNiagaraSystemIndexDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Action executeGlobalIndexOnThisStation = BNiagaraSystemIndexDeviceExt.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BNiagaraSystemIndexDeviceExt.class);
    private static BCategoryService categoryService;
    private static BNiagaraNetwork niagaraNetwork;
    private static final BIcon icon;
    private static final Version VER_4_4;
    private static final Id nStationId;
    private static final Map<String, Integer> entitiesPerStationLimit;
    private final AtomicBoolean checkedLicense = new AtomicBoolean();
    private volatile String fatalFault;
    private long numGlobalExecutes;
    private long totalGlobalExecuteTime;
    private long minGlobalExecuteTime = Long.MAX_VALUE;
    private long maxGlobalExecuteTime;
    private long numExportExecutes;
    private long totalExportExecuteTime;
    private long minExportExecuteTime = Long.MAX_VALUE;
    private long maxExportExecuteTime;

    public BStatus getGlobalIndexStatus() {
        return (BStatus)this.get(globalIndexStatus);
    }

    public void setGlobalIndexStatus(BStatus v) {
        this.set(globalIndexStatus, (BValue)v, null);
    }

    public BDescriptorState getGlobalIndexState() {
        return (BDescriptorState)this.get(globalIndexState);
    }

    public void setGlobalIndexState(BDescriptorState v) {
        this.set(globalIndexState, (BValue)v, null);
    }

    public BAbsTime getGlobalIndexLastAttempt() {
        return (BAbsTime)this.get(globalIndexLastAttempt);
    }

    public void setGlobalIndexLastAttempt(BAbsTime v) {
        this.set(globalIndexLastAttempt, (BValue)v, null);
    }

    public BAbsTime getGlobalIndexLastSuccess() {
        return (BAbsTime)this.get(globalIndexLastSuccess);
    }

    public void setGlobalIndexLastSuccess(BAbsTime v) {
        this.set(globalIndexLastSuccess, (BValue)v, null);
    }

    public BAbsTime getGlobalIndexLastFailure() {
        return (BAbsTime)this.get(globalIndexLastFailure);
    }

    public void setGlobalIndexLastFailure(BAbsTime v) {
        this.set(globalIndexLastFailure, (BValue)v, null);
    }

    public String getGlobalIndexFaultCause() {
        return this.getString(globalIndexFaultCause);
    }

    public void setGlobalIndexFaultCause(String v) {
        this.setString(globalIndexFaultCause, v, null);
    }

    public boolean getAcceptsGlobalIndexRequests() {
        return this.getBoolean(acceptsGlobalIndexRequests);
    }

    public void setAcceptsGlobalIndexRequests(boolean v) {
        this.setBoolean(acceptsGlobalIndexRequests, v, null);
    }

    public BAbsTime getReceiveExportedIndexLastAttempt() {
        return (BAbsTime)this.get(receiveExportedIndexLastAttempt);
    }

    public void setReceiveExportedIndexLastAttempt(BAbsTime v) {
        this.set(receiveExportedIndexLastAttempt, (BValue)v, null);
    }

    public BAbsTime getReceiveExportedIndexLastSuccess() {
        return (BAbsTime)this.get(receiveExportedIndexLastSuccess);
    }

    public void setReceiveExportedIndexLastSuccess(BAbsTime v) {
        this.set(receiveExportedIndexLastSuccess, (BValue)v, null);
    }

    public BAbsTime getReceiveExportedIndexLastFailure() {
        return (BAbsTime)this.get(receiveExportedIndexLastFailure);
    }

    public void setReceiveExportedIndexLastFailure(BAbsTime v) {
        this.set(receiveExportedIndexLastFailure, (BValue)v, null);
    }

    public String getReceiveExportedIndexFaultCause() {
        return this.getString(receiveExportedIndexFaultCause);
    }

    public void setReceiveExportedIndexFaultCause(String v) {
        this.setString(receiveExportedIndexFaultCause, v, null);
    }

    public boolean getReceiveExportedIndexFromRemoteStation() {
        return this.getBoolean(receiveExportedIndexFromRemoteStation);
    }

    public void setReceiveExportedIndexFromRemoteStation(boolean v) {
        this.setBoolean(receiveExportedIndexFromRemoteStation, v, null);
    }

    public void executeGlobalIndexOnThisStation() {
        this.invoke(executeGlobalIndexOnThisStation, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    boolean canAcceptGlobalQueries(SystemIndexLog log, Context cx) {
        if (!this.getAcceptsGlobalIndexRequests() || this.isDisabled()) {
            if (log.isLoggingEnabled()) {
                log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.disabled", new String[]{this.getDevice().getName()});
            }
            return false;
        }
        if (this.getDevice().isFatalFault()) {
            if (log.isLoggingEnabled()) {
                log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.fatalFault", new String[]{this.getDevice().getName()});
            }
            return false;
        }
        BSystemIndexService indexService = BNiagaraSystemIndexDeviceExt.getSystemIndexService(false);
        if (indexService == null || !indexService.isOperational()) {
            String lexKey = indexService == null ? "systemIndex.missingSystemIndex" : "systemIndex.inoperableSystemIndex";
            this.setGlobalIndexFaultCause(Lexicon.make((String)"systemIndex", (Context)cx).getText(lexKey));
            if (log.isLoggingEnabled()) {
                log.message("systemIndex", lexKey);
            }
            return false;
        }
        if (!this.remoteStationSupportsIndexing(log)) {
            return false;
        }
        if (this.hasEnabledEntityImport()) {
            this.setGlobalIndexFaultCause(Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("niagaraSystemIndex.indexSkipped.importExists"));
            if (log.isLoggingEnabled()) {
                log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.importExists", new String[]{this.getDevice().getName()});
            }
            return false;
        }
        try {
            this.checkLicenseForIndexing();
        }
        catch (Exception e) {
            this.setGlobalIndexFaultCause(SystemIndexUtil.getFailureReason((Throwable)e));
            if (log.isLoggingEnabled()) {
                log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.fatalFault", new String[]{this.getDevice().getName()});
            }
            return false;
        }
        return true;
    }

    private boolean hasEnabledEntityImport() {
        SlotCursor props = this.getProperties();
        while (props.next(BNiagaraSystemIndexImport.class)) {
            if (((BNiagaraSystemIndexImport)props.get()).isUnoperational()) continue;
            return true;
        }
        return false;
    }

    void executeGlobalIndex(BOrdList indexQueries, SystemIndexLog log, Context cx) {
        if (!this.isDown() && this.canAcceptGlobalQueries(log, cx)) {
            long start = DiagnosticUtil.startIfLoggable((String)"systemIndexDeviceExt_executeGlobal");
            long startTicks = Clock.ticks();
            BFoxClientConnection connection = ((BNiagaraStation)this.getDevice()).getClientConnection();
            try {
                this.executeInProgress();
                int limit = this.checkLicenseForIndexing();
                BNiagaraSystemIndexDeviceExt.getCategoryService(true);
                BNiagaraSystemIndexDeviceExt.getNiagaraNetwork(true);
                if (log.isLoggingEnabled()) {
                    log.start("systemIndex", "systemIndex.job.startFullIndex", new String[]{'\"' + this.getDevice().getName() + '\"', indexQueries.toString(cx)});
                }
                connection.engageNoRetry((BFoxClientConnection.Interest)this);
                BDataChannel channel = (BDataChannel)connection.getChannels().get("data", BDataChannel.TYPE);
                BNiagaraRemoteQueryFilter[] queryFilters = new BNiagaraRemoteQueryFilter[]{BNiagaraRemoteQueryFilter.make((boolean)true, (boolean)this.getReceiveExportedIndexFromRemoteStation())};
                List entitiesList = channel.resolveEntitiesToList(indexQueries, 0, -1, (BIPreQueryValidator[])queryFilters, (BIPostQueryFilter[])queryFilters);
                int size = limit != Integer.MAX_VALUE ? entitiesList.size() : -1;
                String stationNameStr = ((BINiagaraStation)this.getDevice()).getStationName();
                connection.disengage((BFoxClientConnection.Interest)this);
                BSystemIndexer.systemIndexToSystemDb((String)stationNameStr, BNiagaraSystemIndexDeviceExt.toEntityStream(stationNameStr, entitiesList, size, limit), (SystemIndexLog)log, (Context)SystemIndexContextHolder.INDEX_CONTEXT);
                this.executeOk();
                if (size > limit) {
                    String[] args = new String[]{this.getDevice().getName(), Integer.toString(size), Integer.toString(limit)};
                    this.setGlobalIndexFaultCause(Lexicon.make((String)"systemIndex").getText("systemIndex.exceededEntityLimit", (Object[])args));
                    if (log.isLoggingEnabled()) {
                        log.message("systemIndex", "systemIndex.exceededEntityLimit.noLineFeeds", args);
                    }
                }
                if (log.isLoggingEnabled()) {
                    log.success("systemIndex", "systemIndex.job.completeFullIndex", new String[]{'\"' + this.getDevice().getName() + '\"', indexQueries.toString(cx)});
                }
            }
            catch (Throwable th) {
                Throwable t = SystemIndexUtil.processAndLogSystemIndexError((Throwable)th, (BComponent)this.getDevice());
                this.executeFail(t);
                if (log.isLoggingEnabled()) {
                    log.failed("systemIndex", "systemIndex.job.failedFullIndex", new String[]{'\"' + this.getDevice().getName() + '\"', indexQueries.toString(cx)}, t);
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new BajaRuntimeException(t.getLocalizedMessage(), t);
            }
            finally {
                if (connection != null && connection.isEngaged((BFoxClientConnection.Interest)this)) {
                    connection.disengage((BFoxClientConnection.Interest)this);
                }
                if (start != 0L) {
                    DiagnosticUtil.complete((long)start, (String)"systemIndexDeviceExt_executeGlobal", (Object)this.toPathString());
                }
                this.updateGlobalStatistics(startTicks);
            }
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (executeGlobalIndexOnThisStation.equals(action)) {
            if (this.isDown() || this.getGlobalIndexState() != BDescriptorState.idle || !this.canAcceptGlobalQueries(SystemIndexLog.DEFAULT_SYSTEM_INDEX_LOG, cx)) {
                if (!this.isDown()) {
                    BSystemIndexService indexService = BNiagaraSystemIndexDeviceExt.getSystemIndexService(false);
                    if (indexService == null) {
                        this.executeFail(Lexicon.make((String)"systemIndex").getText("systemIndex.missingSystemIndex"));
                    } else if (indexService.isFatalFault()) {
                        this.executeFail(Lexicon.make((String)"systemIndex").getText("systemIndex.inoperableSystemIndex"));
                    } else if (this.fatalFault != null) {
                        this.executeFail(this.getGlobalIndexFaultCause());
                    }
                }
                return null;
            }
            try {
                this.executePending();
                this.getGlobalNiagaraNetworkIndexer(cx).validateIndexQueries(cx);
                BSystemIndexService service = BNiagaraSystemIndexDeviceExt.getSystemIndexService(true);
                BNiagaraNetworkSystemIndexer.executeAsync(service, (Runnable)new Invocation((BComponent)this, action, arg, cx));
                return null;
            }
            catch (Exception e) {
                this.setGlobalIndexLastAttempt(Clock.time());
                this.executeFail(e);
                return null;
            }
        }
        return super.post(action, arg, cx);
    }

    public void doExecuteGlobalIndexOnThisStation(Context cx) {
        if (this.canAcceptGlobalQueries(SystemIndexLog.DEFAULT_SYSTEM_INDEX_LOG, cx)) {
            BSystemIndexer.runIndex((String)Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("niagaraSystemIndex.individualGlobalIndex", new Object[]{this.getDevice().getName()}), (Context)cx, (log, context) -> this.executeGlobalIndex(this.getGlobalNiagaraNetworkIndexer((Context)context).getOperationalIndexQueries(), (SystemIndexLog)log, (Context)context));
        }
    }

    static BSystemIndexService getSystemIndexService(boolean failOnMissing) {
        BSystemIndexService service = null;
        try {
            service = (BSystemIndexService)Sys.getService((Type)BSystemIndexService.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (failOnMissing && service == null) {
            throw new LocalizableRuntimeException("niagaraSystemIndex", "niagaraSystemIndex.unavailableSystemIndexService");
        }
        return service;
    }

    private BNiagaraNetworkSystemIndexer getGlobalNiagaraNetworkIndexer(Context cx) {
        BNiagaraNetworkSystemIndexer indexer = null;
        try {
            indexer = (BNiagaraNetworkSystemIndexer)BOrd.make((String)"service:niagaraSystemIndex:NiagaraNetworkSystemIndexSource|slot:globalNiagaraNetworkIndexer").get((BObject)this, cx);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (indexer == null) {
            throw new LocalizableRuntimeException("niagaraSystemIndex", "niagaraSystemIndex.unavailableGlobalIndexer");
        }
        return indexer;
    }

    private void executeOk() {
        this.setGlobalIndexFaultCause("");
        this.setGlobalIndexLastSuccess(Clock.time());
        this.setGlobalIndexState(BDescriptorState.idle);
        this.updateStatus();
    }

    private void executeFail(Throwable ex) {
        this.executeFail(SystemIndexUtil.getFailureReason((Throwable)ex));
    }

    private void executeFail(String reason) {
        this.setGlobalIndexLastFailure(Clock.time());
        this.setGlobalIndexFaultCause(reason);
        this.setGlobalIndexState(BDescriptorState.idle);
        this.updateStatus();
    }

    private void executeInProgress() {
        this.setGlobalIndexLastAttempt(Clock.time());
        this.setGlobalIndexState(BDescriptorState.inProgress);
    }

    void executePending() {
        this.setGlobalIndexState(BDescriptorState.pending);
    }

    public BStatus getStatus() {
        return this.getGlobalIndexStatus();
    }

    public void started() {
        if (this.getGlobalIndexState() != BDescriptorState.idle) {
            this.executeFail(Lexicon.make((String)"niagaraSystemIndex").getText("niagaraSystemIndex.indexFailure.interrupted"));
        } else {
            this.updateStatus();
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && acceptsGlobalIndexRequests.equals(property)) {
            this.updateStatus();
        }
        super.changed(property, context);
    }

    public boolean isFault() {
        return this.getGlobalIndexStatus().isFault();
    }

    public boolean isDisabled() {
        return this.getGlobalIndexStatus().isDisabled();
    }

    public boolean isDown() {
        return this.getGlobalIndexStatus().isDown();
    }

    public void updateStatus() {
        super.updateStatus();
        int newStatus = this.getGlobalIndexStatus().getBits();
        BStatus deviceStatus = this.getDevice().getStatus();
        newStatus = deviceStatus.isDisabled() || !this.getAcceptsGlobalIndexRequests() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = deviceStatus.isDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        newStatus = this.fatalFault != null || !this.getGlobalIndexLastFailure().isNull() && this.getGlobalIndexLastFailure().isAfter(this.getGlobalIndexLastSuccess()) || deviceStatus.isFault() || !this.remoteStationSupportsIndexing(SystemIndexLog.DEFAULT_SYSTEM_INDEX_LOG) ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == this.getGlobalIndexStatus().getBits()) {
            return;
        }
        this.setGlobalIndexStatus(BStatus.make((int)newStatus));
    }

    private boolean remoteStationSupportsIndexing(SystemIndexLog log) {
        BNiagaraStation station = (BNiagaraStation)this.getDevice();
        String remoteVersionStr = station.getVersion();
        if (!remoteVersionStr.isEmpty() && new Version(remoteVersionStr).compareTo(VER_4_4) < 0) {
            if (this.getGlobalIndexFaultCause().isEmpty()) {
                this.setGlobalIndexFaultCause(Lexicon.make((BModule)TYPE.getModule(), (Context)null).getText("niagaraSystemIndex.incompatibleVersion", new Object[]{remoteVersionStr, VER_4_4}));
            }
            if (log.isLoggingEnabled()) {
                log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.versionMismatch", new String[]{this.getDevice().getName(), remoteVersionStr, VER_4_4.toString()});
            }
            return false;
        }
        return true;
    }

    public boolean canAcceptEntitiesFromRemoteExport(Context cx) {
        boolean result;
        BSystemIndexService indexService = BNiagaraSystemIndexDeviceExt.getSystemIndexService(false);
        boolean bl = result = this.getReceiveExportedIndexFromRemoteStation() && indexService != null && indexService.isOperational() && !this.getDevice().isDisabled() && !this.getDevice().isFatalFault();
        if (result) {
            try {
                this.checkLicenseForIndexing();
            }
            catch (Exception e) {
                this.setReceiveExportedIndexLastAttempt(Clock.time());
                this.setReceiveExportedIndexLastFailure(Clock.time());
                this.setReceiveExportedIndexFaultCause(SystemIndexUtil.getFailureReason((Throwable)e));
                return false;
            }
        }
        return result;
    }

    public void consumeEntitiesFromRemoteExport(List<Entity> entities, Context cx) {
        if (!this.canAcceptEntitiesFromRemoteExport(cx)) {
            return;
        }
        BNiagaraNetworkSystemIndexer.executeAsync((BSystemIndexService)Sys.getService((Type)BSystemIndexService.TYPE), () -> {
            long startTicks = Clock.ticks();
            this.setReceiveExportedIndexLastAttempt(Clock.time());
            this.setReceiveExportedIndexFaultCause("");
            try {
                BSystemIndexer.runIndex((String)Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("niagaraSystemIndex.indexExport.server", new Object[]{this.getDevice().getName()}), (Context)cx, (log, context) -> {
                    long start = DiagnosticUtil.startIfLoggable((String)"systemIndexDeviceExt_exportReceived");
                    try {
                        int limit;
                        if (log.isLoggingEnabled()) {
                            log.start("niagaraSystemIndex", "niagaraSystemIndex.receiveIndexExport.start", new String[]{'\"' + this.getDevice().getName() + '\"'});
                        }
                        int size = (limit = this.checkLicenseForIndexing()) != Integer.MAX_VALUE ? entities.size() : -1;
                        String stationNameStr = ((BINiagaraStation)this.getDevice()).getStationName();
                        BSystemIndexer.systemIndexToSystemDb((String)stationNameStr, BNiagaraSystemIndexDeviceExt.toEntityStream(stationNameStr, entities, size, limit), (SystemIndexLog)log, (Context)SystemIndexContextHolder.INDEX_CONTEXT);
                        if (size > limit) {
                            String[] args = new String[]{stationNameStr, Integer.toString(size), Integer.toString(limit)};
                            this.setReceiveExportedIndexFaultCause(Lexicon.make((String)"systemIndex").getText("systemIndex.exceededEntityLimit", (Object[])args));
                            if (log.isLoggingEnabled()) {
                                log.message("systemIndex", "systemIndex.exceededEntityLimit.noLineFeeds", args);
                            }
                        }
                        this.setReceiveExportedIndexLastSuccess(Clock.time());
                        if (log.isLoggingEnabled()) {
                            log.success("niagaraSystemIndex", "niagaraSystemIndex.receiveIndexExport.complete", '\"' + this.getDevice().getName() + '\"');
                        }
                    }
                    catch (Exception e) {
                        if (log.isLoggingEnabled()) {
                            log.failed("niagaraSystemIndex", "niagaraSystemIndex.receiveIndexExport.failed", '\"' + this.getDevice().getName() + '\"', (Throwable)e);
                        }
                        throw BSystemIndexer.convertIndexException((Exception)e);
                    }
                    finally {
                        if (start != 0L) {
                            DiagnosticUtil.complete((long)start, (String)"systemIndexDeviceExt_exportReceived", (Object)this.toDisplayPathString(cx));
                        }
                    }
                });
            }
            catch (Exception e) {
                this.setReceiveExportedIndexLastFailure(Clock.time());
                this.setReceiveExportedIndexFaultCause(SystemIndexUtil.getFailureReason((Throwable)e));
                throw e;
            }
            finally {
                this.updateExportStatistics(startTicks);
            }
        });
    }

    public boolean isEntityExportEnabled() {
        SlotCursor c = this.getProperties();
        while (c.next(BNiagaraSystemIndexExport.class)) {
            BNiagaraSystemIndexExport export = (BNiagaraSystemIndexExport)c.get();
            if (export.isDisabled() || export.isFatalFault()) continue;
            return true;
        }
        return false;
    }

    static BCategoryService getCategoryService(boolean reload) {
        if (reload || categoryService == null) {
            categoryService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        }
        return categoryService;
    }

    static BNiagaraNetwork getNiagaraNetwork(boolean reload) {
        if (reload || niagaraNetwork == null) {
            niagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        }
        return niagaraNetwork;
    }

    static Supplier<Stream<Entity>> toEntityStream(String stationName, List<Entity> entitiesList, int size, int limit) {
        return () -> {
            BString sName = BString.make((String)stationName);
            Stream<Entity> remoteEntities = entitiesList.stream().map(e -> BNiagaraSystemIndexDeviceExt.convertRemoteEntity(e, sName)).distinct();
            if (size > limit) {
                remoteEntities = remoteEntities.limit(limit);
            }
            return remoteEntities;
        };
    }

    private static Entity convertRemoteEntity(Entity e, BString stationName) {
        Tags tags = e.tags();
        if (!tags.contains(nStationId)) {
            tags.set(nStationId, (BIDataValue)stationName);
        }
        if (e instanceof BICategorizable) {
            return e;
        }
        return new CategorizableEntity(e);
    }

    public void clientOpened() {
    }

    public void clientClosed() {
    }

    public void serverOpened() {
    }

    public void serverClosed() {
    }

    public String getDisplayNameInParent(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("niagaraSystemIndex.deviceExt");
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BNiagaraStation.TYPE)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        SlotCursor slots = parent.getProperties();
        while (slots.next(BNiagaraSystemIndexDeviceExt.class)) {
            if (slots.get() == this) continue;
            throw new IllegalChildException("niagaraSystemIndex", "niagaraSystemIndex.duplicateStationIndexer", new Object[]{this.getType()});
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning()) {
            out.startProps();
            out.trTitle((Object)"NiagaraSystemIndexDeviceExt Statistics", 2);
            out.prop((Object)"Total Global Execute attempts", (Object)String.valueOf(this.numGlobalExecutes));
            out.prop((Object)"Total Global Execute time", (Object)BRelTime.make((long)this.totalGlobalExecuteTime));
            long avg = this.numGlobalExecutes > 0L ? this.totalGlobalExecuteTime / this.numGlobalExecutes : 0L;
            out.prop((Object)"Avg Global Execute time", (Object)BRelTime.make((long)avg));
            long min = this.minGlobalExecuteTime != Long.MAX_VALUE ? this.minGlobalExecuteTime : 0L;
            out.prop((Object)"Min Global Execute time", (Object)BRelTime.make((long)min));
            out.prop((Object)"Max Global Execute time", (Object)BRelTime.make((long)this.maxGlobalExecuteTime));
            out.prop((Object)"Total Incoming Index Export attempts", (Object)String.valueOf(this.numExportExecutes));
            out.prop((Object)"Total Incoming Index Export time", (Object)BRelTime.make((long)this.totalExportExecuteTime));
            avg = this.numExportExecutes > 0L ? this.totalExportExecuteTime / this.numExportExecutes : 0L;
            out.prop((Object)"Avg Incoming Index Export time", (Object)BRelTime.make((long)avg));
            min = this.minExportExecuteTime != Long.MAX_VALUE ? this.minExportExecuteTime : 0L;
            out.prop((Object)"Min Incoming Index Export time", (Object)BRelTime.make((long)min));
            out.prop((Object)"Max Incoming Index Export time", (Object)BRelTime.make((long)this.maxExportExecuteTime));
            out.endProps();
        }
        super.spy(out);
    }

    private void updateGlobalStatistics(long startTicks) {
        long duration = Clock.ticks() - startTicks;
        BNiagaraNetworkSystemIndexer.updateStatistics((BComponent)this, duration);
        ++this.numGlobalExecutes;
        this.totalGlobalExecuteTime += duration;
        if (duration <= this.minGlobalExecuteTime) {
            this.minGlobalExecuteTime = duration;
        }
        if (duration >= this.maxGlobalExecuteTime) {
            this.maxGlobalExecuteTime = duration;
        }
    }

    private void updateExportStatistics(long startTicks) {
        long duration = Clock.ticks() - startTicks;
        ++this.numExportExecutes;
        this.totalExportExecuteTime += duration;
        if (duration <= this.minExportExecuteTime) {
            this.minExportExecuteTime = duration;
        }
        if (duration >= this.maxExportExecuteTime) {
            this.maxExportExecuteTime = duration;
        }
    }

    public String getLicenseKeyPrefix() {
        BDevice parentDevice;
        try {
            parentDevice = this.getDevice();
        }
        catch (Exception e) {
            parentDevice = (BDevice)DrUtil.getParent((BComplex)this, (Type)BDevice.TYPE);
        }
        if (BISubLicenseable.isSubLicenseable((BObject)parentDevice)) {
            if (parentDevice instanceof BNiagaraEdgeLiteStation) {
                return "edgeLite1";
            }
            return ((BISubLicenseable)parentDevice).getLicenseKeyPrefix();
        }
        return null;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 501) {
            try {
                this.checkLicenseForIndexing();
                return null;
            }
            catch (Exception e) {
                String unlicensed = SystemIndexUtil.getFailureReason((Throwable)e);
                if (unlicensed == null) {
                    unlicensed = "unlicensed";
                }
                return unlicensed;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    int checkLicenseForIndexing() throws Exception {
        String key;
        int entitiesPerStationLimit;
        BSystemIndexService systemIndexService = BNiagaraSystemIndexDeviceExt.getSystemIndexService(true);
        if (this.fatalFault != null) {
            throw new LocalizableRuntimeException("systemIndex", "systemIndex.unlicensedStation", new Object[]{this.getDevice().getName(), this.fatalFault});
        }
        if (!this.checkedLicense.get()) {
            BDevice device = this.getDevice();
            if (device == null) {
                throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{"null", this.getType()});
            }
            String prefix = this.getLicenseKeyPrefix();
            if (prefix == null) {
                prefix = "";
            }
            this.fatalFault = (String)systemIndexService.fw(501, (Object)BISubLicenseable.getLicenseKey((BObject)this, (String)"station.limit"), (Object)(prefix + device.getName()), null, null);
            this.checkedLicense.set(true);
            if (this.fatalFault != null) {
                Object[] args = new Object[]{this.getDevice().getName(), this.fatalFault};
                this.setGlobalIndexFaultCause(Lexicon.make((String)"systemIndex").getText("systemIndex.unlicensedStation", args));
                this.updateStatus();
                throw new LocalizableRuntimeException("systemIndex", "systemIndex.unlicensedStation", args);
            }
        }
        if ((entitiesPerStationLimit = BNiagaraSystemIndexDeviceExt.entitiesPerStationLimit.computeIfAbsent(key = BISubLicenseable.getLicenseKey((BObject)this, (String)"station.entity.limit"), k -> LicenseUtil.parseLimit((Feature)systemIndexService.getLicenseFeature(), (String)k)).intValue()) <= 0) {
            String msg = Lexicon.make((String)"systemIndex").getText("systemIndex.missingEntityLimit", new Object[]{key});
            throw new LocalizableRuntimeException("systemIndex", "systemIndex.unlicensedStation", new Object[]{this.getDevice().getName(), msg});
        }
        return entitiesPerStationLimit;
    }

    static {
        icon = BIcon.std((String)"indexService.png");
        VER_4_4 = new Version("4.4");
        nStationId = Id.newId((String)"n", (String)"station");
        entitiesPerStationLimit = Collections.synchronizedMap(new HashMap());
    }

    static final class SystemIndexContextHolder {
        public static final Context INDEX_CONTEXT = AccessController.doPrivileged(BSystemDb::getSystemIndexContext);

        SystemIndexContextHolder() {
        }
    }

    private static class CategorizableEntity
    implements Entity,
    BICategorizable {
        private final Entity entity;

        public CategorizableEntity(Entity entity) {
            this.entity = entity;
        }

        public Tags tags() {
            return this.entity.tags();
        }

        public BCategoryMask getAppliedCategoryMask() {
            return this.computeCategoryMask(true);
        }

        public BCategoryMask getCategoryMask() {
            return this.computeCategoryMask(false);
        }

        private BCategoryMask computeCategoryMask(boolean applied) {
            BOrd ord = this.getOrdToEntity().orElseThrow(() -> new BajaRuntimeException("Missing Entity ORD encountered during system index"));
            OrdQuery[] queries = ord.parse();
            OrdQuery nspaceQuery = queries[0];
            if (!nspaceQuery.getScheme().equals(BNSpaceScheme.INSTANCE.getId())) {
                throw new BajaRuntimeException("Unexpected Entity ORD encountered during system index: " + ord);
            }
            BNiagaraStation station = (BNiagaraStation)BNiagaraSystemIndexDeviceExt.getNiagaraNetwork(false).getStation(nspaceQuery.getBody());
            if (station == null) {
                throw new BajaRuntimeException("Cannot find local NiagaraStation corresponding to Entity ORD encountered during system index: " + ord);
            }
            for (int i = 1; i < queries.length; ++i) {
                if (!(queries[i] instanceof SlotPath)) continue;
                queries[i] = VirtualPath.convertFromSlotPath((SlotPath)((SlotPath)queries[i]));
            }
            BNiagaraVirtualDeviceExt gateway = station.getVirtual();
            ord = BOrd.make((BOrd)gateway.getNavOrd().relativizeToSession(), (BOrd)BOrd.make((OrdQuery[])queries, (int)1, (int)queries.length));
            if (ord != null && !ord.isNull()) {
                BCategoryService service = BNiagaraSystemIndexDeviceExt.getCategoryService(false);
                BCategoryMask mask = applied ? service.getOrdMap().getAppliedCategoryMask(ord) : service.getOrdMap().getCategoryMask(ord);
                if (mask != null) {
                    return mask;
                }
            }
            if (applied) {
                return gateway.getAppliedCategoryMask();
            }
            return BCategoryMask.NULL;
        }

        public Relations relations() {
            return this.entity.relations();
        }

        public Optional<BOrd> getOrdToEntity() {
            return this.entity.getOrdToEntity();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CategorizableEntity) {
                return this.getOrdToEntity().equals(((CategorizableEntity)obj).getOrdToEntity());
            }
            return false;
        }

        public int hashCode() {
            return this.getOrdToEntity().hashCode();
        }

        public <T extends BIObject> T as(Class<T> cls) {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }

        public BIDataValue toDataValue() {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }

        public String toString(Context context) {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }

        public boolean equivalent(Object obj) {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }

        public Type getType() {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }

        public BObject asObject() {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }
    }
}

