/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaraSystemIndex;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.niagaraSystemIndex.BNiagaraNetworkSystemIndexSource;
import com.tridium.niagaraSystemIndex.BNiagaraSystemIndexDeviceExt;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.systemIndex.BSystemIndexJob;
import com.tridium.systemIndex.BSystemIndexService;
import com.tridium.systemIndex.BSystemIndexer;
import com.tridium.systemIndex.SystemIndexLog;
import com.tridium.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.job.BJob;
import javax.baja.license.Feature;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="globalIndexTimeout", type="BRelTime", defaultValue="BRelTime.makeHours(2)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(1)")}), @NiagaraProperty(name="globalIndexLastResult", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")})})
public final class BNiagaraNetworkSystemIndexer
extends BSystemIndexer
implements BIRestrictedComponent {
    public static final Property globalIndexTimeout = BNiagaraNetworkSystemIndexer.newProperty((int)0, (BValue)BRelTime.makeHours((int)2), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Property globalIndexLastResult = BNiagaraNetworkSystemIndexer.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Type TYPE = Sys.loadType(BNiagaraNetworkSystemIndexer.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"index.png"), (BIcon)BIcon.std((String)"badges/import.png"));
    private static final int MAX_DISPLAYED_FAILURES = 5;
    private static final String INDEX_EXPORT_ERROR_MSG = Lexicon.make((String)"niagaraDriver").get("niagaraSystemIndex.illegalImportAndExport", "");
    private static final Lexicon lex = Lexicon.make((String)"niagaraSystemIndex");
    private static final Logger LOG = Logger.getLogger("systemIndex");
    private static final String[][] LICENSE_LIMIT_PAIRS = new String[][]{{"station.limit", "station.entity.limit"}, {"edgeLite1_station.limit", "edgeLite1_station.entity.limit"}};
    private static final String LEXICON_ARG;
    private static final String GLOBAL_UNLICENSED;
    private static final AtomicLong NUM_STATION_INDEX_EXECUTES;
    private static final AtomicLong TOTAL_STATION_INDEX_EXECUTE_TIME;
    private static volatile long minStationIndexExecuteTime;
    private static volatile String minIndexExecuteStation;
    private static volatile long maxStationIndexExecuteTime;
    private static volatile String maxIndexExecuteStation;

    public BRelTime getGlobalIndexTimeout() {
        return (BRelTime)this.get(globalIndexTimeout);
    }

    public void setGlobalIndexTimeout(BRelTime v) {
        this.set(globalIndexTimeout, (BValue)v, null);
    }

    public String getGlobalIndexLastResult() {
        return this.getString(globalIndexLastResult);
    }

    public void setGlobalIndexLastResult(String v) {
        this.setString(globalIndexLastResult, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeFullIndex(SystemIndexLog log, Context cx) throws Exception {
        BNiagaraNetworkSystemIndexer.checkServicesOperational((SystemIndexLog)log);
        long start = DiagnosticUtil.startIfLoggable((String)"systemIndexer_global_executeFull");
        try {
            this.indexNiagaraStations(false, log, cx);
        }
        finally {
            DiagnosticUtil.complete((long)start, (String)"systemIndexer_global_executeFull");
        }
    }

    public boolean shouldRetryFailedIndexes(Context cx) {
        if (this.isUnoperational() || this.getState() != BDescriptorState.idle) {
            return false;
        }
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        for (BDevice device : network.getDevices()) {
            BNiagaraStation station = (BNiagaraStation)device;
            SlotCursor props = station.getProperties();
            while (props.next(BNiagaraSystemIndexDeviceExt.class)) {
                BNiagaraSystemIndexDeviceExt deviceExt = (BNiagaraSystemIndexDeviceExt)props.get();
                if (!deviceExt.isFault() || deviceExt.isDown() || !deviceExt.canAcceptGlobalQueries(SystemIndexLog.DEFAULT_SYSTEM_INDEX_LOG, cx) || deviceExt.getGlobalIndexFaultCause().equals(INDEX_EXPORT_ERROR_MSG)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeFailedIndexes(SystemIndexLog log, Context cx) throws Exception {
        BNiagaraNetworkSystemIndexer.checkServicesOperational((SystemIndexLog)log);
        long start = DiagnosticUtil.startIfLoggable((String)"systemIndexer_global_executeFailed");
        try {
            this.indexNiagaraStations(true, log, cx);
        }
        finally {
            DiagnosticUtil.complete((long)start, (String)"systemIndexer_global_executeFailed");
        }
    }

    private void indexNiagaraStations(boolean onlyStationsInFault, SystemIndexLog log, Context cx) throws Exception {
        if (log.isLoggingEnabled()) {
            log.message("niagaraSystemIndex", "niagaraSystemIndex.job.moreDetails");
        }
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] devices = network.getDevices();
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(devices.length);
        List failedStations = Collections.synchronizedList(new ArrayList());
        AtomicInteger totalEligibleStations = new AtomicInteger();
        AtomicInteger totalSuccessful = new AtomicInteger();
        int totalDown = 0;
        for (BDevice device : devices) {
            BNiagaraStation station = (BNiagaraStation)device;
            SlotCursor props = station.getProperties();
            while (props.next(BNiagaraSystemIndexDeviceExt.class)) {
                BNiagaraSystemIndexDeviceExt deviceExt = (BNiagaraSystemIndexDeviceExt)props.get();
                if (!deviceExt.canAcceptGlobalQueries(log, cx)) continue;
                totalEligibleStations.incrementAndGet();
                if (!onlyStationsInFault || deviceExt.isFault() && !deviceExt.getGlobalIndexFaultCause().equals(INDEX_EXPORT_ERROR_MSG)) {
                    if (!deviceExt.isDown()) {
                        deviceExt.executePending();
                        SystemIndexLog stationLog = systemIndexJobLog.isLoggable(Level.FINE) ? SystemIndexLog.makeJobSystemIndexLog((BJob)new BSystemIndexJob(), (boolean)false) : SystemIndexLog.DEFAULT_SYSTEM_INDEX_LOG;
                        CompletionStage future = BNiagaraNetworkSystemIndexer.runAsync((BSystemIndexService)this.getSystemIndexService(), () -> deviceExt.executeGlobalIndex(this.getOperationalIndexQueries(), stationLog, cx)).handle((r, t) -> {
                            SystemIndexLog systemIndexLog = log;
                            synchronized (systemIndexLog) {
                                log.combine(stationLog);
                            }
                            if (t != null) {
                                Throwable cause;
                                Throwable throwable = cause = t instanceof LocalizableRuntimeException ? t : t.getCause();
                                if (cause instanceof LocalizableRuntimeException && "niagaraDriver".equals(((LocalizableRuntimeException)cause).getLexiconModule()) && "niagaraSystemIndex.illegalImportAndExport".equals(((LocalizableRuntimeException)cause).getLexiconKey())) {
                                    totalEligibleStations.decrementAndGet();
                                } else {
                                    failedStations.add(station.getStationName());
                                }
                            } else {
                                totalSuccessful.incrementAndGet();
                            }
                            return r;
                        });
                        futures.add(future);
                        continue;
                    }
                    ++totalDown;
                    if (!log.isLoggingEnabled()) continue;
                    log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.down", new String[]{station.getStationName()});
                    continue;
                }
                if (deviceExt.isDown()) {
                    ++totalDown;
                    if (!log.isLoggingEnabled()) continue;
                    log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.down", new String[]{station.getStationName()});
                    continue;
                }
                if (deviceExt.getGlobalIndexFaultCause().equals(INDEX_EXPORT_ERROR_MSG)) {
                    totalEligibleStations.decrementAndGet();
                    if (!log.isLoggingEnabled()) continue;
                    log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.exportExists", new String[]{station.getStationName()});
                    continue;
                }
                totalSuccessful.incrementAndGet();
                if (!log.isLoggingEnabled()) continue;
                log.message("niagaraSystemIndex", "niagaraSystemIndex.indexSkipped.upToDate", new String[]{station.getStationName()});
            }
        }
        LocalizableRuntimeException timeoutException = null;
        if (!futures.isEmpty()) {
            CompletableFuture<Void> allDoneFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
            try {
                allDoneFuture.get(this.getGlobalIndexTimeout().getMillis(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException te) {
                timeoutException = new LocalizableRuntimeException("niagaraSystemIndex", "niagaraSystemIndex.globalIndexTimeout", (Throwable)te);
            }
        }
        this.setGlobalIndexLastResult(lex.getText("niagaraSystemIndex.globalIndexStateText", new Object[]{totalSuccessful.get(), totalEligibleStations.get(), totalDown}));
        if (timeoutException == null && !failedStations.isEmpty()) {
            int numFailures = failedStations.size();
            int max = numFailures > 5 ? 5 : numFailures;
            StringJoiner joiner = new StringJoiner(", \n");
            for (int i = 0; i < max; ++i) {
                joiner.add((CharSequence)failedStations.get(i));
            }
            if (numFailures > 5) {
                joiner.add(lex.getText("niagaraSystemIndex.globalIndexFailure.more", new Object[]{numFailures - 5}));
            }
            throw new LocalizableRuntimeException("niagaraSystemIndex", "niagaraSystemIndex.globalIndexFailure", new Object[]{numFailures, totalEligibleStations.get(), totalDown, joiner.toString()});
        }
        if (timeoutException != null) {
            throw timeoutException;
        }
    }

    static CompletableFuture<Void> executeAsync(BSystemIndexService indexService, Runnable r) {
        return BNiagaraNetworkSystemIndexer.runAsync((BSystemIndexService)indexService, (Runnable)r);
    }

    protected String getIndexDescription(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("niagaraSystemIndex.globalIndexer");
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BNiagaraNetworkSystemIndexSource.TYPE)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        BIRestrictedComponent.checkForDuplicates((BComponent)parent, (BIRestrictedComponent)this, (boolean)false);
    }

    public BIcon getIcon() {
        return icon;
    }

    protected String checkFatalFault() {
        for (String[] limitPair : LICENSE_LIMIT_PAIRS) {
            boolean isLicensed = true;
            for (String licenseLimit : limitPair) {
                int limit;
                try {
                    limit = LicenseUtil.parseLimit((Feature)this.getSystemIndexService().getLicenseFeature(), (String)licenseLimit);
                }
                catch (Exception e) {
                    limit = 0;
                }
                if (limit > 0) continue;
                isLicensed = false;
                break;
            }
            if (!isLicensed) continue;
            return null;
        }
        LOG.warning(() -> "Global Niagara Network System Indexer is unlicensed");
        return GLOBAL_UNLICENSED;
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning()) {
            out.startProps();
            out.trTitle((Object)"Global Niagara Network System Index Statistics", 2);
            long numStationIndexes = NUM_STATION_INDEX_EXECUTES.get();
            out.prop((Object)"Total index attempts on individual NiagaraStations by global initiation", (Object)String.valueOf(numStationIndexes));
            long totalStationIndexExecution = TOTAL_STATION_INDEX_EXECUTE_TIME.get();
            long avgIndexerExecute = numStationIndexes > 0L ? totalStationIndexExecution / numStationIndexes : 0L;
            out.prop((Object)"Avg individual NiagaraStation Index time by global initiation", (Object)BRelTime.make((long)avgIndexerExecute));
            long min = minStationIndexExecuteTime != Long.MAX_VALUE ? minStationIndexExecuteTime : 0L;
            out.prop((Object)"Min individual NiagaraStation Index time by global initiation", (Object)BRelTime.make((long)min));
            out.prop((Object)"Instance of Min NiagaraStation Index time by global initiation", (Object)minIndexExecuteStation);
            out.prop((Object)"Max individual NiagaraStation Index time by global initiation", (Object)BRelTime.make((long)maxStationIndexExecuteTime));
            out.prop((Object)"Instance of Max NiagaraStation Index time by global initiation", (Object)maxIndexExecuteStation);
            out.endProps();
        }
        super.spy(out);
    }

    static void updateStatistics(BComponent indexComponent, long duration) {
        NUM_STATION_INDEX_EXECUTES.incrementAndGet();
        TOTAL_STATION_INDEX_EXECUTE_TIME.addAndGet(duration);
        if (duration <= minStationIndexExecuteTime) {
            minStationIndexExecuteTime = duration;
            minIndexExecuteStation = indexComponent.toDisplayPathString(null);
        }
        if (duration >= maxStationIndexExecuteTime) {
            maxStationIndexExecuteTime = duration;
            maxIndexExecuteStation = indexComponent.toDisplayPathString(null);
        }
    }

    static {
        StringJoiner sj = new StringJoiner("\n");
        for (Object[] objectArray : LICENSE_LIMIT_PAIRS) {
            sj.add(ArrayUtil.join((Object[])objectArray, (String)", "));
        }
        LEXICON_ARG = sj.toString();
        GLOBAL_UNLICENSED = lex.getText("niagaraSystemIndex.globalIndexUnlicensed", new Object[]{LEXICON_ARG});
        NUM_STATION_INDEX_EXECUTES = new AtomicLong();
        TOTAL_STATION_INDEX_EXECUTE_TIME = new AtomicLong();
        minStationIndexExecuteTime = Long.MAX_VALUE;
        minIndexExecuteStation = "none";
        maxIndexExecuteStation = "none";
    }
}

