/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.sqlserver;

import com.tridium.rdb.sqlserver.BSqlServerDatabase;
import com.tridium.rdb.sqlserver.SqlServerQuery;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsScheme;
import javax.baja.rdb.BRdbmsSession;
import javax.baja.rdb.RdbmsQuery;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

public class BSqlServerScheme
extends BRdbmsScheme {
    public static final BSqlServerScheme INSTANCE = new BSqlServerScheme();
    public static final Type TYPE = Sys.loadType(BSqlServerScheme.class);

    private BSqlServerScheme() {
        super("sqlServer");
    }

    public void pickle(BISession session, XElem pickle) {
        BSqlServerDatabase db = (BSqlServerDatabase)((BRdbmsSession)session).getDatabase();
        pickle.addAttr("host", db.getHostname());
        pickle.addAttr("port", Integer.toString(db.getPort()));
    }

    public BISession unpickle(XElem pickle) {
        return BRdbmsSession.make((BHost)BHost.getHost((String)pickle.get("host")), (RdbmsQuery)new SqlServerQuery(pickle.geti("port", 0)), (BRdbmsScheme)this);
    }

    public BRdbms newDatabase(BHost host, RdbmsQuery query) {
        SqlServerQuery sq = (SqlServerQuery)query;
        return new BSqlServerDatabase(BOrd.make((String)("ip:" + host.toString())), sq.port);
    }

    public String getAuthName() {
        return "SqlServer";
    }

    public OrdQuery parse(String queryBody) {
        return new SqlServerQuery(queryBody);
    }

    public Type getType() {
        return TYPE;
    }
}

