/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.sqlserver;

import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.sqlserver.BConnectionPool;
import com.tridium.rdb.sqlserver.BSqlServerConnector;
import com.tridium.rdb.sqlserver.BSqlServerVersion;
import com.tridium.rdb.sqlserver.history.BSqlServerHistoryDeviceExt;
import java.io.File;
import java.io.FileOutputStream;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.status.BStatus;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class BSqlServerDatabase
extends BRdbms {
    public static final Property timestampStorage = BSqlServerDatabase.newProperty((int)0x10000000, (BValue)BRdbmsTimestampStorage.dialectDefault, null);
    public static final Property instanceName = BSqlServerDatabase.newProperty((int)0, (String)"", null);
    public static final Property port = BSqlServerDatabase.newProperty((int)0, (int)1433, null);
    public static final Property histories = BSqlServerDatabase.newProperty((int)0, (BValue)new BSqlServerHistoryDeviceExt(), null);
    public static final Property connectionPool = BSqlServerDatabase.newProperty((int)4, (BValue)new BConnectionPool(), null);
    public static final Property extraConnectionProperties = BSqlServerDatabase.newProperty((int)0, (String)"", null);
    public static final Property version = BSqlServerDatabase.newProperty((int)0x10000000, (BValue)BSqlServerVersion.sqlServer2008, null);
    public static final Property connector = BSqlServerDatabase.newProperty((int)0, (BValue)BSqlServerConnector.jtds, null);
    public static final Property sqlServerCert = BSqlServerDatabase.newProperty((int)4, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:UserTrustCertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"storeId", (BIDataValue)BString.make((String)"USER_TRUST_STORE"))), (BFacets)BFacets.make((String)"purposeId", (BIDataValue)BString.make((String)""))));
    public static final Type TYPE = Sys.loadType(BSqlServerDatabase.class);
    private final RdbmsDialect DIALECT = new RdbmsDialect(){

        public String getValidationQuery() {
            return "select 1;";
        }

        public void issueCheckpoint(Connection conn) throws SQLException {
        }

        public boolean supportsBatchInsert() {
            return false;
        }

        public boolean supportsBatchUpdate() {
            return true;
        }

        public boolean supportsBatchDelete() {
            return true;
        }

        public int getInsertionMode() {
            return 1;
        }

        public String getIdentityCreation() {
            return "IDENTITY";
        }

        public String getIdentityLookup() {
            throw new UnsupportedOperationException();
        }

        public String getSequenceName(String tableName) {
            throw new UnsupportedOperationException();
        }

        public String getSequenceLookup(String tableName) {
            throw new UnsupportedOperationException();
        }

        public String getAlterColumn() {
            return "ALTER COLUMN";
        }

        public String getAlterColumnSuffix() {
            return null;
        }

        public boolean getAlterColumnSupportsNotNull() {
            return true;
        }

        public String getStringLengthFunctionName() {
            return "LEN";
        }

        public int getMaxTableName() {
            return 128;
        }

        public int getMaxIndexName() {
            return 128;
        }

        public int getMaxConstraintName() {
            return 128;
        }

        public int getMaxColumnName() {
            return 128;
        }

        public boolean allowsUnicodeNames() {
            return true;
        }

        public String getColumnIdentifier(String schemaName, String tableName, String columnName) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName + "." + tableName + ".\"" + columnName + "\"";
            }
            return tableName + ".\"" + columnName + "\"";
        }

        public String getTableIdentifier(String schemaName, String tableName) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName + "." + tableName;
            }
            return tableName;
        }

        public String getDropIndex(String tableName, String indexName) {
            return "DROP INDEX " + tableName + "." + indexName;
        }

        public String getDropConstraint(String tableName, Constraint constraint) {
            return "ALTER TABLE " + tableName + " DROP CONSTRAINT " + constraint.getName();
        }

        public String getIntType() {
            return "INTEGER";
        }

        public String getLongType() {
            return "BIGINT";
        }

        public String getFloatType() {
            return "REAL";
        }

        public String getDoubleType() {
            return "DOUBLE PRECISION";
        }

        public String getCharType() {
            return BSqlServerDatabase.this.getUseUnicodeEncodingScheme() ? "NCHAR" : "CHAR";
        }

        public String getVarCharType() {
            return BSqlServerDatabase.this.getUseUnicodeEncodingScheme() ? "NVARCHAR" : "VARCHAR";
        }

        public String getUuidType() {
            return "UNIQUEIDENTIFIER";
        }

        public String getDateType() {
            return "DATE";
        }

        public String getBooleanType() {
            return "BIT";
        }

        public String getTimestampType() {
            return "DATETIME";
        }

        public boolean supportsBooleanType() {
            return true;
        }

        public boolean supportsMillisecondTimestamp() {
            return false;
        }

        public boolean useUtcTimestamps() {
            return BSqlServerDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcTimestamp);
        }

        public boolean supportsDateType() {
            return BSqlServerDatabase.this.getVersion().getOrdinal() >= 2;
        }

        public String getBlobType() {
            return "IMAGE";
        }

        public boolean usesDefaultBlobTranslator() {
            return true;
        }

        public void setBlobValue(RdbmsPreparedStatement prep, int index, byte[] bytes) {
            throw new UnsupportedOperationException();
        }

        public String getClobType() {
            return BSqlServerDatabase.this.getUseUnicodeEncodingScheme() ? "NTEXT" : "TEXT";
        }

        public boolean usesDefaultClobTranslator() {
            return true;
        }

        public void setClobValue(RdbmsPreparedStatement prep, int index, String str) {
            throw new UnsupportedOperationException();
        }

        public AesSysKeyEncoder getSysEncoder() {
            return BSqlServerDatabase.this.getEncoder();
        }

        public String getOnDelete(int onDelete) {
            switch (onDelete) {
                case 1: {
                    return "CASCADE";
                }
                case 0: {
                    return "NO ACTION";
                }
            }
            throw new IllegalStateException();
        }

        public boolean supportsDropColumn() {
            return true;
        }

        public boolean supportsRenameTable() {
            return false;
        }

        public boolean supportsClusteredIndex() {
            return true;
        }

        public int getJdbcTypeBlob() {
            return 2004;
        }

        public int getJdbcTypeBoolean() {
            return -7;
        }

        public int getJdbcTypeChar() {
            return 1;
        }

        public int getJdbcTypeClob() {
            return 2005;
        }

        public int getJdbcTypeDouble() {
            return 8;
        }

        public int getJdbcTypeFloat() {
            return 7;
        }

        public int getJdbcTypeInt() {
            return 4;
        }

        public int getJdbcTypeLong() {
            return -5;
        }

        public int getJdbcTypeTimestamp() {
            return -5;
        }

        public int getJdbcTypeUuid() {
            return 1;
        }

        public int getJdbcTypeVarchar() {
            return 12;
        }

        public int getJdbcTypeDate() {
            return this.supportsDateType() ? 91 : 93;
        }
    };
    private String certificateHostName = "";
    private String trustStoreName = BUuid.make().toString();
    private static final File RDB_SQL_SERVER_DIR = new File(Sys.getStationHome(), "rdbSqlServer");
    private static final SecretChars TRUST_STORE_PASSWORD = BPassword.DEFAULT.getSecretChars();

    public BRdbmsTimestampStorage getTimestampStorage() {
        return (BRdbmsTimestampStorage)this.get(timestampStorage);
    }

    public void setTimestampStorage(BRdbmsTimestampStorage v) {
        this.set(timestampStorage, (BValue)v, null);
    }

    public String getInstanceName() {
        return this.getString(instanceName);
    }

    public void setInstanceName(String v) {
        this.setString(instanceName, v, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    public BSqlServerHistoryDeviceExt getHistories() {
        return (BSqlServerHistoryDeviceExt)this.get(histories);
    }

    public void setHistories(BSqlServerHistoryDeviceExt v) {
        this.set(histories, (BValue)v, null);
    }

    public BConnectionPool getConnectionPool() {
        return (BConnectionPool)this.get(connectionPool);
    }

    public void setConnectionPool(BConnectionPool v) {
        this.set(connectionPool, (BValue)v, null);
    }

    public String getExtraConnectionProperties() {
        return this.getString(extraConnectionProperties);
    }

    public void setExtraConnectionProperties(String v) {
        this.setString(extraConnectionProperties, v, null);
    }

    public BSqlServerVersion getVersion() {
        return (BSqlServerVersion)this.get(version);
    }

    public void setVersion(BSqlServerVersion v) {
        this.set(version, (BValue)v, null);
    }

    public BSqlServerConnector getConnector() {
        return (BSqlServerConnector)this.get(connector);
    }

    public void setConnector(BSqlServerConnector v) {
        this.set(connector, (BValue)v, null);
    }

    public String getSqlServerCert() {
        return this.getString(sqlServerCert);
    }

    public void setSqlServerCert(String v) {
        this.setString(sqlServerCert, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSqlServerDatabase() {
    }

    public BSqlServerDatabase(BOrd address, int port) {
        this.setHostAddress(address);
        this.setPort(port);
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "rdbSqlServer");
    }

    public Connection getConnection(String userName, BPassword password) throws SQLException {
        BStatus status = this.getStatus();
        if (status.isFault()) {
            return null;
        }
        return this.getConnectionPool().getConnection(userName, AccessController.doPrivileged(() -> ((BPassword)password).getValue()));
    }

    public void changed(Property prop, Context cx) {
        if (prop.equals(sqlServerCert) && this.isRunning()) {
            this.updateTrustStore(cx);
        }
        if (this.getConnector().equals((Object)BSqlServerConnector.jtds)) {
            int flags = this.getFlags((Slot)sqlServerCert);
            this.setFlags((Slot)sqlServerCert, flags |= 4);
        } else {
            int flags = this.getFlags((Slot)sqlServerCert);
            this.setFlags((Slot)sqlServerCert, flags &= 0xFFFFFFFB);
        }
    }

    public void rdbmsStarted() {
        this.updateTrustStore(null);
    }

    private void updateTrustStore(Context cx) {
        try {
            AccessController.doPrivileged(() -> {
                if (!RDB_SQL_SERVER_DIR.exists()) {
                    RDB_SQL_SERVER_DIR.mkdirs();
                }
                return null;
            });
            KeyStore ks = KeyStore.getInstance(this.getTrustStoreType());
            File trustStoreFile = new File(RDB_SQL_SERVER_DIR, this.getTrustStoreName());
            AccessController.doPrivileged(() -> {
                ks.load(null, TRUST_STORE_PASSWORD.get());
                trustStoreFile.deleteOnExit();
                return null;
            });
            X509Certificate cert = null;
            if (!"".equals(this.getSqlServerCert())) {
                cert = CertManagerFactory.getInstance().getUserTrustStore().getCertificate(this.getSqlServerCert());
                if (cert == null) {
                    throw new CertificateException(this.getLexicon().getText("rdbSqlServer.error.invalidCertificate", new Object[]{this.getSqlServerCert(), this.getDisplayName(cx)}));
                }
                this.certificateHostName = cert.getSubjectX500Principal().getName().split(",")[0].substring(3);
            }
            if (cert != null) {
                ks.setCertificateEntry(this.getHandleOrd().toString(), cert);
            } else if (ks.containsAlias(this.getHandleOrd().toString())) {
                ks.deleteEntry(this.getHandleOrd().toString());
            }
            AccessController.doPrivileged(() -> {
                try (FileOutputStream fos = new FileOutputStream(trustStoreFile);){
                    ks.store(fos, TRUST_STORE_PASSWORD.get());
                }
                return null;
            });
            if (!this.isFatalFault()) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
                this.setFaultCause("");
                this.updateStatus();
            }
        }
        catch (Exception e) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            String faultText = this.getLexicon().getText("rdbSqlServer.error.selfSignedConfigError", new Object[]{e.getLocalizedMessage()});
            this.setFaultCause(faultText);
            this.getLogger().log(Level.SEVERE, faultText, e);
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().log(Level.SEVERE, faultText, e);
            }
            this.getLogger().log(Level.SEVERE, faultText);
        }
    }

    SecretChars getTrustStorePassword() {
        return TRUST_STORE_PASSWORD;
    }

    String getTrustStoreName() {
        return this.trustStoreName + "." + this.getTrustStoreType();
    }

    String getTrustStorePath() {
        return new File(RDB_SQL_SERVER_DIR, this.getTrustStoreName()).getPath();
    }

    String getCertificateHostName() {
        return this.certificateHostName;
    }

    String getTrustStoreType() {
        return SecurityInitializer.getInstance().getCryptoProvider().getDefaultKeyStoreType();
    }

    public RdbmsContext getRdbmsContext() {
        return this.DIALECT;
    }
}

