/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.neql;

import com.tridium.neql.NeqlUtil;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.baja.data.BIDataValue;
import javax.baja.neql.Expression;
import javax.baja.neql.GetRelationExpression;
import javax.baja.sys.BBoolean;
import javax.baja.sys.Context;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;

public class GetTagExpression
extends Expression {
    private final String namespace;
    private final String key;
    private final Id cachedId;
    private static final boolean LEGACY_GET_TAG = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.neql.legacyGetTagExpression"));

    public GetTagExpression(String namespace, String key) {
        this.namespace = namespace;
        this.key = key;
        this.cachedId = namespace != null && !namespace.isEmpty() ? Id.newId((String)namespace, (String)key) : null;
    }

    @Override
    public int getNodeType() {
        return 3;
    }

    @Override
    public String getNodeDisplay() {
        if (this.hasNoNameSpace()) {
            return this.key;
        }
        return this.namespace + ":" + this.key;
    }

    private boolean hasNoNameSpace() {
        return this.namespace == null || this.namespace.length() == 0;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getKey() {
        return this.key;
    }

    public GetRelationExpression toRelation() {
        return new GetRelationExpression(this.namespace, this.key);
    }

    public Collection<BIDataValue> evaluate(Entity entity, Context context) {
        Id id = NeqlUtil.getExpressionId(this.key, this.namespace, context);
        Optional tag = entity.tags().get(id);
        if (tag.isPresent()) {
            return Collections.singletonList(tag.get());
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean evalBoolean(Entity entity, Context context) {
        if (LEGACY_GET_TAG) {
            BIDataValue value = this.getValue(entity, context);
            return value != null && value != BBoolean.FALSE;
        }
        Id id = this.getId(context);
        return entity.tags().get(id).isPresent();
    }

    BIDataValue getValue(Entity entity, Context context) {
        Id id = this.getId(context);
        Optional value = entity.tags().get(id);
        return value.isPresent() ? (BIDataValue)value.get() : null;
    }

    private Id getId(Context context) {
        if (this.cachedId != null) {
            return this.cachedId;
        }
        String contextNamespace = context != null ? NeqlUtil.getNamespaceFromContext(context) : "";
        return Id.newId((String)contextNamespace, (String)this.key);
    }
}

