/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.neql;

import javax.baja.naming.BOrdScheme;
import javax.baja.naming.BasicQuery;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="namespace")
public class BNamespaceScheme
extends BOrdScheme {
    public static final BNamespaceScheme INSTANCE = new BNamespaceScheme();
    public static final String SCHEME_ID = "namespace";
    public static final Type TYPE = Sys.loadType(BNamespaceScheme.class);

    private BNamespaceScheme() {
        super(SCHEME_ID);
    }

    public OrdQuery parse(String queryBody) {
        String namespace = queryBody.trim();
        if (namespace.length() == 0) {
            throw new SyntaxException("Namespace cannot be blank.");
        }
        return new BasicQuery(SCHEME_ID, namespace);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        String namespace = query.getBody();
        if (namespace != null && namespace.length() != 0) {
            BFacets nsFacets = BFacets.make((String)SCHEME_ID, (String)namespace);
            return OrdTarget.makeWithFacets((OrdTarget)base, (BFacets)nsFacets);
        }
        throw new UnresolvedException("Namespace cannot be blank.");
    }

    public Type getType() {
        return TYPE;
    }
}

