/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.neql;

public class RuntimeCompilerException
extends RuntimeException {
    private int index;
    private String[] args;

    public RuntimeCompilerException(int index, String key) {
        this(index, key, null);
    }

    public RuntimeCompilerException(int index, String key, String arg) {
        super(key);
        this.index = index;
        this.args = new String[]{arg};
    }

    public RuntimeCompilerException(int index, String key, String arg1, String arg2) {
        super(key);
        this.index = index;
        this.args = new String[]{arg1, arg2};
    }

    public int getIndex() {
        return this.index;
    }

    public String getKey() {
        return this.getMessage();
    }

    public String getArg() {
        return this.args == null ? null : this.args[0];
    }

    public String[] getArgs() {
        return this.args;
    }

    public String toDisplay() {
        StringBuffer err = new StringBuffer(64);
        err.append('(').append(this.index + 1).append("): ");
        err.append(this.getKey());
        if (this.args != null) {
            err.append(" {");
            for (int i = 0; i < this.args.length; ++i) {
                err.append(this.args[i]);
                if (i == this.args.length - 1) continue;
                err.append(',');
            }
            err.append('}');
        }
        return err.toString();
    }
}

