/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.neql;

import com.tridium.neql.Constants;
import com.tridium.neql.RuntimeCompilerException;
import com.tridium.neql.Token;
import com.tridium.neql.UnrecognizedSymbolException;

public class NeqlTokenizer
implements Constants {
    private static final short WHITESPACE_CHAR = 1;
    private static final short WORD_START_CHAR = 2;
    private static final short WORD_CHAR = 4;
    private static final short ALPHA_CHAR = 8;
    private static final short NUMBER_CHAR = 16;
    private static final short OPERATOR_CHAR = 32;
    private static short[] charTypes = new short[255];
    private char[] buf;
    private int bufLen;
    private int index;
    private int current = -1;
    private int currentType = -1;
    private Token peek;
    private Token poke;
    private Token eof;

    public NeqlTokenizer(String queryText) {
        this.reset(queryText);
    }

    public void reset(String queryText) {
        this.buf = queryText.toCharArray();
        this.bufLen = this.buf.length;
        this.reset();
    }

    public void reset() {
        this.index = -1;
        this.currentType = -1;
        this.current = -1;
        this.eof = null;
        this.poke = null;
        this.peek = null;
        this.advance();
    }

    public Token peek() {
        if (this.poke != null) {
            return this.poke;
        }
        if (this.peek == null) {
            this.peek = this.next();
        }
        return this.peek;
    }

    public void push(Token t) {
        if (this.poke != null) {
            throw new IllegalStateException("Only one token can be pushed back onto the tokenizer.");
        }
        this.poke = t;
    }

    public Token next() {
        if (this.poke != null) {
            Token p = this.poke;
            this.poke = null;
            return p;
        }
        if (this.peek != null) {
            Token p = this.peek;
            this.peek = null;
            return p;
        }
        if (this.eof != null) {
            return this.eof;
        }
        int start = this.index;
        if (this.eof()) {
            this.eof = new Token(2, start, null);
            return this.eof;
        }
        if (NeqlTokenizer.is(this.currentType, 1)) {
            return this.parseWhiteSpace();
        }
        if (NeqlTokenizer.is(this.currentType, 2)) {
            return this.parseWord();
        }
        if (NeqlTokenizer.is(this.currentType, 16)) {
            return this.parseNumber();
        }
        if (NeqlTokenizer.is(this.currentType, 32)) {
            return this.parseOperator();
        }
        if (this.current == 34) {
            return this.parseDelimitedWord(5, 34);
        }
        if (this.current == 39) {
            return this.parseDelimitedWord(5, 39);
        }
        return this.parseChar();
    }

    private Token parseChar() {
        int start = this.index;
        Token charToken = null;
        if (this.current == 42) {
            charToken = new Token(7, start, "*");
        } else if (this.current == 40) {
            charToken = new Token(8, start, "(");
        } else if (this.current == 41) {
            charToken = new Token(9, start, ")");
        } else if (this.current == 123) {
            charToken = new Token(10, start, "{");
        } else if (this.current == 125) {
            charToken = new Token(11, start, "}");
        } else if (this.current == 44) {
            charToken = new Token(12, start, ",");
        } else if (this.current == 58) {
            charToken = new Token(18, start, ":");
        } else if (this.current == 46) {
            charToken = new Token(13, start, ".");
        } else if (this.current == 60) {
            this.advance();
            if (this.current == 45) {
                charToken = Token.operator(11, start, "<-");
            } else if (this.current == 61) {
                charToken = Token.operator(5, start, "<=");
            } else {
                this.backup();
                charToken = Token.operator(4, start, "<");
            }
        } else if (this.current == 45) {
            this.advance();
            if (this.current == 62) {
                charToken = Token.operator(12, start, "->");
            } else {
                this.backup();
                charToken = new Token(14, start, "-");
            }
        } else {
            throw new UnrecognizedSymbolException(this.index, String.valueOf((char)this.current));
        }
        this.advance();
        return charToken;
    }

    private Token parseWhiteSpace() {
        int start = this.index;
        while (this.current != -1 && NeqlTokenizer.is(this.currentType, 1)) {
            this.advance();
        }
        String lex = new String(this.buf, start, this.index - start);
        return new Token(0, start, lex);
    }

    private Token parseWord() {
        int start = this.index;
        while (this.current != -1 && NeqlTokenizer.is(this.currentType, 4)) {
            this.advance();
        }
        String lex = new String(this.buf, start, this.index - start);
        Token t = this.parseKeyword(lex, start);
        if (t == null) {
            return new Token(1, start, lex);
        }
        return t;
    }

    private Token parseKeyword(String lex, int startIndex) {
        if (lex.length() == 0) {
            return null;
        }
        lex = lex.toLowerCase();
        char first = lex.charAt(0);
        switch (first) {
            case 'a': {
                if (lex.equals("and")) {
                    return Token.operator(8, startIndex, lex);
                }
                if (!lex.equals("asc")) break;
                return new Token(21, startIndex, lex);
            }
            case 'b': {
                if (!lex.equals("by")) break;
                return new Token(20, startIndex, lex);
            }
            case 'd': {
                if (!lex.equals("desc")) break;
                return new Token(22, startIndex, lex);
            }
            case 'f': {
                if (!lex.equals("false")) break;
                return Token.bool(startIndex, lex, false);
            }
            case 'i': {
                if (!lex.equals("in")) break;
                return Token.operator(10, startIndex, lex);
            }
            case 'l': {
                if (!lex.equals("like")) break;
                return Token.operator(6, startIndex, lex);
            }
            case 'n': {
                if (!lex.equals("not")) break;
                return Token.operator(7, startIndex, lex);
            }
            case 'o': {
                if (lex.equals("or")) {
                    return Token.operator(9, startIndex, lex);
                }
                if (!lex.equals("order")) break;
                return new Token(19, startIndex, lex);
            }
            case 's': {
                if (!lex.equals("select")) break;
                return new Token(15, startIndex, lex);
            }
            case 't': {
                if (lex.equals("traverse")) {
                    return new Token(16, startIndex, lex);
                }
                if (!lex.equals("true")) break;
                return Token.bool(startIndex, lex, true);
            }
            case 'w': {
                if (!lex.equals("where")) break;
                return new Token(17, startIndex, lex);
            }
        }
        return null;
    }

    private Token parseDelimitedWord(int tokenType, int delim) {
        this.advance();
        int start = this.index;
        while (this.current != -1 && this.current != delim) {
            this.advance();
        }
        if (this.current != delim) {
            throw new RuntimeCompilerException(start, "invalid.string.unterminated", "" + (char)delim);
        }
        int end = this.index;
        this.advance();
        return new Token(tokenType, start, new String(this.buf, start, end - start));
    }

    private Token parseNumber() {
        int start = this.index;
        while (this.current != -1 && NeqlTokenizer.is(this.currentType, 16)) {
            this.advance();
        }
        return Token.integer(start, new String(this.buf, start, this.index - start));
    }

    private Token parseOperator() {
        int start = this.index;
        int char1 = this.current;
        int char2 = this.nextChar();
        this.advance();
        int len = 2;
        if (char2 != 61) {
            if (char2 != -1) {
                this.backup();
            }
            len = 1;
        }
        while (true) {
            if (len == 1) {
                switch (char1) {
                    case 61: {
                        return Token.operator(0, start, "=");
                    }
                    case 62: {
                        return Token.operator(2, start, ">");
                    }
                    case 33: {
                        return Token.operator(7, start, "not");
                    }
                }
                this.error(start, "operator.format", new String(this.buf, start, len));
                continue;
            }
            switch (char1) {
                case 33: {
                    return Token.operator(1, start, "!=");
                }
                case 62: {
                    return Token.operator(3, start, ">=");
                }
            }
            this.backup();
            len = 1;
        }
    }

    private void advance() {
        ++this.index;
        if (this.index >= this.bufLen) {
            this.index = this.bufLen;
            this.currentType = -1;
            this.current = -1;
        } else {
            this.current = this.buf[this.index];
            this.currentType = this.current < 255 ? charTypes[this.current] : 8;
        }
    }

    private void backup() {
        this.backup(1);
    }

    private void backup(int count) {
        this.index -= count;
        if (this.index <= -1) {
            this.index = -1;
            this.currentType = -1;
            this.current = -1;
        }
        this.current = this.buf[this.index];
        this.currentType = this.current < 255 ? charTypes[this.current] : 8;
    }

    private int nextChar() {
        this.advance();
        return this.current;
    }

    private int nextType() {
        this.advance();
        return this.currentType;
    }

    public boolean eof() {
        return this.index == this.bufLen;
    }

    private static boolean isWhiteSpace(int ch) {
        int charType = ch != -1 && ch < 255 ? charTypes[ch] : 8;
        return (charType & 1) != 0;
    }

    private static final boolean is(int type, int mask) {
        return (type & mask) != 0;
    }

    private static final boolean isNot(int type, int mask) {
        return (type & mask) == 0;
    }

    private static final boolean isAndNot(int type, int mask, int notMask) {
        return (type & mask) != 0 && (type & notMask) == 0;
    }

    private void error(int index, String key) {
        throw new RuntimeCompilerException(index, key);
    }

    private void error(int index, String key, String arg) {
        throw new RuntimeCompilerException(index, key, arg);
    }

    public static void main(String[] args) {
        String qtext = args[0];
        NeqlTokenizer tokenizer = new NeqlTokenizer(qtext);
        Token t = null;
        do {
            t = tokenizer.next();
            System.out.println(t);
        } while (t.type != 2);
    }

    static {
        charTypes[32] = (short)(charTypes[32] | 1);
        charTypes[10] = (short)(charTypes[10] | 1);
        charTypes[13] = (short)(charTypes[13] | 1);
        charTypes[9] = (short)(charTypes[9] | 1);
        charTypes[61] = (short)(charTypes[61] | 0x20);
        charTypes[62] = (short)(charTypes[62] | 0x20);
        charTypes[33] = (short)(charTypes[33] | 0x20);
        charTypes[95] = (short)(charTypes[95] | 4);
        int i = 65;
        while (i <= 90) {
            int n = i++;
            charTypes[n] = (short)(charTypes[n] | 0xE);
        }
        i = 97;
        while (i <= 122) {
            int n = i++;
            charTypes[n] = (short)(charTypes[n] | 0xE);
        }
        i = 48;
        while (i <= 57) {
            int n = i++;
            charTypes[n] = (short)(charTypes[n] | 0x14);
        }
    }
}

