/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.neql;

import com.tridium.neql.Constants;
import com.tridium.neql.NeqlTokenizer;
import com.tridium.neql.Token;
import com.tridium.neql.UnexpectedSymbolException;
import com.tridium.neql.UnexpectedTokenTypeException;
import javax.baja.data.BIDataValue;
import javax.baja.neql.AndExpression;
import javax.baja.neql.ContextExpression;
import javax.baja.neql.EqualExpression;
import javax.baja.neql.EvalOnExpression;
import javax.baja.neql.Expression;
import javax.baja.neql.GetRelationExpression;
import javax.baja.neql.GetTagExpression;
import javax.baja.neql.GreaterExpression;
import javax.baja.neql.GreaterOrEqualExpression;
import javax.baja.neql.LessExpression;
import javax.baja.neql.LessOrEqualExpression;
import javax.baja.neql.LikeExpression;
import javax.baja.neql.LiteralExpression;
import javax.baja.neql.NotEqualExpression;
import javax.baja.neql.NotExpression;
import javax.baja.neql.OrExpression;
import javax.baja.neql.TraverseInExpression;
import javax.baja.neql.TraverseOutExpression;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;

public class ExprParser
implements Constants {
    private NeqlTokenizer tokens;
    private Token current;

    public Expression parse(NeqlTokenizer tokens) {
        this.tokens = tokens;
        this.next();
        Expression result = this.or();
        tokens.push(this.current);
        return result;
    }

    protected Expression or() {
        Expression left = this.and();
        this.skipWhitespace();
        while (this.current.type == 6 && this.current.opType == 9) {
            this.matchOperator(9);
            this.skipWhitespace();
            Expression right = this.and();
            this.skipWhitespace();
            left = new OrExpression(left, right);
        }
        return left;
    }

    protected Expression and() {
        Expression left = this.compEq();
        this.skipWhitespace();
        while (this.current.type == 6 && this.current.opType == 8) {
            this.matchOperator(8);
            this.skipWhitespace();
            Expression right = this.compEq();
            this.skipWhitespace();
            left = new AndExpression(left, right);
        }
        return left;
    }

    protected Expression compEq() {
        Expression left = this.lessOrGreater();
        this.skipWhitespace();
        while (this.current.type == 6 && (this.current.opType == 0 || this.current.opType == 1)) {
            Token opToken = this.match(6);
            this.skipWhitespace();
            Expression right = this.lessOrGreater();
            this.skipWhitespace();
            if (opToken.opType == 0) {
                left = new EqualExpression(left, right);
                continue;
            }
            left = new NotEqualExpression(left, right);
        }
        return left;
    }

    protected Expression lessOrGreater() {
        Expression left = this.traverse();
        this.skipWhitespace();
        block7: while (this.current.type == 6 && (this.current.opType == 4 || this.current.opType == 5 || this.current.opType == 2 || this.current.opType == 3 || this.current.opType == 6)) {
            Token opToken = this.match(6);
            this.skipWhitespace();
            Expression right = this.traverse();
            this.skipWhitespace();
            switch (opToken.opType) {
                case 4: {
                    left = new LessExpression(left, right);
                    continue block7;
                }
                case 5: {
                    left = new LessOrEqualExpression(left, right);
                    continue block7;
                }
                case 2: {
                    left = new GreaterExpression(left, right);
                    continue block7;
                }
                case 3: {
                    left = new GreaterOrEqualExpression(left, right);
                    continue block7;
                }
                case 6: {
                    left = new LikeExpression(left, right);
                    continue block7;
                }
            }
            throw new UnsupportedOperationException("opType=" + opToken.opType);
        }
        return left;
    }

    public Expression traverse() {
        int notTokenCount = 0;
        while (this.current.opType == 7) {
            ++notTokenCount;
            this.next();
            this.skipWhitespace();
        }
        Expression left = this.term();
        if (this.current.opType == 12) {
            while (this.current.type == 6 && this.current.opType == 12) {
                this.matchOperator(12);
                this.skipWhitespace();
                if (this.current.type != 6 && this.current.type != 9) {
                    left = this.updateLeft(new TraverseOutExpression(left));
                    continue;
                }
                break;
            }
        } else {
            while (this.current.type == 6 && this.current.opType == 11) {
                this.matchOperator(11);
                this.skipWhitespace();
                if (this.current.type != 6 && this.current.type != 9) {
                    left = this.updateLeft(new TraverseInExpression(left));
                    continue;
                }
                break;
            }
        }
        for (int i = 0; i < notTokenCount; ++i) {
            left = new NotExpression(left);
        }
        return left;
    }

    private Expression updateLeft(Expression traverse) {
        if (this.current.type == 2) {
            return traverse;
        }
        Expression right = this.term();
        return new EvalOnExpression(right, traverse);
    }

    protected Expression term() {
        Token termToken = this.current;
        int tokenType = termToken.type;
        switch (tokenType) {
            case 1: {
                return this.tag();
            }
            case 3: 
            case 13: 
            case 14: {
                return this.number();
            }
            case 5: {
                this.next();
                return new LiteralExpression((BIDataValue)BString.make((String)termToken.lex));
            }
            case 4: {
                this.next();
                return new LiteralExpression((BIDataValue)BBoolean.make((boolean)termToken.booleanValue));
            }
            case 10: {
                return this.contextExpression();
            }
            case 8: {
                return this.parens();
            }
        }
        throw new UnexpectedSymbolException(termToken.index, "identifier or literal", termToken.toDisplay());
    }

    protected Expression tag() {
        String name;
        String namespace;
        Token tagToken = this.match(1);
        if (this.current.type == 18) {
            namespace = tagToken.lex;
            this.match(18);
            name = this.match((int)1).lex;
        } else {
            namespace = "";
            name = tagToken.lex;
        }
        if (this.current.opType == 11) {
            return new GetRelationExpression(namespace, name, 1);
        }
        if (this.current.opType == 12) {
            return new GetRelationExpression(namespace, name, 2);
        }
        return new GetTagExpression(namespace, name);
    }

    private LiteralExpression number() {
        boolean negative = false;
        if (this.current.type == 14) {
            negative = true;
            this.match(14);
        }
        String whole = null;
        String dec = null;
        if (this.current.type == 13) {
            whole = "0";
            this.match(13);
        } else if (this.current.type == 3) {
            whole = this.current.lex;
            this.match(3);
            if (this.current.type == 13) {
                this.match(13);
                dec = this.match((int)3).lex;
            }
        }
        if (dec == null) {
            try {
                int val = Integer.parseInt(whole);
                if (negative) {
                    return new LiteralExpression((BIDataValue)BInteger.make((int)(-val)));
                }
                return new LiteralExpression((BIDataValue)BInteger.make((int)val));
            }
            catch (NumberFormatException nfe) {
                try {
                    long val = Long.parseLong(whole);
                    if (negative) {
                        return new LiteralExpression((BIDataValue)BLong.make((long)(-val)));
                    }
                    return new LiteralExpression((BIDataValue)BLong.make((long)val));
                }
                catch (NumberFormatException nfe2) {
                    double val = Double.parseDouble(whole);
                    if (negative) {
                        return new LiteralExpression((BIDataValue)BDouble.make((double)(-val)));
                    }
                    return new LiteralExpression((BIDataValue)BDouble.make((double)val));
                }
            }
        }
        double val = Double.parseDouble(whole + '.' + dec);
        if (negative) {
            return new LiteralExpression((BIDataValue)BDouble.make((double)(-val)));
        }
        return new LiteralExpression((BIDataValue)BDouble.make((double)val));
    }

    private ContextExpression contextExpression() {
        Expression inner = null;
        this.match(10);
        this.skipWhitespace();
        if (this.current.type != 2) {
            this.tokens.push(this.current);
            inner = new ExprParser().parse(this.tokens);
            this.next();
            this.skipWhitespace();
        }
        this.match(11);
        return new ContextExpression(inner);
    }

    private Expression parens() {
        Expression inner = null;
        this.match(8);
        this.skipWhitespace();
        if (this.current.type != 2) {
            inner = this.or();
            this.skipWhitespace();
        }
        this.match(9);
        return inner;
    }

    private Token next() {
        Token result = this.current;
        this.current = this.tokens.next();
        return result;
    }

    private Token match(int matchType) {
        Token result = this.current;
        if (this.current.type != matchType) {
            throw new UnexpectedTokenTypeException(this.current.index, matchType, this.current.type);
        }
        this.next();
        return result;
    }

    private Token skipWhitespace() {
        while (this.current.type == 0) {
            this.next();
        }
        return this.current;
    }

    private Token matchOperator(int matchOpType) {
        Token op = this.match(6);
        if (op.opType != matchOpType) {
            throw new UnexpectedTokenTypeException(this.current.index, 6, this.current.type);
        }
        return op;
    }
}

