/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.neql;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.baja.neql.Expression;
import javax.baja.neql.NeqlEntityEvaluator;
import javax.baja.security.BIProtected;
import javax.baja.sys.Context;
import javax.baja.tag.Entity;

public class BooleanFilterIterator
implements Iterator<Entity> {
    private boolean done;
    private boolean moved;
    private Entity current;
    private Iterator<? extends Entity> inner;
    private Context context;
    private Entity contextEntity;
    private Expression filterExpression;
    private NeqlEntityEvaluator evaluator;

    public BooleanFilterIterator(Iterator<? extends Entity> inner, Context context, Entity contextEntity, Expression filterExpression, NeqlEntityEvaluator evaluator) {
        this.inner = inner;
        this.context = context;
        this.contextEntity = contextEntity;
        this.filterExpression = filterExpression;
        this.evaluator = evaluator;
        this.done = false;
    }

    @Override
    public boolean hasNext() {
        if (this.done) {
            return false;
        }
        if (this.moved) {
            return this.current != null;
        }
        this.current = this.nextImpl();
        this.moved = true;
        return this.current != null;
    }

    @Override
    public Entity next() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        if (this.moved) {
            this.moved = false;
            return this.current;
        }
        this.moved = false;
        this.current = this.nextImpl();
        if (this.current != null) {
            return this.current;
        }
        throw new NoSuchElementException();
    }

    private Entity nextImpl() {
        if (this.done) {
            return null;
        }
        if (!this.inner.hasNext()) {
            this.done = true;
            return null;
        }
        while (this.inner.hasNext()) {
            Entity e = this.inner.next();
            if (e instanceof BIProtected && !((BIProtected)e).getPermissions(this.context).hasOperatorRead() || !this.evaluator.evalBoolean(this.filterExpression, e, this.context)) continue;
            return e;
        }
        return null;
    }
}

