/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.ui;

import com.tridium.andoverAC256.BAndoverDevice;
import com.tridium.andoverAC256.datatypes.BAndoverBackupConfig;
import com.tridium.andoverAC256.datatypes.BAndoverBackupRecord;
import com.tridium.andoverAC256.datatypes.BAndoverRestoreConfig;
import com.tridium.andoverAC256.datatypes.BAndoverSetOptionsConfig;
import com.tridium.andoverAC256.job.BAndoverBackupControllerJob;
import com.tridium.andoverAC256.job.BAndoverRestoreControllerJob;
import com.tridium.andoverAC256.job.BAndoverSetOptionsJob;
import com.tridium.ui.theme.Theme;
import com.tridium.util.TimeFormat;
import com.tridium.workbench.job.BJobBar;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

public class BAndoverBackupManager
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BAndoverBackupManager.class);
    static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BAndoverBackupManager.class);
    static final BImage icon = BImage.make((String)"module://icons/x16/backup.png");
    BJobBar jobBar;
    BTable table;
    Command cmdBackup = new Backup((BWidget)this);
    Command cmdRestore = new Restore((BWidget)this);
    Command cmdSetOptions = new SetOptions((BWidget)this);
    RestoreAbort cmdRestoreAbort = new RestoreAbort((BWidget)this);
    Delete cmdDelete = new Delete((BWidget)this);
    BAndoverDevice device;
    BAndoverBackupRecord[] recs;
    boolean restoreJobComplete = false;

    public Type getType() {
        return TYPE;
    }

    public BAndoverBackupManager() {
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane jobPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        jobPane.setFill(Theme.widget().getWindowBackground());
        jobPane = new BBorderPane((BWidget)jobPane, BBorder.inset, BInsets.DEFAULT);
        this.table = new BTable((TableModel)new Model());
        this.table.setMultipleSelection(false);
        this.table.setSelection((TableSelection)new Selection());
        BTitlePane tablePane = BTitlePane.makePane((String)lexicon.getText("backup.backups"), (BTable)this.table);
        BGridPane buttonPane = new BGridPane();
        buttonPane.setColumnCount(5);
        buttonPane.add(null, (BValue)new BButton(this.cmdBackup));
        buttonPane.add(null, (BValue)new BButton(this.cmdRestore));
        buttonPane.add(null, (BValue)new BButton((Command)this.cmdRestoreAbort));
        buttonPane.add(null, (BValue)new BButton((Command)this.cmdDelete));
        buttonPane.add(null, (BValue)new BButton(this.cmdSetOptions));
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BBorderPane((BWidget)jobPane, BInsets.make((double)0.0, (double)0.0, (double)5.0, (double)0.0)));
        edge.setCenter((BWidget)tablePane);
        edge.setBottom((BWidget)new BBorderPane((BWidget)buttonPane, 10.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)edge);
        this.registerForComponentEvents((BComponent)this.table);
    }

    public void doLoadValue(BObject object, Context cx) {
        this.device = (BAndoverDevice)object;
        this.registerForComponentEvents((BComponent)this.device.getBackupList());
        this.reload();
    }

    public void handleComponentEvent(BComponentEvent event) {
        super.handleComponentEvent(event);
        Restore restore = (Restore)this.cmdRestore;
        BJob restoreJob = restore.getJob();
        if (event.getSourceComponent() == restoreJob) {
            if (restoreJob.getJobState().isComplete() && !this.restoreJobComplete) {
                this.restoreJobComplete = true;
                this.table.setSelection((TableSelection)new Selection());
                this.reload();
            }
            return;
        }
        if (event.getSourceComponent() == this.device.getBackupList()) {
            if (event.getId() == 5) {
                this.reload();
            }
            return;
        }
    }

    public void reload() {
        this.recs = BAndoverBackupRecord.list((BAndoverDevice)this.device);
        this.table.getModel().updateTable();
        this.updateCommands();
    }

    private void updateCommands() {
        int count = this.table.getSelection().getRowCount();
        this.cmdRestore.setEnabled(count == 1);
        this.cmdDelete.setEnabled(count == 1);
        this.cmdRestoreAbort.setEnabled(false);
        this.cmdBackup.setEnabled(true);
    }

    class SetOptions
    extends Command {
        private BJob job;

        SetOptions(BWidget owner) {
            super(owner, (Lexicon)lexicon, "setOptions");
        }

        public CommandArtifact doInvoke() throws Exception {
            BAndoverSetOptionsConfig config = (BAndoverSetOptionsConfig)BAndoverBackupManager.this.device.getOptionCommandSettings().newCopy();
            BAndoverSetOptionsConfig params = (BAndoverSetOptionsConfig)BWbFieldEditor.dialog((BWidget)BAndoverBackupManager.this, (String)lexicon.get("backup.setOptions.configDialog"), (BObject)config);
            if (params == null) {
                return null;
            }
            BOrd jobOrd = BAndoverBackupManager.this.device.submitSetOptionsJob(params);
            BAndoverBackupManager.this.device.getComponentSpace().sync();
            this.job = (BAndoverSetOptionsJob)jobOrd.get((BObject)BAndoverBackupManager.this.device);
            BAndoverBackupManager.this.registerForComponentEvents((BComponent)this.job);
            BAndoverBackupManager.this.jobBar.load(this.job);
            BAndoverBackupManager.this.cmdRestore.setEnabled(false);
            return null;
        }

        public BJob getJob() {
            return this.job;
        }
    }

    class Delete
    extends Command {
        Delete(BWidget owner) {
            super(owner, (Lexicon)lexicon, "delete");
        }

        public CommandArtifact doInvoke() throws Exception {
            int[] rows = BAndoverBackupManager.this.table.getSelection().getRows();
            if (rows.length != 1) {
                return null;
            }
            BOrd fileOrd = (BOrd)BAndoverBackupManager.this.table.getModel().getValueAt(rows[0], 2);
            String fileName = (String)BAndoverBackupManager.this.table.getModel().getValueAt(rows[0], 1);
            String confirmLabel = lexicon.getText("backup.confirmDelete") + " " + fileName;
            if (BDialog.confirm((BWidget)this.getOwner(), (Object)confirmLabel) == 4) {
                BAndoverBackupManager.this.device.deleteBackupFile(fileOrd);
            }
            return null;
        }
    }

    class RestoreAbort
    extends Command {
        private BJob job;

        RestoreAbort(BWidget owner) {
            super(owner, (Lexicon)lexicon, "abort");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (this.job != null && this.job instanceof BAndoverRestoreControllerJob) {
                this.job.doCancel(null);
            }
            return null;
        }

        public void setJob(BJob job) {
            this.job = job;
        }
    }

    class Restore
    extends Command {
        private BJob job;

        Restore(BWidget owner) {
            super(owner, (Lexicon)lexicon, "restore");
        }

        public CommandArtifact doInvoke() throws Exception {
            int domain;
            int[] rows = BAndoverBackupManager.this.table.getSelection().getRows();
            if (rows.length != 1) {
                return null;
            }
            BAbsTime fileTimestamp = (BAbsTime)BAndoverBackupManager.this.table.getModel().getValueAt(rows[0], 0);
            String fileName = (String)BAndoverBackupManager.this.table.getModel().getValueAt(rows[0], 1);
            BOrd fileOrd = (BOrd)BAndoverBackupManager.this.table.getModel().getValueAt(rows[0], 2);
            int index1 = fileName.indexOf("_dom");
            int index2 = fileName.indexOf("_", index1 + 1);
            String controllerId = fileName.substring(index1 + 4, index2);
            try {
                domain = Integer.parseInt(controllerId);
            }
            catch (NumberFormatException e) {
                return null;
            }
            String controllerString = "LCU";
            if (domain == 0) {
                controllerString = "main controller";
            }
            BAndoverRestoreConfig config = new BAndoverRestoreConfig();
            config.setRestoreDialog("Restoring Domain " + controllerId + " (" + controllerString + ")");
            config.setFileName(fileName);
            config.setTimestamp(fileTimestamp);
            config.setDomain(domain);
            config.setOrd(fileOrd);
            BAndoverRestoreConfig params = (BAndoverRestoreConfig)BWbFieldEditor.dialog((BWidget)BAndoverBackupManager.this, (String)lexicon.get("backup.restore.configDialog"), (BObject)config);
            if (params == null) {
                return null;
            }
            BAndoverBackupManager.this.restoreJobComplete = false;
            BOrd jobOrd = BAndoverBackupManager.this.device.submitRestoreControllerJob(params);
            BAndoverBackupManager.this.device.getComponentSpace().sync();
            this.job = (BAndoverRestoreControllerJob)jobOrd.get((BObject)BAndoverBackupManager.this.device);
            BAndoverBackupManager.this.registerForComponentEvents((BComponent)this.job);
            BAndoverBackupManager.this.jobBar.load(this.job);
            BAndoverBackupManager.this.cmdRestoreAbort.setJob(this.job);
            BAndoverBackupManager.this.cmdRestoreAbort.setEnabled(true);
            BAndoverBackupManager.this.cmdBackup.setEnabled(false);
            BAndoverBackupManager.this.cmdDelete.setEnabled(false);
            return null;
        }

        public BJob getJob() {
            return this.job;
        }
    }

    class Backup
    extends Command {
        private BJob job;

        Backup(BWidget owner) {
            super(owner, (Lexicon)lexicon, "backup");
        }

        public CommandArtifact doInvoke() throws Exception {
            String controllerId = BAndoverBackupManager.this.device.getDevicePassword().substring(2);
            String timestamp = TimeFormat.format((BAbsTime)Clock.time(), (String)"YYMMDD_HHmm");
            BAndoverBackupConfig config = new BAndoverBackupConfig();
            BAndoverBackupConfig params = (BAndoverBackupConfig)BWbFieldEditor.dialog((BWidget)BAndoverBackupManager.this, (String)lexicon.get("backup.backup.configDialog"), (BObject)config);
            if (params == null) {
                return null;
            }
            String fileName = controllerId + "_dom" + params.getDomain() + "_" + timestamp + ".txt";
            params.setFileName(fileName);
            BOrd jobOrd = BAndoverBackupManager.this.device.submitBackupControllerJob(params);
            BAndoverBackupManager.this.device.getComponentSpace().sync();
            this.job = (BAndoverBackupControllerJob)jobOrd.get((BObject)BAndoverBackupManager.this.device);
            BAndoverBackupManager.this.registerForComponentEvents((BComponent)this.job);
            BAndoverBackupManager.this.jobBar.load(this.job);
            BAndoverBackupManager.this.cmdRestore.setEnabled(false);
            return null;
        }

        public BJob getJob() {
            return this.job;
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BAndoverBackupManager.this.recs.length;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return BAndoverBackupRecord.timestamp.getDefaultDisplayName(null);
                }
                case 1: {
                    return BAndoverBackupRecord.path.getDefaultDisplayName(null);
                }
                case 2: {
                    return BAndoverBackupRecord.ord.getDefaultDisplayName(null);
                }
            }
            return "???";
        }

        public Object getValueAt(int row, int col) {
            BAndoverBackupRecord rec = BAndoverBackupManager.this.recs[row];
            switch (col) {
                case 0: {
                    return rec.getTimestamp();
                }
                case 1: {
                    return rec.getPath();
                }
                case 2: {
                    return rec.getOrd();
                }
            }
            return "???";
        }

        public BImage getRowIcon(int row) {
            return icon;
        }

        public void updateTable() {
            super.updateTable();
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BAndoverBackupManager.this.updateCommands();
        }
    }
}

