/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.util;

import com.tridium.driver.util.StringUtil;
import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.comm.http.NHttpResponse;
import com.tridium.ndriver.datatypes.BIpAddress;
import java.util.StringTokenizer;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;

public class XProtectHttpUtil {
    public static void enableDetection(HttpComm hcom, BIpAddress addr, int cameraNo, boolean on) throws Exception {
        int desired;
        int ndx = cameraNo - 1;
        boolean change = false;
        int[] actActions = XProtectHttpUtil.getActActions(hcom, addr);
        int n = desired = on ? 1 : 0;
        if (actActions[ndx] != desired) {
            actActions[ndx] = desired;
            change = true;
        }
        if (change) {
            String uri = "/vmd.frm?foo=&act_actions[0]=" + StringUtil.toString((int[])actActions);
            XProtectHttpUtil.get(hcom, addr, uri);
        }
    }

    public static int[] getActActions(HttpComm hcom, BIpAddress addr) throws Exception {
        String uri = "/variable.cgi?variable=act_actions[]";
        NHttpResponse resp = XProtectHttpUtil.get(hcom, addr, uri);
        String respString = new String(resp.getData());
        return StringUtil.getIntArray((String)respString);
    }

    public static String[] getCameraTitles(HttpComm hcom, BIpAddress addr) throws Exception {
        String uri = "/variable.cgi?variable=c_title[]";
        NHttpResponse resp = XProtectHttpUtil.get(hcom, addr, uri);
        Array cameraTitlesArray = new Array(String.class);
        String respString = new String(resp.getData());
        StringTokenizer st = new StringTokenizer(respString, ",");
        while (st.hasMoreTokens()) {
            String nextCameraName = st.nextToken().trim();
            if (nextCameraName.startsWith("\"")) {
                nextCameraName = nextCameraName.substring(1);
            }
            if (nextCameraName.endsWith("\"")) {
                nextCameraName = nextCameraName.substring(0, nextCameraName.length() - 1);
            }
            cameraTitlesArray.add((Object)nextCameraName);
        }
        return (String[])cameraTitlesArray.trim();
    }

    public static long getCurrentTimeSec(HttpComm hcom, BIpAddress addr) throws Exception {
        String uri = "/variable.cgi?variable=current_julian";
        NHttpResponse resp = XProtectHttpUtil.get(hcom, addr, uri);
        byte[] dat = resp.getData();
        String httpReplyText = new String(dat, 0, dat.length);
        long time = Long.parseLong(httpReplyText);
        return time;
    }

    public static BAbsTime getCurrentAbsTime(HttpComm hcom, BIpAddress addr) throws Exception {
        long tmSec = XProtectHttpUtil.getCurrentTimeSec(hcom, addr);
        return BAbsTime.make((long)(tmSec * 1000L));
    }

    public static NHttpResponse get(HttpComm hcom, BIpAddress addr, String uri) throws Exception {
        String meth = "GET";
        NHttpRequest rqst = new NHttpRequest(addr, meth, uri);
        return hcom.sendRequest(rqst);
    }
}

