/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.server.recording;

import com.tridium.driver.util.DrUtil;
import com.tridium.nvideo.event.BVideoEventStatus;
import com.tridium.nvideo.recordingServer.BVideoRecordingServer;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.event.BVideoEvent;
import com.tridium.xprotect.BMilestoneXProtectNetwork;
import com.tridium.xprotect.camera.BXProtectCamera;
import com.tridium.xprotect.camera.BXProtectCameraDeviceId;
import com.tridium.xprotect.datatypes.BXProtectConnectionState;
import com.tridium.xprotect.datatypes.BXProtectEventTypesEnum;
import com.tridium.xprotect.event.BXProtectEventCameraExt;
import com.tridium.xprotect.event.BXProtectEventProxyExt;
import com.tridium.xprotect.server.management.BXProtectManagementServer;
import com.tridium.xprotect.server.recording.BXProtectRecordingServerId;
import com.tridium.xprotect.soap.IMIPService;
import com.tridium.xprotect.util.WebProcessUtil;
import com.tridium.xprotect.util.XProtectTcpUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

public class BXProtectRecordingServer
extends BVideoRecordingServer {
    public static final Property id = BXProtectRecordingServer.newProperty((int)0, (BValue)new BXProtectRecordingServerId(), null);
    public static final Property pollFrequency = BXProtectRecordingServer.newProperty((int)0, (BValue)BPollFrequency.slow, null);
    public static final Type TYPE = Sys.loadType(BXProtectRecordingServer.class);
    protected static Logger log = Logger.getLogger(BXProtectRecordingServer.class.getName());
    public static final String MOTION_STARTED_GUID = "6EB95DD6-7CCC-4BCE-99F8-AF0D0B582D77";
    public static final String MOTION_STOPPED_GUID = "6F55A7A7-D21C-4629-AC18-AF1975E395A2";
    boolean isPolled = false;
    String sEventSessionId = "";

    public BXProtectRecordingServerId getId() {
        return (BXProtectRecordingServerId)this.get(id);
    }

    public void setId(BXProtectRecordingServerId v) {
        this.set(id, (BValue)v, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void descendantsStarted() throws Exception {
        ((BMilestoneXProtectNetwork)this.getNetwork()).getPoll().subscribe((BIPollable)this);
        super.started();
    }

    public void stopped() throws Exception {
        ((BMilestoneXProtectNetwork)this.getNetwork()).getPoll().unsubscribe((BIPollable)this);
        super.stopped();
    }

    public Type getNetworkType() {
        return BMilestoneXProtectNetwork.TYPE;
    }

    public BXProtectManagementServer getManagementServer() {
        return (BXProtectManagementServer)DrUtil.getParent((BComplex)this, (Type)BXProtectManagementServer.TYPE);
    }

    public BMilestoneXProtectNetwork getXProtectNetwork() {
        return (BMilestoneXProtectNetwork)DrUtil.getParent((BComplex)this, (Type)BMilestoneXProtectNetwork.TYPE);
    }

    public void doPing() throws Exception {
        try (Socket sock = new Socket(this.getId().getHostname(), this.getId().getPort());){
            String connectStr = BXProtectRecordingServer.getConnectString();
            sock.getOutputStream().write(connectStr.getBytes("ASCII"));
            sock.getOutputStream().flush();
            BufferedReader sockIn = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            String connectResp = sockIn.readLine();
            if (connectResp.contains("HTTP/1.1 400")) {
                this.pingOk();
            } else {
                super.pingFail("Recording Server Ping Failed.");
            }
        }
        catch (Exception e) {
            this.pingFail(e.getLocalizedMessage());
            throw e;
        }
    }

    public void doPoll() {
        if (this.getManagementServer().getConnection().getConnectionState() != BXProtectConnectionState.connected) {
            log.log(Level.FINE, "RecordingServerPoll : Management Server not Connected");
            return;
        }
        IMIPService service = WebProcessUtil.getService(this.getXProtectNetwork().getHttpConfig().getUseTls());
        if (!this.isPolled) {
            this.sEventSessionId = "";
            this.sEventSessionId = AccessController.doPrivileged(() -> service.setupPollConfigServer(this.getId().getId(), this.getManagementServer().getConnection().getAuthAttributes().getToken(), MOTION_STARTED_GUID, MOTION_STOPPED_GUID));
            this.isPolled = true;
        }
        String strEventsData = AccessController.doPrivileged(() -> service.pollConfigServer(this.getId().getId(), this.sEventSessionId, this.getManagementServer().getConnection().getAuthAttributes().getToken()));
        ByteArrayInputStream bais = new ByteArrayInputStream(strEventsData.getBytes());
        try {
            XElem rootElem = XProtectTcpUtil.getElem(bais, "root");
            if (rootElem != null) {
                XElem[] events = rootElem.elems("Events");
                for (int i = 0; i < events.length; ++i) {
                    String strSrcId = events[i].elem("SourceId").text().toString();
                    String strEventId = events[i].elem("EventId").text().toString();
                    BAbsTime time = XProtectTcpUtil.getTime(events[i], "Timestamp");
                    if (!strEventId.equalsIgnoreCase(MOTION_STARTED_GUID) && !strEventId.equalsIgnoreCase(MOTION_STOPPED_GUID)) continue;
                    this.processMotionDetectionEvent(strSrcId, strEventId, time);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processMotionDetectionEvent(String cameraGuid, String strEvenId, BAbsTime time) {
        BIVideoCamera[] cameras = this.getManagementServer().getCameras().getAllCameras();
        for (int i = 0; i < cameras.length; ++i) {
            String cameraGuidInDatabase;
            BXProtectCamera milestoneCamera = (BXProtectCamera)cameras[i];
            if (!milestoneCamera.getStatus().isValid() || !cameraGuid.equals(cameraGuidInDatabase = ((BXProtectCameraDeviceId)milestoneCamera.get("videoDeviceId")).getCameraId())) continue;
            this.getMatchingMilestoneCameraToUpdateEvent(strEvenId, time, milestoneCamera);
        }
    }

    private void getMatchingMilestoneCameraToUpdateEvent(String strEvenId, BAbsTime time, BXProtectCamera milestoneCamera) {
        BXProtectEventCameraExt eventExt = (BXProtectEventCameraExt)milestoneCamera.getEvents();
        BControlPoint[] eventPoints = eventExt.getPoints();
        for (int cameraPointIndex = 0; cameraPointIndex < eventPoints.length; ++cameraPointIndex) {
            BVideoEvent videoEvent;
            BXProtectEventProxyExt eventProxy = (BXProtectEventProxyExt)eventPoints[cameraPointIndex].getProxyExt();
            if (eventProxy.getXprotectEventTypeEnum() != BXProtectEventTypesEnum.motionDetected) continue;
            if (strEvenId.equalsIgnoreCase(MOTION_STARTED_GUID)) {
                videoEvent = BVideoEvent.makeMotionStarted();
                videoEvent.setTimestamp(time);
                eventProxy.readOk((BStatusValue)new BVideoEventStatus(videoEvent));
                continue;
            }
            if (!strEvenId.equalsIgnoreCase(MOTION_STOPPED_GUID)) continue;
            videoEvent = BVideoEvent.makeMotionStopped();
            videoEvent.setTimestamp(time);
            eventProxy.readOk((BStatusValue)new BVideoEventStatus(videoEvent));
        }
    }

    private static String getConnectString() {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?><methodcall><methodname>connect</methodname></methodcall>\r\n\r\n";
    }
}

