/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.messages;

import com.tridium.ndriver.comm.IMessageFactory;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.xprotect.messages.XProtectCameraPingRsp;
import com.tridium.xprotect.messages.XProtectEventRefreshRsp;
import com.tridium.xprotect.messages.XProtectTcpLinkMessage;
import com.tridium.xprotect.messages.XProtectUnsolicitedMessage;
import com.tridium.xprotect.util.XProtectTcpUtil;
import java.io.InputStream;
import javax.baja.xml.XElem;

public class XProtectMessageFactory
implements IMessageFactory {
    public Object syncObj = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NMessage makeMessage(LinkMessage lm) throws Exception {
        Object object = this.syncObj;
        synchronized (object) {
            XProtectTcpLinkMessage lkmsg = (XProtectTcpLinkMessage)lm;
            if (this.isCameraConnectRsp(lkmsg.getInputStream())) {
                lkmsg.getInputStream().reset();
                XProtectCameraPingRsp msg = new XProtectCameraPingRsp(lkmsg.getInputStream());
                msg.setAddress((BAddress)lkmsg.address);
                return msg;
            }
            lkmsg.getInputStream().reset();
            if (this.isPtzRsp(lkmsg.getInputStream())) {
                return null;
            }
            lkmsg.getInputStream().reset();
            if (this.isPresetRsp(lkmsg.getInputStream())) {
                return null;
            }
            lkmsg.getInputStream().reset();
            if (this.isEventRefreshAroundResp(lkmsg.getInputStream())) {
                XProtectEventRefreshRsp msg = new XProtectEventRefreshRsp(lkmsg.getInputStream());
                msg.setAddress((BAddress)lkmsg.address);
                return msg;
            }
            lkmsg.getInputStream().reset();
            XProtectUnsolicitedMessage msg = new XProtectUnsolicitedMessage(lkmsg.getInputStream());
            msg.setAddress((BAddress)lkmsg.address);
            msg.fromInputStream(msg.in);
            return msg;
        }
    }

    boolean isCameraConnectRsp(InputStream in) {
        try {
            XElem methodResponseElem = XProtectTcpUtil.getElem(in, "methodresponse");
            String connectedString = XProtectTcpUtil.getText(methodResponseElem, "methodname");
            return connectedString.equalsIgnoreCase("connect");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean isPtzRsp(InputStream in) {
        try {
            XElem methodResponseElem = XProtectTcpUtil.getElem(in, "methodresponse");
            String connectedString = XProtectTcpUtil.getText(methodResponseElem, "methodname");
            return connectedString.equalsIgnoreCase("ptz");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean isPresetRsp(InputStream in) {
        try {
            XElem methodResponseElem = XProtectTcpUtil.getElem(in, "methodresponse");
            String connectedString = XProtectTcpUtil.getText(methodResponseElem, "methodname");
            return connectedString.equalsIgnoreCase("preset");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean isEventRefreshAroundResp(InputStream in) {
        try {
            XElem methodResponse = XProtectTcpUtil.getMilestoneMethodResponseElem(in);
            String methodName = XProtectTcpUtil.getText(methodResponse, "methodname");
            return "alarms".equals(methodName);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

