/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.type;

import com.tridium.ndio.point.BNdioCounterInputProxyExt;
import com.tridium.ndio.type.BFixedWindowRateType;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

public class BSlidingWindowRateType
extends BFixedWindowRateType {
    public static final Property windows = BSlidingWindowRateType.newProperty((int)0, (int)6, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)2)));
    public static final Type TYPE = Sys.loadType(BSlidingWindowRateType.class);
    private Queue queue = new Queue(6);
    private long lastTicks = 0L;
    private Clock.Ticket ticket = null;

    public int getWindows() {
        return this.getInt(windows);
    }

    public void setWindows(int v) {
        this.setInt(windows, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning()) {
            if (property.equals(windows)) {
                this.resizeQueue();
                this.resetRate();
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                this.ticket = Clock.schedulePeriodically((BComponent)this.getCounterProxy(), (BAbsTime)BAbsTime.now(), (BRelTime)BRelTime.make((long)this.getWindowSize()), (Action)BNdioCounterInputProxyExt.recalculateRate, null);
            }
            if (property.equals(interval)) {
                this.resetRate();
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                this.ticket = Clock.schedulePeriodically((BComponent)this.getCounterProxy(), (BAbsTime)BAbsTime.now(), (BRelTime)BRelTime.make((long)this.getWindowSize()), (Action)BNdioCounterInputProxyExt.recalculateRate, null);
            }
        }
    }

    @Override
    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.resizeQueue();
        this.resetRate();
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this.getCounterProxy(), (BAbsTime)BAbsTime.now(), (BRelTime)BRelTime.make((long)this.getWindowSize()), (Action)BNdioCounterInputProxyExt.recalculateRate, null);
    }

    @Override
    public void stopped() throws Exception {
        super.stopped();
        this.resetRate();
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = null;
    }

    @Override
    public synchronized void resetRate() {
        this.queue.clear();
        this.lastTicks = 0L;
        if (this.getCounterProxy() != null) {
            this.getCounterProxy().setStale(true, null);
        }
    }

    @Override
    public synchronized BStatusNumeric calculateRate(long count) {
        BStatusNumeric srate = null;
        long ticks = Clock.ticks();
        if (this.lastTicks == 0L) {
            this.lastTicks = ticks;
            CountSample sample = new CountSample(ticks, count);
            this.queue.enqueue((Object)sample);
            return null;
        }
        long delta = ticks - this.lastTicks;
        if (this.queue.size() == this.getWindows()) {
            CountSample lastSample = (CountSample)this.queue.dequeue();
            long countdelta = count - lastSample.getCount();
            float timedelta = (float)(ticks - lastSample.getTicks()) / 1000.0f;
            float rate = (float)countdelta / timedelta;
            srate = new BStatusNumeric((double)(rate *= this.getScale()));
            this.getCounterProxy().setRateCalcTime(BAbsTime.now());
        }
        CountSample sample = new CountSample(ticks, count);
        this.queue.enqueue((Object)sample);
        this.lastTicks = ticks;
        if (srate == null) {
            srate = (BStatusNumeric)this.getCounterProxy().getReadValue();
        }
        return srate;
    }

    private synchronized void resizeQueue() {
        Queue newq = new Queue(this.getWindows());
        if (this.queue != null) {
            for (int i = 0; i < this.queue.size(); ++i) {
                newq.enqueue(this.queue.dequeue());
            }
        }
        this.queue = newq;
    }

    private synchronized long getWindowSize() {
        return this.getInterval().getSeconds() / this.getWindows() * 1000;
    }

    class CountSample {
        private long ticks;
        private long count;

        public CountSample(long ticks, long count) {
            this.ticks = ticks;
            this.count = count;
        }

        public long getTicks() {
            return this.ticks;
        }

        public long getCount() {
            return this.count;
        }

        public String toString() {
            return " tx:" + this.ticks + ",cnt:" + this.count;
        }
    }
}

