/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.point;

import com.tridium.ndio.point.BNdioOutputProxyExt;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNdioHardwareOverride
extends BComponent
implements BIAlarmSource {
    public static final Property overridden = BNdioHardwareOverride.newProperty((int)3, (boolean)false, null);
    public static final Property faultEnable = BNdioHardwareOverride.newProperty((int)0, (boolean)true, null);
    public static final Property alarmEnable = BNdioHardwareOverride.newProperty((int)0, (boolean)false, null);
    public static final Property alarmClass = BNdioHardwareOverride.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassEditor")));
    public static final Action ackAlarm = BNdioHardwareOverride.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BNdioHardwareOverride.class);
    protected static final Log log = Log.getLog((String)"ndio");
    private AlarmSupport alarmSupport;
    private boolean inAlarm = false;
    private boolean haveUnackedAlarm = false;

    public boolean getOverridden() {
        return this.getBoolean(overridden);
    }

    public void setOverridden(boolean v) {
        this.setBoolean(overridden, v, null);
    }

    public boolean getFaultEnable() {
        return this.getBoolean(faultEnable);
    }

    public void setFaultEnable(boolean v) {
        this.setBoolean(faultEnable, v, null);
    }

    public boolean getAlarmEnable() {
        return this.getBoolean(alarmEnable);
    }

    public void setAlarmEnable(boolean v) {
        this.setBoolean(alarmEnable, v, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public BBoolean ackAlarm(BAlarmRecord ackRequest) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)ackRequest, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmClass());
    }

    public void stopped() {
        this.alarmSupport = null;
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (this.isRunning()) {
            if (prop.equals(alarmClass)) {
                this.alarmSupport.setAlarmClass(this.getAlarmClass());
            }
            if (prop.equals(alarmEnable)) {
                BNdioOutputProxyExt ext;
                if (this.inAlarm) {
                    try {
                        this.alarmSupport.toNormal(null);
                        this.inAlarm = false;
                    }
                    catch (Exception e) {
                        log.error("Unable to clear alarm", (Throwable)e);
                    }
                }
                if ((ext = (BNdioOutputProxyExt)this.getParent()) != null) {
                    ext.checkPointSubscription();
                }
            }
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return super.isParentLegal(parent) && parent instanceof BNdioOutputProxyExt;
    }

    public synchronized void evaluate(BStatusValue out, boolean overridden) {
        if (!this.haveUnackedAlarm) {
            out.setStatusUnackedAlarm(false);
        }
        this.setOverridden(overridden);
        boolean isWorkingVariableOverridden = out.getStatus().isOverridden();
        boolean isWorkingVariableFault = out.getStatus().isFault();
        boolean isWorkingVariableAlarm = out.getStatus().isAlarm();
        boolean isWorkingVariableUnackedAlarm = out.getStatus().isUnackedAlarm();
        if (overridden) {
            out.setStatusOverridden(true);
            if (this.getFaultEnable()) {
                out.setStatusFault(true);
            }
            if (this.getAlarmEnable()) {
                out.setStatusInAlarm(true);
                if (!this.inAlarm) {
                    try {
                        BFacets facets = BFacets.make((String)"msgText", (BIDataValue)BString.make((String)"ndio hardware override activated"), (String)"sourceName", (BIDataValue)BString.make((String)this.getParent().getParent().getName()));
                        if (this.getFaultEnable()) {
                            this.alarmSupport.newFaultAlarm(facets);
                            if (this.alarmSupport.isAckRequired(BSourceState.fault)) {
                                this.haveUnackedAlarm = true;
                            }
                        } else {
                            this.alarmSupport.newOffnormalAlarm(facets);
                            if (this.alarmSupport.isAckRequired(BSourceState.offnormal)) {
                                this.haveUnackedAlarm = true;
                            }
                        }
                        this.inAlarm = true;
                    }
                    catch (Exception e) {
                        log.error("Unable to generate alarm", (Throwable)e);
                    }
                }
            }
        } else {
            out.setStatusFault(isWorkingVariableFault);
            out.setStatusInAlarm(isWorkingVariableAlarm);
            out.setStatusOverridden(isWorkingVariableOverridden);
            out.setStatusUnackedAlarm(isWorkingVariableUnackedAlarm);
            if (this.inAlarm) {
                try {
                    this.alarmSupport.toNormal(null);
                    this.inAlarm = false;
                }
                catch (Exception e) {
                    log.error("Unable to clear alarm", (Throwable)e);
                }
            }
        }
        if (this.haveUnackedAlarm) {
            out.setStatusUnackedAlarm(true);
        }
    }

    public synchronized BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        try {
            boolean val = this.alarmSupport.ackAlarm(ackRequest);
            if (val) {
                this.haveUnackedAlarm = false;
            }
            return BBoolean.make((boolean)val);
        }
        catch (Exception e) {
            return BBoolean.FALSE;
        }
    }
}

