/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.point;

import com.tridium.ndio.enums.BNdioCounterSelectEnum;
import com.tridium.ndio.enums.BNdioPointTypeEnum;
import com.tridium.ndio.point.BNdioUniversalInputProxyExt;
import com.tridium.ndio.type.BAbstractRateType;
import com.tridium.ndio.type.BFixedWindowRateType;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BNdioCounterInputProxyExt
extends BNdioUniversalInputProxyExt {
    public static final Property pointType = BNdioCounterInputProxyExt.newProperty((int)1, (BValue)BNdioPointTypeEnum.counterInput, null);
    public static final Property outputSelect = BNdioCounterInputProxyExt.newProperty((int)0, (BValue)BNdioCounterSelectEnum.count, null);
    public static final Property total = BNdioCounterInputProxyExt.newProperty((int)1, (int)0, null);
    public static final Property rate = BNdioCounterInputProxyExt.newProperty((int)3, (int)0, null);
    public static final Property rateCalcType = BNdioCounterInputProxyExt.newProperty((int)0, (BValue)BTypeSpec.make((String)"ndio:FixedWindowRateType"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"ndio:AbstractRateType")));
    public static final Property rateCalc = BNdioCounterInputProxyExt.newProperty((int)1, (BValue)new BFixedWindowRateType(), null);
    public static final Property rateCalcTime = BNdioCounterInputProxyExt.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    public static final Action reset = BNdioCounterInputProxyExt.newAction((int)0, null);
    public static final Action set = BNdioCounterInputProxyExt.newAction((int)0, (BValue)BLong.make((long)0L), null);
    public static final Action recalculateRate = BNdioCounterInputProxyExt.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BNdioCounterInputProxyExt.class);

    public BNdioCounterSelectEnum getOutputSelect() {
        return (BNdioCounterSelectEnum)this.get(outputSelect);
    }

    public void setOutputSelect(BNdioCounterSelectEnum v) {
        this.set(outputSelect, (BValue)v, null);
    }

    public long getTotal() {
        return this.getLong(total);
    }

    public void setTotal(long v) {
        this.setLong(total, v, null);
    }

    public double getRate() {
        return this.getDouble(rate);
    }

    public void setRate(double v) {
        this.setDouble(rate, v, null);
    }

    public BTypeSpec getRateCalcType() {
        return (BTypeSpec)this.get(rateCalcType);
    }

    public void setRateCalcType(BTypeSpec v) {
        this.set(rateCalcType, (BValue)v, null);
    }

    public BAbstractRateType getRateCalc() {
        return (BAbstractRateType)this.get(rateCalc);
    }

    public void setRateCalc(BAbstractRateType v) {
        this.set(rateCalc, (BValue)v, null);
    }

    public BAbsTime getRateCalcTime() {
        return (BAbsTime)this.get(rateCalcTime);
    }

    public void setRateCalcTime(BAbsTime v) {
        this.set(rateCalcTime, (BValue)v, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public void set(BLong param) {
        this.invoke(set, (BValue)param, null);
    }

    public void recalculateRate() {
        this.invoke(recalculateRate, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        return super.isParentLegal(parent) && parent instanceof BNumericPoint;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readonly;
    }

    @Override
    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (this.isRunning()) {
            if (prop.equals(rateCalcType)) {
                BAbstractRateType type = (BAbstractRateType)this.getRateCalcType().getInstance();
                this.getRateCalc().cleanupType();
                this.setRateCalc(type);
                this.getRateCalc().initType();
                this.setStale(true, null);
            }
            if (prop.equals(outputSelect)) {
                this.setStale(true, null);
            }
        }
    }

    @Override
    public synchronized void read() {
        if (!this.pointSynchronized()) {
            return;
        }
        try {
            BStatusNumeric value = this.readNumericValue();
            if (this.getOutputSelect() == BNdioCounterSelectEnum.count) {
                this.readOk((BStatusValue)value);
            }
        }
        catch (Exception e) {
            this.readFail(e.getMessage());
        }
    }

    public void doReset() {
        this.doSet(BLong.make((long)0L));
    }

    public synchronized void doSet(BLong param) {
        this.getRateCalc().resetRate();
        this.setTotal(param.getLong());
        this.read();
    }

    public void doRecalculateRate() {
        if (!this.pointSynchronized()) {
            return;
        }
        try {
            this.readNumericValue();
            BStatusNumeric value = this.getRateCalc().calculateRate(this.getTotal());
            if (value != null) {
                this.setRate(value.getValue());
                if (this.getOutputSelect() == BNdioCounterSelectEnum.rate) {
                    this.readOk((BStatusValue)value);
                }
            } else if (this.getOutputSelect() == BNdioCounterSelectEnum.rate) {
                this.setStale(true, null);
            }
        }
        catch (Exception e) {
            this.readFail(e.getMessage());
        }
    }

    protected synchronized BStatusNumeric readNumericValue() throws Exception {
        long raw = this.getBoard().readUICount(this.getAddress());
        this.setRaw(raw);
        long value = this.getBoard().readUICountDelta(this.getAddress());
        long total = this.getTotal();
        this.setTotal(total += value);
        BStatusNumeric stotal = new BStatusNumeric((double)total);
        return stotal;
    }
}

