/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.learn;

import com.tridium.ndio.BNdioBoard;
import com.tridium.ndio.enums.BNdioIoTypeEnum;
import com.tridium.ndio.learn.BNdioPointEntry;
import com.tridium.ndio.point.BNdioPointDeviceExt;
import javax.baja.job.BSimpleJob;
import javax.baja.log.Log;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNdioPointDiscoveryJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BNdioPointDiscoveryJob.class);
    static final Log log = Log.getLog((String)"ndio");
    private BNdioPointDeviceExt ext = null;

    public Type getType() {
        return TYPE;
    }

    public BNdioPointDiscoveryJob() {
    }

    public BNdioPointDiscoveryJob(BNdioPointDeviceExt ext) {
        this.ext = ext;
    }

    public void run(Context cx) {
        BNdioPointEntry entry;
        int i;
        if (this.ext == null) {
            throw new IllegalStateException("Must submit thru ndioPointDeviceExt.submitDiscoveryJob()");
        }
        this.log().start("Point discovery");
        this.removeAll();
        this.progress(0);
        BComponent event = new BComponent();
        BNdioBoard board = (BNdioBoard)this.ext.getParent();
        for (i = 0; i < board.getUiCount(); ++i) {
            entry = new BNdioPointEntry(BNdioIoTypeEnum.universalInput, i + 1);
            this.add("universalInput" + (i + 1), (BValue)entry);
            this.log().success("Identified universal input @ " + (i + 1));
        }
        this.progress(33);
        for (i = 0; i < board.getBoCount(); ++i) {
            entry = new BNdioPointEntry(BNdioIoTypeEnum.booleanOutput, i + 1);
            this.add("booleanOutput" + (i + 1), (BValue)entry);
            this.log().success("Identified boolean output @ " + (i + 1));
        }
        this.progress(67);
        for (i = 0; i < board.getAoCount(); ++i) {
            entry = new BNdioPointEntry(BNdioIoTypeEnum.analogOutput, i + 1);
            this.add("analogOutput" + (i + 1), (BValue)entry);
            this.log().success("Identified analog output @ " + (i + 1));
        }
        this.progress(100);
        this.log().success("Discovery done");
    }
}

