/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.conv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitException;

public final class BThermistorType3Conversion
extends BProxyConversion {
    public static final BThermistorType3Conversion DEFAULT = new BThermistorType3Conversion();
    public static final Type TYPE = Sys.loadType(BThermistorType3Conversion.class);
    private static BUnit OHMS_UNIT = BUnit.getUnit((String)"ohm");
    private static BUnit CELSIUS_UNIT = BUnit.getUnit((String)"celsius");
    private static double[] ohmsArray = new double[]{0.0, 610.0, 1060.0, 1690.0, 2320.0, 3250.0, 4620.0, 6240.0, 8197.0, 10000.0, 12268.0, 15136.0, 18787.0, 23462.0, 29490.0, 37316.0, 47549.0, 61030.0, 78930.0, 100000.0};
    private static double[] celsiusArray = new double[]{165.0, 110.0, 90.0, 75.0, 65.0, 55.0, 45.0, 37.0, 30.0, 25.0, 20.0, 15.0, 10.0, 5.0, 0.0, -5.0, -10.0, -15.0, -20.0, -25.0};

    public void convertDeviceToProxy(BProxyExt ext, BStatusValue deviceValue, BStatusValue proxyValue) throws Exception {
        if (deviceValue instanceof BStatusNumeric) {
            BUnit proxyUnit = (BUnit)ext.getPointFacets().get("units", (BObject)BUnit.NULL);
            BUnit deviceUnit = (BUnit)ext.getDeviceFacets().get("units", (BObject)BUnit.NULL);
            boolean deviceOk = deviceUnit.isConvertible(OHMS_UNIT) || deviceUnit.isNull();
            boolean proxyOk = proxyUnit.isConvertible(CELSIUS_UNIT);
            if (deviceOk && proxyOk) {
                double ohms = deviceUnit.convertTo(OHMS_UNIT, ((BStatusNumeric)deviceValue).getValue());
                double celsius = this.convertTo(ohms, ohmsArray, celsiusArray);
                proxyValue.setStatus(deviceValue.getStatus());
                ((BStatusNumeric)proxyValue).setValue(CELSIUS_UNIT.convertTo(proxyUnit, celsius));
                return;
            }
            proxyValue.copyFrom((BComplex)deviceValue);
            throw new UnitException("Not convertible: " + deviceUnit + " -> " + proxyUnit);
        }
        proxyValue.copyFrom((BComplex)deviceValue);
        throw new UnitException("Not convertible: invalid point type");
    }

    public void convertProxyToDevice(BProxyExt ext, BStatusValue proxyValue, BStatusValue deviceValue) throws Exception {
        if (proxyValue instanceof BStatusNumeric) {
            BUnit proxyUnit = (BUnit)ext.getPointFacets().get("units", (BObject)BUnit.NULL);
            BUnit deviceUnit = (BUnit)ext.getDeviceFacets().get("units", (BObject)BUnit.NULL);
            boolean deviceOk = deviceUnit.isConvertible(OHMS_UNIT) || deviceUnit.isNull();
            boolean proxyOk = proxyUnit.isConvertible(CELSIUS_UNIT);
            if (deviceOk && proxyOk) {
                double celsius = proxyUnit.convertTo(CELSIUS_UNIT, ((BStatusNumeric)proxyValue).getValue());
                double ohms = this.convertTo(celsius, celsiusArray, ohmsArray);
                deviceValue.setStatus(proxyValue.getStatus());
                ((BStatusNumeric)deviceValue).setValue(OHMS_UNIT.convertTo(deviceUnit, ohms));
                return;
            }
            deviceValue.copyFrom((BComplex)proxyValue);
            throw new UnitException("Not convertible: " + proxyUnit + " -> " + deviceUnit);
        }
        deviceValue.copyFrom((BComplex)proxyValue);
        throw new UnitException("Not convertible: invalid point type");
    }

    private double convertTo(double src, double[] srcArray, double[] destArray) {
        int band = 0;
        int count = srcArray.length;
        if (src < srcArray[0]) {
            return destArray[0];
        }
        if (src > srcArray[count - 1]) {
            return destArray[count - 1];
        }
        if (src == srcArray[count - 1]) {
            return destArray[count - 1];
        }
        for (int i = 0; i < count - 1; ++i) {
            if (!(src >= srcArray[i]) || !(src < srcArray[i + 1])) continue;
            band = i;
            break;
        }
        double p1 = srcArray[band];
        double p2 = srcArray[band + 1];
        double v1 = destArray[band];
        double v2 = destArray[band + 1];
        return v1 - (p1 - src) * (v1 - v2) / (p1 - p2);
    }

    public int hashCode() {
        return 64206;
    }

    public boolean equals(Object obj) {
        return obj instanceof BThermistorType3Conversion;
    }

    public String toString(Context context) {
        return TYPE.getDisplayName(context);
    }

    public void encode(DataOutput out) throws IOException {
    }

    public BObject decode(DataInput in) throws IOException {
        return DEFAULT;
    }

    public String encodeToString() {
        return "";
    }

    public BObject decodeFromString(String s) throws IOException {
        return DEFAULT;
    }

    private BThermistorType3Conversion() {
    }

    public Type getType() {
        return TYPE;
    }
}

