/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.addons.bacnet.util;

import com.tridiumemea.addons.bacnet.util.Log;
import java.util.Objects;
import java.util.logging.Level;
import javax.baja.sys.BComplex;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Type;

public final class ParentLegal {
    public static boolean disableChecks;

    private ParentLegal() {
    }

    public static boolean is(Type child, Type parent, Type expected, Type alternative) {
        Object[] expectedParentLexiconMsgArgs;
        String key;
        Objects.requireNonNull(child);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(expected);
        if (parent.is(expected)) {
            return true;
        }
        if (alternative != null && parent.is(alternative)) {
            return true;
        }
        if (alternative == null) {
            key = "mustBeParentedBy";
            expectedParentLexiconMsgArgs = new Object[]{child.getTypeName(), expected.getTypeName(), parent.getTypeName()};
        } else {
            key = "mustBeParentedByOr";
            expectedParentLexiconMsgArgs = new Object[]{child.getTypeName(), expected.getTypeName(), alternative.getTypeName(), parent.getTypeName()};
        }
        IllegalParentException pe = new IllegalParentException(child.getModule().getModuleName(), key, expectedParentLexiconMsgArgs);
        if (disableChecks) {
            Log.log.log(Level.WARNING, "Dev Only: ParentLegal Disabled ", (Throwable)pe);
            return true;
        }
        throw pe;
    }

    public static boolean is(BComplex child, BComplex proposedParent, Type expected) {
        return ParentLegal.is(child.getType(), proposedParent.getType(), expected, null);
    }
}

