/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.addons.bacnet;

import com.tridiumemea.addons.bacnet.util.Log;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Context;

abstract class RevisionUtil {
    RevisionUtil() {
    }

    static void replaceSourceName(BAlarmRecord record, BControlPoint point) {
        String unescapedName = SlotPath.unescape((String)point.getName());
        String displayName = point.getDisplayName(Context.NULL);
        String updatedSourceName = null;
        if (displayName != null && !unescapedName.equals(displayName)) {
            if (Log.log.isLoggable(Level.FINE)) {
                Log.log.fine("Found a point to replace source name " + unescapedName + " > " + displayName);
            }
            updatedSourceName = displayName;
        } else if (!point.getName().equals(unescapedName)) {
            updatedSourceName = unescapedName;
        }
        if (updatedSourceName != null) {
            RevisionUtil.applyAlarmDataFacet(record, BFacets.make((String)"sourceName", (String)updatedSourceName));
        }
    }

    static void setHyperlink(BAlarmRecord record, BControlPoint point) {
        BOrd hyperlinkOrd = null;
        BOrd customerSuppliedHyperlink = (BOrd)point.get("hyperlinkOrd");
        if (customerSuppliedHyperlink == null) {
            hyperlinkOrd = point.getSlotPathOrd();
        } else if (customerSuppliedHyperlink.equals((Object)BOrd.DEFAULT) || customerSuppliedHyperlink.equals((Object)BOrd.NULL)) {
            if (Log.log.isLoggable(Level.FINEST)) {
                Log.log.finest("Not setting any hyperlink given empty hyperlinkOrd slot for " + point.getName());
            }
        } else {
            hyperlinkOrd = customerSuppliedHyperlink;
        }
        if (hyperlinkOrd != null) {
            if (Log.log.isLoggable(Level.FINE)) {
                Log.log.fine("Setting hyperlink for point " + point.getName());
            }
            BFacets hyper = BFacets.make((String)"hyperlinkOrd", (BIDataValue)BString.make((String)hyperlinkOrd.toString()));
            RevisionUtil.applyAlarmDataFacet(record, hyper);
        }
    }

    private static void applyAlarmDataFacet(BAlarmRecord record, BFacets applyThese) {
        BFacets orig = record.getAlarmData();
        record.setAlarmData(BFacets.make((BFacets)orig, (BFacets)applyThese));
    }
}

