/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.iotdep;

import com.tridium.cloud.client.iotdep.BIotHubMessageClient;
import com.tridium.cloud.client.iothub.BAbstractIotHubConnectorImpl;
import com.tridium.cloud.client.iothub.BMessageClient;
import com.tridium.cloud.client.iothub.BNullMessageClient;
import com.tridium.cloud.client.sentience.BSentienceConnectorImpl;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="switchToIotHubMessageClient"), @NiagaraAction(name="switchToNullMessageClient", flags=4)})
public class BMessageClientUpgrader
extends BComponent {
    public static final Action switchToIotHubMessageClient = BMessageClientUpgrader.newAction((int)0, null);
    public static final Action switchToNullMessageClient = BMessageClientUpgrader.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BMessageClientUpgrader.class);
    private static final Lexicon lex = Lexicon.make((String)"cloudIotHubDep");

    public void switchToIotHubMessageClient() {
        this.invoke(switchToIotHubMessageClient, null, null);
    }

    public void switchToNullMessageClient() {
        this.invoke(switchToNullMessageClient, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAbstractIotHubConnectorImpl;
    }

    public void doSwitchToIotHubMessageClient() {
        BAbstractIotHubConnectorImpl impl = (BAbstractIotHubConnectorImpl)this.getParent().as(BAbstractIotHubConnectorImpl.class);
        Logger.getLogger("cloud.iotmsg").info(lex.getText("upgradeToIoT", new Object[]{impl.getName()}));
        impl.setMessageClient((BMessageClient)new BIotHubMessageClient());
        if (impl instanceof BSentienceConnectorImpl) {
            ((BSentienceConnectorImpl)impl).setCloudCertVerification(true);
        }
        impl.getCloudConnector().reconnect();
    }

    public void doSwitchToNullMessageClient() {
        BAbstractIotHubConnectorImpl impl = (BAbstractIotHubConnectorImpl)this.getParent().as(BAbstractIotHubConnectorImpl.class);
        Logger.getLogger("cloud.iotmsg").info(lex.getText("downgradeToNull", new Object[]{impl.getName()}));
        impl.setMessageClient((BMessageClient)new BNullMessageClient());
        if (impl instanceof BSentienceConnectorImpl) {
            ((BSentienceConnectorImpl)impl).setCloudCertVerification(false);
        }
        impl.getCloudConnector().reconnect();
    }
}

