/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.proton.transport.ws.impl;

import com.microsoft.azure.proton.transport.ws.WebSocket;
import com.microsoft.azure.proton.transport.ws.WebSocketHandler;
import com.microsoft.azure.proton.transport.ws.impl.WebSocketHandlerImpl;
import com.microsoft.azure.proton.transport.ws.impl.WebSocketSniffer;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.ByteBufferUtils;
import org.apache.qpid.proton.engine.impl.PlainTransportWrapper;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.engine.impl.TransportLayer;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.TransportWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketImpl
implements WebSocket,
TransportLayer {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(WebSocketImpl.class);
    private static final int MAX_FRAME_SIZE = 4224;
    private boolean tailClosed = false;
    private final ByteBuffer inputBuffer;
    private boolean headClosed = false;
    private final ByteBuffer outputBuffer;
    private ByteBuffer pingBuffer;
    private ByteBuffer wsInputBuffer;
    private ByteBuffer tempBuffer;
    private int underlyingOutputSize = 0;
    private int webSocketHeaderSize = 0;
    private WebSocketHandler webSocketHandler;
    private WebSocket.WebSocketState webSocketState = WebSocket.WebSocketState.PN_WS_NOT_STARTED;
    private String host = "";
    private String path = "";
    private String query = "";
    private int port = 0;
    private String protocol = "";
    private Map<String, String> additionalHeaders = null;
    protected Boolean isWebSocketEnabled;
    private WebSocketHandler.WebSocketMessageType lastType;
    private long lastLength;
    private long bytesRead = 0L;
    private WebSocket.WebSocketFrameReadState frameReadState = WebSocket.WebSocketFrameReadState.INIT_READ;

    public WebSocketImpl() {
        this(4224);
    }

    public WebSocketImpl(int customMaxFrameSize) {
        this.inputBuffer = ByteBufferUtils.newWriteableBuffer(customMaxFrameSize);
        this.outputBuffer = ByteBufferUtils.newWriteableBuffer(customMaxFrameSize);
        this.pingBuffer = ByteBufferUtils.newWriteableBuffer(customMaxFrameSize);
        this.wsInputBuffer = ByteBufferUtils.newWriteableBuffer(customMaxFrameSize);
        this.tempBuffer = ByteBufferUtils.newWriteableBuffer(customMaxFrameSize);
        this.lastType = WebSocketHandler.WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_UNKNOWN;
        this.lastLength = 0L;
        this.isWebSocketEnabled = false;
    }

    @Override
    public TransportWrapper wrap(TransportInput input, TransportOutput output) {
        return new WebSocketSnifferTransportWrapper(input, output);
    }

    @Override
    public void configure(String host, String path, String query, int port, String protocol, Map<String, String> additionalHeaders, WebSocketHandler webSocketHandler) {
        this.host = host;
        this.path = path;
        this.query = query;
        this.port = port;
        this.protocol = protocol;
        this.additionalHeaders = additionalHeaders;
        this.webSocketHandler = webSocketHandler != null ? webSocketHandler : new WebSocketHandlerImpl();
        this.isWebSocketEnabled = true;
    }

    @Override
    public void wrapBuffer(ByteBuffer srcBuffer, ByteBuffer dstBuffer) {
        if (this.isWebSocketEnabled.booleanValue()) {
            this.webSocketHandler.wrapBuffer(srcBuffer, dstBuffer);
        } else {
            dstBuffer.clear();
            dstBuffer.put(srcBuffer);
        }
    }

    @Override
    public WebSocketHandler.WebsocketTuple unwrapBuffer(ByteBuffer buffer) {
        if (this.isWebSocketEnabled.booleanValue()) {
            return this.webSocketHandler.unwrapBuffer(buffer);
        }
        return new WebSocketHandler.WebsocketTuple(0L, WebSocketHandler.WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_UNKNOWN);
    }

    @Override
    public WebSocket.WebSocketState getState() {
        return this.webSocketState;
    }

    @Override
    public ByteBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    @Override
    public ByteBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    public ByteBuffer getPingBuffer() {
        return this.pingBuffer;
    }

    @Override
    public ByteBuffer getWsInputBuffer() {
        return this.wsInputBuffer;
    }

    @Override
    public Boolean getEnabled() {
        return this.isWebSocketEnabled;
    }

    @Override
    public WebSocketHandler getWebSocketHandler() {
        return this.webSocketHandler;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebSocketImpl [isWebSocketEnabled=").append(this.isWebSocketEnabled).append(", state=").append((Object)this.webSocketState).append(", protocol=").append(this.protocol).append(", host=").append(this.host).append(", path=").append(this.path).append(", query=").append(this.query).append(", port=").append(this.port);
        if (this.additionalHeaders != null && !this.additionalHeaders.isEmpty()) {
            builder.append(", additionalHeaders=");
            for (Map.Entry<String, String> entry : this.additionalHeaders.entrySet()) {
                builder.append(entry.getKey() + ":" + entry.getValue()).append(", ");
            }
            int lastIndex = builder.lastIndexOf(", ");
            builder.delete(lastIndex, lastIndex + 2);
        }
        builder.append("]");
        return builder.toString();
    }

    protected void writeUpgradeRequest() {
        this.outputBuffer.clear();
        String request = this.webSocketHandler.createUpgradeRequest(this.host, this.path, this.query, this.port, this.protocol, this.additionalHeaders);
        this.outputBuffer.put(request.getBytes());
    }

    protected void writePong() {
        this.webSocketHandler.createPong(this.pingBuffer, this.outputBuffer);
    }

    protected void writeClose() {
        this.outputBuffer.clear();
        this.pingBuffer.flip();
        this.outputBuffer.put(this.pingBuffer);
    }

    private final class WebSocketSnifferTransportWrapper
    extends WebSocketSniffer {
        private WebSocketSnifferTransportWrapper(TransportInput input, TransportOutput output) {
            super(new WebSocketTransportWrapper(input, output), new PlainTransportWrapper(output, input));
        }

        @Override
        protected boolean isDeterminationMade() {
            this._selectedTransportWrapper = this._wrapper1;
            return true;
        }
    }

    private final class WebSocketTransportWrapper
    implements TransportWrapper {
        private final TransportInput underlyingInput;
        private final TransportOutput underlyingOutput;
        private final ByteBuffer head;

        private WebSocketTransportWrapper(TransportInput input, TransportOutput output) {
            this.underlyingInput = input;
            this.underlyingOutput = output;
            this.head = WebSocketImpl.this.outputBuffer.asReadOnlyBuffer();
            this.head.limit(0);
        }

        private void readInputBuffer() {
            ByteBufferUtils.pour(WebSocketImpl.this.inputBuffer, WebSocketImpl.this.tempBuffer);
        }

        private boolean sendToUnderlyingInput() {
            boolean readComplete = false;
            switch (WebSocketImpl.this.lastType) {
                case WEB_SOCKET_MESSAGE_TYPE_UNKNOWN: 
                case WEB_SOCKET_MESSAGE_TYPE_CHUNK: {
                    WebSocketImpl.this.wsInputBuffer.position(WebSocketImpl.this.wsInputBuffer.limit());
                    WebSocketImpl.this.wsInputBuffer.limit(WebSocketImpl.this.wsInputBuffer.capacity());
                    break;
                }
                case WEB_SOCKET_MESSAGE_TYPE_AMQP: {
                    WebSocketImpl.this.wsInputBuffer.flip();
                    int bytes2 = ByteBufferUtils.pourAll(WebSocketImpl.this.wsInputBuffer, this.underlyingInput);
                    if (bytes2 == -1) {
                        WebSocketImpl.this.tailClosed = true;
                    }
                    WebSocketImpl.this.wsInputBuffer.compact();
                    WebSocketImpl.this.wsInputBuffer.flip();
                    readComplete = true;
                    break;
                }
                case WEB_SOCKET_MESSAGE_TYPE_CLOSE: {
                    WebSocketImpl.this.wsInputBuffer.flip();
                    WebSocketImpl.this.pingBuffer.put(WebSocketImpl.this.wsInputBuffer);
                    WebSocketImpl.this.webSocketState = WebSocket.WebSocketState.PN_WS_CONNECTED_CLOSING;
                    WebSocketImpl.this.wsInputBuffer.compact();
                    WebSocketImpl.this.wsInputBuffer.flip();
                    readComplete = true;
                    break;
                }
                case WEB_SOCKET_MESSAGE_TYPE_PING: {
                    WebSocketImpl.this.wsInputBuffer.flip();
                    WebSocketImpl.this.pingBuffer.put(WebSocketImpl.this.wsInputBuffer);
                    WebSocketImpl.this.webSocketState = WebSocket.WebSocketState.PN_WS_CONNECTED_PONG;
                    WebSocketImpl.this.wsInputBuffer.compact();
                    WebSocketImpl.this.wsInputBuffer.flip();
                    readComplete = true;
                    break;
                }
                default: {
                    assert (false) : String.format("unexpected value for WebSocketFrameReadState: %s", new Object[]{WebSocketImpl.access$400(WebSocketImpl.this)});
                    break;
                }
            }
            WebSocketImpl.this.wsInputBuffer.position(WebSocketImpl.this.wsInputBuffer.limit());
            WebSocketImpl.this.wsInputBuffer.limit(WebSocketImpl.this.wsInputBuffer.capacity());
            return readComplete;
        }

        private void processInput() throws TransportException {
            switch (WebSocketImpl.this.webSocketState) {
                case PN_WS_CONNECTING: {
                    WebSocketImpl.this.inputBuffer.mark();
                    if (WebSocketImpl.this.webSocketHandler.validateUpgradeReply(WebSocketImpl.this.inputBuffer).booleanValue()) {
                        WebSocketImpl.this.webSocketState = WebSocket.WebSocketState.PN_WS_CONNECTED_FLOW;
                    } else {
                        WebSocketImpl.this.inputBuffer.reset();
                        TRACE_LOGGER.warn("Websocket connecting response incomplete");
                    }
                    WebSocketImpl.this.inputBuffer.compact();
                    break;
                }
                case PN_WS_CONNECTED_FLOW: 
                case PN_WS_CONNECTED_PONG: {
                    if (WebSocketImpl.this.inputBuffer.remaining() > 0) {
                        boolean readComplete = false;
                        block11: while (!readComplete) {
                            switch (WebSocketImpl.this.frameReadState) {
                                case INIT_READ: {
                                    WebSocketImpl.this.bytesRead = 0L;
                                    this.readInputBuffer();
                                    WebSocketImpl.this.frameReadState = WebSocketImpl.this.tempBuffer.position() < 2 ? WebSocket.WebSocketFrameReadState.CHUNK_READ : WebSocket.WebSocketFrameReadState.HEADER_READ;
                                    readComplete = WebSocketImpl.this.frameReadState == WebSocket.WebSocketFrameReadState.CHUNK_READ;
                                    continue block11;
                                }
                                case CHUNK_READ: {
                                    this.readInputBuffer();
                                    WebSocketImpl.this.frameReadState = WebSocketImpl.this.tempBuffer.position() < 2 ? WebSocketImpl.this.frameReadState : WebSocket.WebSocketFrameReadState.HEADER_READ;
                                    readComplete = WebSocketImpl.this.frameReadState == WebSocket.WebSocketFrameReadState.CHUNK_READ;
                                    continue block11;
                                }
                                case HEADER_READ: {
                                    this.readInputBuffer();
                                    WebSocketImpl.this.tempBuffer.flip();
                                    WebSocketHandler.WebsocketTuple unwrapResult = WebSocketImpl.this.unwrapBuffer(WebSocketImpl.this.tempBuffer);
                                    WebSocketImpl.this.lastType = unwrapResult.getType();
                                    WebSocketImpl.this.lastLength = unwrapResult.getLength();
                                    WebSocketImpl.this.frameReadState = WebSocketImpl.this.lastType == WebSocketHandler.WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_HEADER_CHUNK ? WebSocket.WebSocketFrameReadState.CHUNK_READ : WebSocket.WebSocketFrameReadState.CONTINUED_FRAME_READ;
                                    boolean bl = readComplete = WebSocketImpl.this.frameReadState == WebSocket.WebSocketFrameReadState.CHUNK_READ || WebSocketImpl.this.tempBuffer.position() == WebSocketImpl.this.tempBuffer.limit();
                                    if (WebSocketImpl.this.frameReadState == WebSocket.WebSocketFrameReadState.CONTINUED_FRAME_READ) {
                                        WebSocketImpl.this.tempBuffer.compact();
                                        continue block11;
                                    }
                                    WebSocketImpl.this.tempBuffer.position(WebSocketImpl.this.tempBuffer.limit());
                                    WebSocketImpl.this.tempBuffer.limit(WebSocketImpl.this.tempBuffer.capacity());
                                    continue block11;
                                }
                                case CONTINUED_FRAME_READ: {
                                    byte[] data;
                                    this.readInputBuffer();
                                    WebSocketImpl.this.tempBuffer.flip();
                                    if ((long)WebSocketImpl.this.tempBuffer.remaining() >= WebSocketImpl.this.lastLength - WebSocketImpl.this.bytesRead) {
                                        data = new byte[(int)(WebSocketImpl.this.lastLength - WebSocketImpl.this.bytesRead)];
                                        WebSocketImpl.this.tempBuffer.get(data, 0, (int)(WebSocketImpl.this.lastLength - WebSocketImpl.this.bytesRead));
                                        WebSocketImpl.this.wsInputBuffer.put(data);
                                        WebSocketImpl.this.bytesRead = WebSocketImpl.this.bytesRead + (WebSocketImpl.this.lastLength - WebSocketImpl.this.bytesRead);
                                    } else {
                                        data = new byte[WebSocketImpl.this.tempBuffer.remaining()];
                                        WebSocketImpl.this.tempBuffer.get(data);
                                        WebSocketImpl.this.wsInputBuffer.put(data);
                                        WebSocketImpl.this.bytesRead = WebSocketImpl.this.bytesRead + (long)data.length;
                                    }
                                    this.sendToUnderlyingInput();
                                    WebSocketImpl.this.frameReadState = WebSocketImpl.this.bytesRead == WebSocketImpl.this.lastLength ? WebSocket.WebSocketFrameReadState.INIT_READ : WebSocket.WebSocketFrameReadState.CONTINUED_FRAME_READ;
                                    readComplete = WebSocketImpl.this.tempBuffer.remaining() == 0;
                                    WebSocketImpl.this.tempBuffer.compact();
                                    continue block11;
                                }
                                case READ_ERROR: {
                                    continue block11;
                                }
                            }
                            assert (false) : String.format("unexpected value for WebSocketFrameReadState: %s", new Object[]{WebSocketImpl.access$1100(WebSocketImpl.this)});
                        }
                    }
                    WebSocketImpl.this.inputBuffer.compact();
                    break;
                }
            }
        }

        @Override
        public int capacity() {
            if (WebSocketImpl.this.isWebSocketEnabled.booleanValue()) {
                if (WebSocketImpl.this.tailClosed) {
                    return -1;
                }
                return WebSocketImpl.this.inputBuffer.remaining();
            }
            return this.underlyingInput.capacity();
        }

        @Override
        public int position() {
            if (WebSocketImpl.this.isWebSocketEnabled.booleanValue()) {
                if (WebSocketImpl.this.tailClosed) {
                    return -1;
                }
                return WebSocketImpl.this.inputBuffer.position();
            }
            return this.underlyingInput.position();
        }

        @Override
        public ByteBuffer tail() {
            if (WebSocketImpl.this.isWebSocketEnabled.booleanValue()) {
                return WebSocketImpl.this.inputBuffer;
            }
            return this.underlyingInput.tail();
        }

        @Override
        public void process() throws TransportException {
            if (WebSocketImpl.this.isWebSocketEnabled.booleanValue()) {
                WebSocketImpl.this.inputBuffer.flip();
                switch (WebSocketImpl.this.webSocketState) {
                    case PN_WS_CONNECTING: 
                    case PN_WS_CONNECTED_FLOW: {
                        this.processInput();
                        break;
                    }
                    default: {
                        this.underlyingInput.process();
                        break;
                    }
                }
            } else {
                this.underlyingInput.process();
            }
        }

        @Override
        public void close_tail() {
            WebSocketImpl.this.tailClosed = true;
            if (WebSocketImpl.this.isWebSocketEnabled.booleanValue()) {
                WebSocketImpl.this.headClosed = true;
                this.underlyingInput.close_tail();
            } else {
                this.underlyingInput.close_tail();
            }
        }

        @Override
        public int pending() {
            if (WebSocketImpl.this.isWebSocketEnabled.booleanValue()) {
                switch (WebSocketImpl.this.webSocketState) {
                    case PN_WS_NOT_STARTED: {
                        if (WebSocketImpl.this.outputBuffer.position() == 0) {
                            WebSocketImpl.this.webSocketState = WebSocket.WebSocketState.PN_WS_CONNECTING;
                            WebSocketImpl.this.writeUpgradeRequest();
                            this.head.limit(WebSocketImpl.this.outputBuffer.position());
                            if (WebSocketImpl.this.headClosed) {
                                WebSocketImpl.this.webSocketState = WebSocket.WebSocketState.PN_WS_FAILED;
                                return -1;
                            }
                            return WebSocketImpl.this.outputBuffer.position();
                        }
                        return WebSocketImpl.this.outputBuffer.position();
                    }
                    case PN_WS_CONNECTING: {
                        if (WebSocketImpl.this.headClosed && WebSocketImpl.this.outputBuffer.position() == 0) {
                            WebSocketImpl.this.webSocketState = WebSocket.WebSocketState.PN_WS_FAILED;
                            return -1;
                        }
                        return WebSocketImpl.this.outputBuffer.position();
                    }
                    case PN_WS_CONNECTED_FLOW: {
                        WebSocketImpl.this.underlyingOutputSize = this.underlyingOutput.pending();
                        if (WebSocketImpl.this.underlyingOutputSize > 0) {
                            WebSocketImpl.this.webSocketHeaderSize = WebSocketImpl.this.webSocketHandler.calculateHeaderSize(WebSocketImpl.this.underlyingOutputSize);
                            return WebSocketImpl.this.underlyingOutputSize + WebSocketImpl.this.webSocketHeaderSize;
                        }
                        return WebSocketImpl.this.underlyingOutputSize;
                    }
                    case PN_WS_CONNECTED_PONG: {
                        WebSocketImpl.this.webSocketState = WebSocket.WebSocketState.PN_WS_CONNECTED_FLOW;
                        WebSocketImpl.this.writePong();
                        this.head.limit(WebSocketImpl.this.outputBuffer.position());
                        if (WebSocketImpl.this.headClosed) {
                            WebSocketImpl.this.webSocketState = WebSocket.WebSocketState.PN_WS_FAILED;
                            return -1;
                        }
                        return WebSocketImpl.this.outputBuffer.position();
                    }
                    case PN_WS_CONNECTED_CLOSING: {
                        WebSocketImpl.this.webSocketState = WebSocket.WebSocketState.PN_WS_CLOSED;
                        WebSocketImpl.this.writeClose();
                        this.head.limit(WebSocketImpl.this.outputBuffer.position());
                        if (WebSocketImpl.this.headClosed) {
                            WebSocketImpl.this.webSocketState = WebSocket.WebSocketState.PN_WS_FAILED;
                            return -1;
                        }
                        return WebSocketImpl.this.outputBuffer.position();
                    }
                }
                return -1;
            }
            return this.underlyingOutput.pending();
        }

        @Override
        public ByteBuffer head() {
            if (WebSocketImpl.this.isWebSocketEnabled.booleanValue()) {
                switch (WebSocketImpl.this.webSocketState) {
                    case PN_WS_CONNECTING: 
                    case PN_WS_CONNECTED_PONG: 
                    case PN_WS_CONNECTED_CLOSING: {
                        return this.head;
                    }
                    case PN_WS_CONNECTED_FLOW: {
                        WebSocketImpl.this.underlyingOutputSize = this.underlyingOutput.pending();
                        if (WebSocketImpl.this.underlyingOutputSize > 0) {
                            WebSocketImpl.this.wrapBuffer(this.underlyingOutput.head(), WebSocketImpl.this.outputBuffer);
                            WebSocketImpl.this.webSocketHeaderSize = WebSocketImpl.this.outputBuffer.position() - WebSocketImpl.this.underlyingOutputSize;
                            this.head.limit(WebSocketImpl.this.outputBuffer.position());
                        }
                        return this.head;
                    }
                }
                return this.underlyingOutput.head();
            }
            return this.underlyingOutput.head();
        }

        @Override
        public void pop(int bytes) {
            block13: {
                block12: {
                    if (!WebSocketImpl.this.isWebSocketEnabled.booleanValue()) break block12;
                    switch (WebSocketImpl.this.webSocketState) {
                        case PN_WS_CONNECTING: {
                            if (WebSocketImpl.this.outputBuffer.position() != 0) {
                                WebSocketImpl.this.outputBuffer.flip();
                                WebSocketImpl.this.outputBuffer.position(bytes);
                                WebSocketImpl.this.outputBuffer.compact();
                                this.head.position(0);
                                this.head.limit(WebSocketImpl.this.outputBuffer.position());
                            } else {
                                this.underlyingOutput.pop(bytes);
                            }
                            break block13;
                        }
                        case PN_WS_CONNECTED_FLOW: 
                        case PN_WS_CONNECTED_PONG: 
                        case PN_WS_CONNECTED_CLOSING: {
                            if (bytes >= WebSocketImpl.this.webSocketHeaderSize && WebSocketImpl.this.outputBuffer.position() != 0) {
                                WebSocketImpl.this.outputBuffer.flip();
                                WebSocketImpl.this.outputBuffer.position(bytes);
                                WebSocketImpl.this.outputBuffer.compact();
                                this.head.position(0);
                                this.head.limit(WebSocketImpl.this.outputBuffer.position());
                                this.underlyingOutput.pop(bytes - WebSocketImpl.this.webSocketHeaderSize);
                                WebSocketImpl.this.webSocketHeaderSize = 0;
                            } else if (bytes > 0 && bytes < WebSocketImpl.this.webSocketHeaderSize) {
                                WebSocketImpl.this.webSocketHeaderSize = WebSocketImpl.this.webSocketHeaderSize - bytes;
                            } else {
                                this.underlyingOutput.pop(bytes);
                            }
                            break block13;
                        }
                        case PN_WS_NOT_STARTED: 
                        case PN_WS_CLOSED: 
                        case PN_WS_FAILED: {
                            this.underlyingOutput.pop(bytes);
                            break block13;
                        }
                        default: {
                            assert (false) : String.format("unexpected value for WebSocketFrameReadState: %s", new Object[]{WebSocketImpl.access$800(WebSocketImpl.this)});
                            break block13;
                        }
                    }
                }
                this.underlyingOutput.pop(bytes);
            }
        }

        @Override
        public void close_head() {
            this.underlyingOutput.close_head();
        }
    }
}

