/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.proton.transport.proxy.impl;

import com.microsoft.azure.proton.transport.proxy.Proxy;
import com.microsoft.azure.proton.transport.proxy.ProxyAuthenticationType;
import com.microsoft.azure.proton.transport.proxy.ProxyChallengeProcessor;
import com.microsoft.azure.proton.transport.proxy.ProxyConfiguration;
import com.microsoft.azure.proton.transport.proxy.ProxyHandler;
import com.microsoft.azure.proton.transport.proxy.impl.BasicProxyChallengeProcessorImpl;
import com.microsoft.azure.proton.transport.proxy.impl.Constants;
import com.microsoft.azure.proton.transport.proxy.impl.DigestProxyChallengeProcessorImpl;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyAuthenticator;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.ByteBufferUtils;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.engine.impl.TransportLayer;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.TransportWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyImpl
implements Proxy,
TransportLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyImpl.class);
    private static final String PROXY_CONNECT_FAILED = "Proxy connect request failed with error: ";
    private static final String PROXY_CONNECT_USER_ERROR = "User configuration error. Using non-matching proxy authentication.";
    private static final int PROXY_HANDSHAKE_BUFFER_SIZE = 8192;
    private final ByteBuffer inputBuffer;
    private final ByteBuffer outputBuffer;
    private final ProxyConfiguration proxyConfiguration;
    private boolean tailClosed = false;
    private boolean headClosed = false;
    private boolean isProxyConfigured = false;
    private String host = "";
    private Map<String, String> headers = null;
    private TransportImpl underlyingTransport;
    private Proxy.ProxyState proxyState = Proxy.ProxyState.PN_PROXY_NOT_STARTED;
    private ProxyHandler proxyHandler;

    public ProxyImpl() {
        this(null);
    }

    public ProxyImpl(ProxyConfiguration configuration) {
        this.inputBuffer = ByteBufferUtils.newWriteableBuffer(8192);
        this.outputBuffer = ByteBufferUtils.newWriteableBuffer(8192);
        this.proxyConfiguration = configuration;
    }

    @Override
    public TransportWrapper wrap(TransportInput input, TransportOutput output) {
        return new ProxyTransportWrapper(input, output);
    }

    @Override
    public void configure(String host, Map<String, String> headers, ProxyHandler proxyHandler, Transport underlyingTransport) {
        this.host = host;
        this.headers = headers;
        this.proxyHandler = proxyHandler;
        this.underlyingTransport = (TransportImpl)underlyingTransport;
        this.isProxyConfigured = true;
    }

    public Map<String, String> getProxyRequestHeaders() {
        return this.headers;
    }

    protected ByteBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    protected ByteBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    protected Boolean getIsProxyConfigured() {
        return this.isProxyConfigured;
    }

    protected ProxyHandler getProxyHandler() {
        return this.proxyHandler;
    }

    protected Transport getUnderlyingTransport() {
        return this.underlyingTransport;
    }

    protected void writeProxyRequest() {
        this.outputBuffer.clear();
        String request = this.proxyHandler.createProxyRequest(this.host, this.headers);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Writing proxy request:{}{}", (Object)System.lineSeparator(), (Object)request);
        }
        this.outputBuffer.put(request.getBytes());
    }

    protected boolean getIsHandshakeInProgress() {
        return this.isProxyConfigured && this.proxyState != Proxy.ProxyState.PN_PROXY_CONNECTED;
    }

    protected Proxy.ProxyState getProxyState() {
        return this.proxyState;
    }

    private class ProxyTransportWrapper
    implements TransportWrapper {
        private final TransportInput underlyingInput;
        private final TransportOutput underlyingOutput;
        private final ByteBuffer head;

        ProxyTransportWrapper(TransportInput input, TransportOutput output) {
            this.underlyingInput = input;
            this.underlyingOutput = output;
            this.head = ProxyImpl.this.outputBuffer.asReadOnlyBuffer();
        }

        @Override
        public int capacity() {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                if (ProxyImpl.this.tailClosed) {
                    return -1;
                }
                return ProxyImpl.this.inputBuffer.remaining();
            }
            return this.underlyingInput.capacity();
        }

        @Override
        public int position() {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                if (ProxyImpl.this.tailClosed) {
                    return -1;
                }
                return ProxyImpl.this.inputBuffer.position();
            }
            return this.underlyingInput.position();
        }

        @Override
        public ByteBuffer tail() throws TransportException {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                return ProxyImpl.this.inputBuffer;
            }
            return this.underlyingInput.tail();
        }

        @Override
        public void process() throws TransportException {
            if (!ProxyImpl.this.getIsHandshakeInProgress()) {
                this.underlyingInput.process();
                return;
            }
            switch (ProxyImpl.this.proxyState) {
                case PN_PROXY_CONNECTING: {
                    ProxyChallengeProcessor processor;
                    ProxyImpl.this.inputBuffer.flip();
                    ProxyHandler.ProxyResponseResult responseResult = ProxyImpl.this.proxyHandler.validateProxyResponse(ProxyImpl.this.inputBuffer);
                    ProxyImpl.this.inputBuffer.compact();
                    ProxyImpl.this.inputBuffer.clear();
                    if (responseResult.getIsSuccess().booleanValue()) {
                        if (ProxyImpl.this.proxyConfiguration == null || ProxyImpl.this.proxyConfiguration.authentication() == ProxyAuthenticationType.NONE) {
                            ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_CONNECTED;
                            break;
                        }
                        if (LOGGER.isErrorEnabled()) {
                            LOGGER.error("ProxyConfiguration mismatch. User configured: '{}', but authentication is not required", (Object)ProxyImpl.this.proxyConfiguration.authentication());
                        }
                        this.closeTailProxyError(ProxyImpl.PROXY_CONNECT_USER_ERROR);
                        break;
                    }
                    String challenge = responseResult.getError();
                    Set<ProxyAuthenticationType> supportedTypes = this.getAuthenticationTypes(challenge);
                    if (ProxyImpl.this.proxyConfiguration != null && !supportedTypes.contains((Object)ProxyImpl.this.proxyConfiguration.authentication())) {
                        if (LOGGER.isErrorEnabled()) {
                            LOGGER.error("Proxy authentication required. User configured: '{}', but supported proxy authentication methods are: {}", (Object)ProxyImpl.this.proxyConfiguration.authentication(), (Object)supportedTypes.stream().map(type -> type.toString()).collect(Collectors.joining(",")));
                        }
                        this.closeTailProxyError("User configuration error. Using non-matching proxy authentication.Proxy connect request failed with error: " + challenge);
                        break;
                    }
                    ProxyChallengeProcessor proxyChallengeProcessor = processor = ProxyImpl.this.proxyConfiguration != null ? this.getChallengeProcessor(ProxyImpl.this.host, challenge, ProxyImpl.this.proxyConfiguration.authentication()) : this.getChallengeProcessor(ProxyImpl.this.host, challenge, supportedTypes);
                    if (processor != null) {
                        ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_CHALLENGE;
                        ProxyImpl.this.headers = processor.getHeader();
                        break;
                    }
                    this.closeTailProxyError(ProxyImpl.PROXY_CONNECT_FAILED + challenge);
                    break;
                }
                case PN_PROXY_CHALLENGE_RESPONDED: {
                    ProxyImpl.this.inputBuffer.flip();
                    ProxyHandler.ProxyResponseResult result = ProxyImpl.this.proxyHandler.validateProxyResponse(ProxyImpl.this.inputBuffer);
                    ProxyImpl.this.inputBuffer.compact();
                    if (result.getIsSuccess().booleanValue()) {
                        ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_CONNECTED;
                        break;
                    }
                    this.closeTailProxyError(ProxyImpl.PROXY_CONNECT_FAILED + result.getError());
                    break;
                }
                default: {
                    this.underlyingInput.process();
                }
            }
        }

        @Override
        public void close_tail() {
            ProxyImpl.this.tailClosed = true;
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                ProxyImpl.this.headClosed = true;
            }
            this.underlyingInput.close_tail();
        }

        @Override
        public int pending() {
            if (!ProxyImpl.this.getIsHandshakeInProgress()) {
                return this.underlyingOutput.pending();
            }
            switch (ProxyImpl.this.proxyState) {
                case PN_PROXY_NOT_STARTED: {
                    if (ProxyImpl.this.outputBuffer.position() == 0) {
                        ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_CONNECTING;
                        ProxyImpl.this.writeProxyRequest();
                        this.head.limit(ProxyImpl.this.outputBuffer.position());
                        if (ProxyImpl.this.headClosed) {
                            ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_FAILED;
                            return -1;
                        }
                        return ProxyImpl.this.outputBuffer.position();
                    }
                    return ProxyImpl.this.outputBuffer.position();
                }
                case PN_PROXY_CHALLENGE: {
                    if (ProxyImpl.this.outputBuffer.position() == 0) {
                        ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_CHALLENGE_RESPONDED;
                        ProxyImpl.this.writeProxyRequest();
                        this.head.limit(ProxyImpl.this.outputBuffer.position());
                        if (ProxyImpl.this.headClosed) {
                            ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_FAILED;
                            return -1;
                        }
                        return ProxyImpl.this.outputBuffer.position();
                    }
                    return ProxyImpl.this.outputBuffer.position();
                }
                case PN_PROXY_CONNECTING: 
                case PN_PROXY_CHALLENGE_RESPONDED: {
                    if (ProxyImpl.this.headClosed && ProxyImpl.this.outputBuffer.position() == 0) {
                        ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_FAILED;
                        return -1;
                    }
                    return ProxyImpl.this.outputBuffer.position();
                }
            }
            return -1;
        }

        @Override
        public ByteBuffer head() {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                switch (ProxyImpl.this.proxyState) {
                    case PN_PROXY_CONNECTING: 
                    case PN_PROXY_CHALLENGE_RESPONDED: {
                        return this.head;
                    }
                }
                return this.underlyingOutput.head();
            }
            return this.underlyingOutput.head();
        }

        @Override
        public void pop(int bytes) {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                switch (ProxyImpl.this.proxyState) {
                    case PN_PROXY_CONNECTING: 
                    case PN_PROXY_CHALLENGE_RESPONDED: {
                        if (ProxyImpl.this.outputBuffer.position() != 0) {
                            ProxyImpl.this.outputBuffer.flip();
                            ProxyImpl.this.outputBuffer.position(bytes);
                            ProxyImpl.this.outputBuffer.compact();
                            this.head.position(0);
                            this.head.limit(ProxyImpl.this.outputBuffer.position());
                            break;
                        }
                        this.underlyingOutput.pop(bytes);
                        break;
                    }
                    default: {
                        this.underlyingOutput.pop(bytes);
                        break;
                    }
                }
            } else {
                this.underlyingOutput.pop(bytes);
            }
        }

        @Override
        public void close_head() {
            ProxyImpl.this.headClosed = true;
            this.underlyingOutput.close_head();
        }

        private ProxyChallengeProcessor getChallengeProcessor(String host, String challenge, Set<ProxyAuthenticationType> authentication) {
            if (authentication.contains((Object)ProxyAuthenticationType.DIGEST)) {
                return this.getChallengeProcessor(host, challenge, ProxyAuthenticationType.DIGEST);
            }
            if (authentication.contains((Object)ProxyAuthenticationType.BASIC)) {
                return this.getChallengeProcessor(host, challenge, ProxyAuthenticationType.BASIC);
            }
            return null;
        }

        private ProxyChallengeProcessor getChallengeProcessor(String host, String challenge, ProxyAuthenticationType authentication) {
            ProxyAuthenticator authenticator = ProxyImpl.this.proxyConfiguration != null ? new ProxyAuthenticator(ProxyImpl.this.proxyConfiguration) : new ProxyAuthenticator();
            switch (authentication) {
                case DIGEST: {
                    return new DigestProxyChallengeProcessorImpl(host, challenge, authenticator);
                }
                case BASIC: {
                    return new BasicProxyChallengeProcessorImpl(host, authenticator);
                }
            }
            return null;
        }

        private Set<ProxyAuthenticationType> getAuthenticationTypes(String error) {
            int index = error.indexOf("Proxy-Authenticate:");
            if (index == -1) {
                return Collections.emptySet();
            }
            HashSet<ProxyAuthenticationType> supportedTypes = new HashSet<ProxyAuthenticationType>();
            try (Scanner scanner = new Scanner(error);){
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    if (!line.startsWith("Proxy-Authenticate:")) continue;
                    String substring = line.substring("Proxy-Authenticate:".length()).trim().toLowerCase(Locale.ROOT);
                    if (substring.startsWith(Constants.BASIC_LOWERCASE)) {
                        supportedTypes.add(ProxyAuthenticationType.BASIC);
                        continue;
                    }
                    if (!substring.startsWith(Constants.DIGEST_LOWERCASE)) continue;
                    supportedTypes.add(ProxyAuthenticationType.DIGEST);
                }
            }
            return supportedTypes;
        }

        private void closeTailProxyError(String errorMessage) {
            ProxyImpl.this.tailClosed = true;
            ProxyImpl.this.underlyingTransport.closed(new TransportException(errorMessage));
        }
    }
}

