/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsh;

import com.tridium.nsh.NShell;
import java.util.ArrayList;
import javax.baja.nre.util.TextUtil;

public class Expr {
    public String string;
    public String cmd;
    public String[] args;
    public String[] options;

    public static Expr parse(NShell nsh, String expr) {
        if (nsh.debug) {
            nsh.debug("Expr.parse: \"" + expr + "\"");
        }
        expr = Expr.resolve(nsh, expr);
        String[] tok = TextUtil.split((String)expr, (char)' ');
        ArrayList<String> a = new ArrayList<String>();
        ArrayList<String> o = new ArrayList<String>();
        for (int i = 1; i < tok.length; ++i) {
            String t = tok[i];
            if (t.length() >= 2 && t.charAt(0) == '-') {
                o.add(t.substring(1));
                continue;
            }
            a.add(t);
        }
        Expr result = new Expr();
        result.string = expr;
        result.cmd = TextUtil.toLowerCase((String)tok[0]);
        result.args = a.toArray(new String[a.size()]);
        result.options = o.toArray(new String[o.size()]);
        if (nsh.debug) {
            int i;
            nsh.debug("  cmd    = " + result.cmd);
            for (i = 0; i < result.args.length; ++i) {
                nsh.debug("  arg[" + i + "] = " + result.args[i]);
            }
            for (i = 0; i < result.options.length; ++i) {
                nsh.debug("  opt[" + i + "] = " + result.options[i]);
            }
        }
        return result;
    }

    public static String resolve(NShell nsh, String expr) {
        try {
            int i = 1;
            while (true) {
                String x;
                if ((x = Expr.onePassResolve(nsh, expr)).equals(expr)) {
                    return expr;
                }
                if (nsh.debug) {
                    nsh.debug("    resolve(" + i + ") -> \"" + x + "\"");
                }
                expr = x;
                ++i;
            }
        }
        catch (Exception e) {
            return expr;
        }
    }

    private static String onePassResolve(NShell nsh, String expr) {
        StringBuilder r = new StringBuilder();
        StringBuilder temp = new StringBuilder();
        int len = expr.length();
        for (int i = 0; i < len; ++i) {
            char c = expr.charAt(i);
            if (c != '%') {
                r.append(c);
                continue;
            }
            if ((c = expr.charAt(++i)) == '%') {
                r.append('%');
                continue;
            }
            temp.setLength(0);
            int j = i;
            while ((c = expr.charAt(j++)) != '%') {
                temp.append(c);
            }
            String macroKey = temp.toString();
            String macroVal = nsh.getenv(macroKey);
            if (macroVal == null) {
                macroVal = "";
            }
            r.append(macroVal);
            i = j - 1;
        }
        return r.toString();
    }

    public boolean help() {
        return this.has("?") || this.has("help");
    }

    public boolean has(String option) {
        for (int i = 0; i < this.options.length; ++i) {
            if (!option.equals(this.options[i])) continue;
            return true;
        }
        return false;
    }
}

