/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rtsp;

public class RtpPacket {
    public int version;
    public boolean padding;
    public boolean extension;
    public boolean marker;
    public int csr_count;
    public int payload_type;
    public int seq_num;
    public int ext_seq_num;
    public long time_stamp = 0L;
    public long ssrc_id = 0L;
    public int[] csrc_id;
    public byte[] payload = new byte[1600];
    public int pay_length;
    int rr_count = 0;
    int packet_type = 0;
    int packet_length = 0;
    int sender_ssrc = 0;
    long ntpTimeStamp1 = 0L;
    long ntpTimeStamp2 = 0L;
    long timeStamp = 0L;

    public RtpPacket() {
    }

    public void read(byte[] rtpData, int dataLength) {
        this.version = rtpData[0] & 0xC0;
        this.padding = (rtpData[0] & 0x20) == 32;
        this.extension = (rtpData[0] & 0x10) == 16;
        this.csr_count = rtpData[0] & 0xF;
        this.marker = (rtpData[1] & 0x80) == 128;
        this.payload_type = rtpData[1] & 0x7F;
        this.seq_num = (rtpData[2] & 0xFF) << 8 | rtpData[3] & 0xFF;
        byte t1 = rtpData[4];
        byte t2 = rtpData[5];
        byte t3 = rtpData[6];
        byte t4 = rtpData[7];
        this.time_stamp = ((t1 & 0xFF) << 24 | (t2 & 0xFF) << 16 | (t3 & 0xFF) << 8 | t4 & 0xFF) & 0xFFFFFFFF;
        this.pay_length = dataLength - 12;
        System.arraycopy(rtpData, 12, this.payload, 0, this.pay_length);
    }

    RtpPacket(byte[] data, boolean rtp) {
        this.version = data[0] & 0xC0;
        boolean bl = this.padding = (data[0] & 0x20) == 32;
        if (rtp) {
            this.extension = (data[0] & 0x10) == 16;
            this.csr_count = data[0] & 0xF;
            this.marker = (data[1] & 0x80) == 128;
            this.payload_type = data[1] & 0x7F;
            this.seq_num = (data[2] & 0xFF) << 8 | data[3] & 0xFF;
            byte t1 = data[4];
            byte t2 = data[5];
            byte t3 = data[6];
            byte t4 = data[7];
            this.time_stamp = ((t1 & 0xFF) << 24 | (t2 & 0xFF) << 16 | (t3 & 0xFF) << 8 | t4 & 0xFF) & 0xFFFFFFFF;
            this.pay_length = data.length - 12;
            this.payload = new byte[this.pay_length];
            System.arraycopy(data, 12, this.payload, 0, this.pay_length);
        } else {
            this.rr_count = data[0] & 0x1F;
            this.packet_type = data[1] & 0xFF;
            this.packet_length = (data[2] & 0xFF) << 8 | data[3] & 0xFF;
            this.sender_ssrc = (data[4] & 0xFF) << 24 | (data[5] & 0xFF) << 16 | (data[6] & 0xFF) << 8 | data[7] & 0xFF;
            this.ntpTimeStamp1 = (data[8] & 0xFF) << 24 | (data[9] & 0xFF) << 16 | (data[10] & 0xFF) << 8 | data[11] & 0xFF;
            this.ntpTimeStamp2 = (data[12] & 0xFF) << 24 | (data[13] & 0xFF) << 16 | (data[14] & 0xFF) << 8 | data[15] & 0xFF;
            this.timeStamp = (data[16] & 0xFF) << 24 | (data[17] & 0xFF) << 16 | (data[18] & 0xFF) << 8 | data[19] & 0xFF;
        }
    }

    public void printDebug() {
        System.out.println("-----------------------------------------------------------------------");
        System.out.println("Padding\tMarker\tPT\tTime\t\tLength\tSequence");
        System.out.println(this.padding + "\t" + this.marker + "\t" + this.payload_type + "\t" + this.time_stamp + "\t" + this.pay_length + "\t" + this.seq_num);
    }
}

