/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.edgeIo.point;

import com.tridium.edgeIo.enums.BEdgeIoCalcTypeEnum;
import com.tridium.edgeIo.enums.BEdgeIoModeEnum;
import com.tridium.edgeIo.messages.BEdgeIoMessageTypeEnum;
import com.tridium.edgeIo.messages.EdgeIoMessage;
import com.tridium.edgeIo.messages.InitAnalog;
import com.tridium.edgeIo.messages.PointMessage;
import com.tridium.edgeIo.messages.UpdateCount;
import com.tridium.edgeIo.point.BEdgeIoProxyExt;
import com.tridium.edgeIo.point.BEdgeIoRecalcRateAction;
import com.tridium.edgeIo.point.BEdgeIoResetAction;
import com.tridium.edgeIo.point.BEdgeIoSetCountAction;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="total", type="long", defaultValue="0", flags=1), @NiagaraProperty(name="calcType", type="BEdgeIoCalcTypeEnum", defaultValue="BEdgeIoCalcTypeEnum.DEFAULT"), @NiagaraProperty(name="rate", type="double", defaultValue="0.0", flags=3), @NiagaraProperty(name="rateScale", type="float", defaultValue="1.0f", facets={@Facet(name="BFacets.PRECISION", value="BInteger.make(5)")}), @NiagaraProperty(name="rateInterval", type="BRelTime", defaultValue="BRelTime.makeSeconds(60)", facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="BBoolean.FALSE"), @Facet(name="BFacets.MIN", value="BRelTime.make(1000)")}), @NiagaraProperty(name="rateWindows", type="int", defaultValue="6", facets={@Facet(name="BFacets.MIN", value="BInteger.make(2)")}), @NiagaraProperty(name="rateCalcTime", type="BAbsTime", flags=3, defaultValue="BAbsTime.DEFAULT")})
@NiagaraAction(name="calcRate", flags=4)
public class BEdgeIoPulseInputProxyExt
extends BEdgeIoProxyExt {
    public static final String RECALCULATE_RATE = "recalculateRate";
    public static final String SET_COUNT = "set";
    public static final String RESET = "reset";
    public static final Property total = BEdgeIoPulseInputProxyExt.newProperty((int)1, (int)0, null);
    public static final Property calcType = BEdgeIoPulseInputProxyExt.newProperty((int)0, (BValue)BEdgeIoCalcTypeEnum.DEFAULT, null);
    public static final Property rate = BEdgeIoPulseInputProxyExt.newProperty((int)3, (double)0.0, null);
    public static final Property rateScale = BEdgeIoPulseInputProxyExt.newProperty((int)0, (float)1.0f, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)5)));
    public static final Property rateInterval = BEdgeIoPulseInputProxyExt.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)60), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.FALSE), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1000L))));
    public static final Property rateWindows = BEdgeIoPulseInputProxyExt.newProperty((int)0, (int)6, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)2)));
    public static final Property rateCalcTime = BEdgeIoPulseInputProxyExt.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    public static final Action calcRate = BEdgeIoPulseInputProxyExt.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BEdgeIoPulseInputProxyExt.class);
    private Calc calc = null;

    public long getTotal() {
        return this.getLong(total);
    }

    public void setTotal(long v) {
        this.setLong(total, v, null);
    }

    public BEdgeIoCalcTypeEnum getCalcType() {
        return (BEdgeIoCalcTypeEnum)this.get(calcType);
    }

    public void setCalcType(BEdgeIoCalcTypeEnum v) {
        this.set(calcType, (BValue)v, null);
    }

    public double getRate() {
        return this.getDouble(rate);
    }

    public void setRate(double v) {
        this.setDouble(rate, v, null);
    }

    public float getRateScale() {
        return this.getFloat(rateScale);
    }

    public void setRateScale(float v) {
        this.setFloat(rateScale, v, null);
    }

    public BRelTime getRateInterval() {
        return (BRelTime)this.get(rateInterval);
    }

    public void setRateInterval(BRelTime v) {
        this.set(rateInterval, (BValue)v, null);
    }

    public int getRateWindows() {
        return this.getInt(rateWindows);
    }

    public void setRateWindows(int v) {
        this.setInt(rateWindows, v, null);
    }

    public BAbsTime getRateCalcTime() {
        return (BAbsTime)this.get(rateCalcTime);
    }

    public void setRateCalcTime(BAbsTime v) {
        this.set(rateCalcTime, (BValue)v, null);
    }

    public void calcRate() {
        this.invoke(calcRate, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p == calcType) {
            if (this.calc != null) {
                this.calc.cleanupType();
            }
            this.calc = this.chooseCalc(this.getCalcType());
            if (this.calc != null) {
                this.calc.initType();
            }
        } else if (this.calc != null) {
            this.calc.changed(p);
        }
    }

    @Override
    public boolean isPulseInput() {
        return true;
    }

    @Override
    protected void sendInit() {
        int mode = BEdgeIoModeEnum.make(this.getPointMode().getTag()).getOrdinal();
        InitAnalog init = new InitAnalog(this.getPointId(), mode);
        this.getEdgeIoNetwork().sendMessage(init);
    }

    @Override
    protected void sendStop() {
        PointMessage stop = new PointMessage(BEdgeIoMessageTypeEnum.stopAnalog, this.getPointId());
        this.getEdgeIoNetwork().sendMessage(stop);
    }

    @Override
    public void receiveUpdate(EdgeIoMessage msg) {
        if (msg instanceof UpdateCount) {
            UpdateCount update = (UpdateCount)msg;
            if (this.calc != null) {
                this.calc.updateCount(update.value);
            }
        } else {
            log.severe("The Message received is not UpdateCount message");
        }
    }

    @Override
    protected void initProxy() {
        try {
            if (this.getParentPoint().getAction(SET_COUNT) == null) {
                this.getParentPoint().add(SET_COUNT, (BValue)new BEdgeIoSetCountAction());
            }
            if (this.getParentPoint().getAction(RESET) == null) {
                this.getParentPoint().add(RESET, (BValue)new BEdgeIoResetAction());
            }
        }
        catch (Exception e) {
            log.severe("BEdgeIoPulseInputProxyExt unable to add action SetCountAction");
        }
        this.calc = this.chooseCalc(this.getCalcType());
        if (this.calc != null) {
            this.calc.initType();
        }
    }

    public void doCalcRate() {
        if (this.calc != null) {
            this.calc.calculateRate();
        }
    }

    public void doSetCount(long count) {
        UpdateCount upd = new UpdateCount(this.getPointId(), count);
        this.getEdgeIoNetwork().sendMessage(upd);
        this.setTotal(count);
        if (this.calc != null) {
            this.calc.restart();
        }
    }

    private Calc chooseCalc(BEdgeIoCalcTypeEnum ctype) {
        switch (ctype.getOrdinal()) {
            case 0: {
                return new Count();
            }
            case 1: {
                return new FixedWindow();
            }
            case 2: {
                return new SlidingWindow();
            }
            case 3: {
                return new Trigger();
            }
        }
        return null;
    }

    void updateProxy(double v) {
        BStatusNumeric sval = (BStatusNumeric)this.getReadValue();
        sval.setValue(v);
        this.readOk((BStatusValue)sval);
    }

    void doCalculateRate(Sample oldestSmpl, Sample smpl) {
        smpl.capture();
        float rate = 1000.0f * (float)(smpl.count - oldestSmpl.count) / (float)(smpl.ticks - oldestSmpl.ticks);
        this.setRate(rate *= this.getRateScale());
        this.setRateCalcTime(BAbsTime.now());
        this.updateProxy(rate);
    }

    class Sample {
        long ticks;
        long count;

        public Sample() {
        }

        public Sample(boolean cap) {
            if (cap) {
                this.capture();
            }
        }

        public void capture() {
            this.ticks = Clock.ticks();
            this.count = BEdgeIoPulseInputProxyExt.this.getTotal();
        }
    }

    class SlidingWindow
    extends Calc {
        private Sample currSmpl;
        private Clock.Ticket ticket;
        private Queue queue;

        SlidingWindow() {
            this.currSmpl = new Sample();
            this.ticket = null;
            this.queue = new Queue();
        }

        @Override
        public void initType() {
            this.restart();
        }

        @Override
        public void doRestart() {
            this.queue.clear();
            this.queue.enqueue((Object)new Sample(true));
            this.resetClockTicket();
        }

        @Override
        public void cleanupType() {
            if (this.ticket != null) {
                this.ticket.cancel();
            }
        }

        @Override
        public void changed(Property p) {
            if (p == rateInterval || p == rateWindows) {
                this.resetClockTicket();
            }
        }

        private void resetClockTicket() {
            if (this.ticket != null) {
                this.ticket.cancel();
            }
            BRelTime period = BRelTime.make((long)(BEdgeIoPulseInputProxyExt.this.getRateInterval().getSeconds() / BEdgeIoPulseInputProxyExt.this.getRateWindows() * 1000));
            this.ticket = Clock.schedulePeriodically((BComponent)BEdgeIoPulseInputProxyExt.this, (BRelTime)period, (Action)calcRate, null);
        }

        @Override
        public void calculateRate() {
            if (this.wait4Update) {
                return;
            }
            if (this.queue.size() < BEdgeIoPulseInputProxyExt.this.getRateWindows()) {
                this.queue.enqueue((Object)new Sample());
                return;
            }
            Sample oldestSmpl = (Sample)this.queue.dequeue();
            BEdgeIoPulseInputProxyExt.this.doCalculateRate(oldestSmpl, this.currSmpl);
            this.queue.enqueue((Object)this.currSmpl);
            this.currSmpl = oldestSmpl;
        }
    }

    class FixedWindow
    extends Calc {
        private Sample currSmpl;
        private Sample oldestSmpl;
        private Clock.Ticket ticket;

        FixedWindow() {
            this.currSmpl = new Sample();
            this.oldestSmpl = new Sample();
            this.ticket = null;
        }

        @Override
        public void initType() {
            this.restart();
        }

        @Override
        public void cleanupType() {
            if (this.ticket != null) {
                this.ticket.cancel();
            }
        }

        @Override
        public void doRestart() {
            this.oldestSmpl.capture();
            this.resetClockTicket();
        }

        @Override
        public void changed(Property p) {
            if (p == rateInterval) {
                this.resetClockTicket();
            }
        }

        private void resetClockTicket() {
            if (this.ticket != null) {
                this.ticket.cancel();
            }
            this.ticket = Clock.schedulePeriodically((BComponent)BEdgeIoPulseInputProxyExt.this, (BRelTime)BEdgeIoPulseInputProxyExt.this.getRateInterval(), (Action)calcRate, null);
        }

        @Override
        public void calculateRate() {
            if (this.wait4Update) {
                return;
            }
            BEdgeIoPulseInputProxyExt.this.doCalculateRate(this.oldestSmpl, this.currSmpl);
            Sample s = this.currSmpl;
            this.currSmpl = this.oldestSmpl;
            this.oldestSmpl = s;
        }
    }

    class Trigger
    extends Calc {
        private Sample currSmpl;
        private Sample oldestSmpl;

        Trigger() {
            this.currSmpl = new Sample();
            this.oldestSmpl = new Sample();
        }

        @Override
        public void initType() {
            try {
                if (BEdgeIoPulseInputProxyExt.this.getParentPoint().getAction(BEdgeIoPulseInputProxyExt.RECALCULATE_RATE) == null) {
                    BEdgeIoPulseInputProxyExt.this.getParentPoint().add(BEdgeIoPulseInputProxyExt.RECALCULATE_RATE, (BValue)new BEdgeIoRecalcRateAction());
                }
            }
            catch (Exception e) {
                BEdgeIoProxyExt.log.severe("BEdgeIoPulseInputProxyExt unable to add action RecalcRateAction");
            }
            this.restart();
        }

        @Override
        public void cleanupType() {
            BEdgeIoPulseInputProxyExt.this.getParentPoint().remove(BEdgeIoPulseInputProxyExt.RECALCULATE_RATE);
        }

        @Override
        public void doRestart() {
            this.oldestSmpl.capture();
        }

        @Override
        public void calculateRate() {
            if (this.wait4Update) {
                return;
            }
            BEdgeIoPulseInputProxyExt.this.doCalculateRate(this.oldestSmpl, this.currSmpl);
            Sample s = this.currSmpl;
            this.currSmpl = this.oldestSmpl;
            this.oldestSmpl = s;
        }
    }

    class Count
    extends Calc {
        long initCount;

        Count() {
        }

        @Override
        public void initType() {
            this.initCount = BEdgeIoPulseInputProxyExt.this.getTotal();
        }

        @Override
        public void restart() {
            this.initCount = 0L;
        }

        @Override
        public void updateCount(long count) {
            long totCnt = count + this.initCount;
            BEdgeIoPulseInputProxyExt.this.setTotal(totCnt);
            BEdgeIoPulseInputProxyExt.this.updateProxy(totCnt);
        }
    }

    abstract class Calc {
        boolean wait4Update = true;

        Calc() {
        }

        public abstract void initType();

        public void cleanupType() {
        }

        public void changed(Property p) {
        }

        public void restart() {
            this.wait4Update = true;
            BEdgeIoPulseInputProxyExt.this.setStale(true, null);
        }

        public void updateCount(long cnt) {
            BEdgeIoPulseInputProxyExt.this.setTotal(cnt);
            if (this.wait4Update) {
                this.doRestart();
                this.wait4Update = false;
            }
        }

        void doRestart() {
        }

        public void calculateRate() {
        }
    }
}

