/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.edgeIo.conv;

import com.tridium.util.EscUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitException;

@NiagaraType
public final class BEdgeIoTabularThermistorConversion
extends BProxyConversion {
    private static final String DEFAULT_ENCODING = "Thermistor Type 3|0.0,165.0;610.0,110.0;1060.0,90.0;1690.0,75.0;2320.0,65.0;3250.0,55.0;4620.0,45.0;6240.0,37.0;8197.0,30.0;10000.0,25.0;12268.0,20.0;15136.0,15.0;18787.0,10.0;23462.0,5.0;29490.0,0.0;37316.0,-5.0;47549.0,-10.0;61030.0,-15.0;78930.0,-20.0;100000.0,-25.0;";
    public static final BEdgeIoTabularThermistorConversion NULL = BEdgeIoTabularThermistorConversion.make();
    public static final BEdgeIoTabularThermistorConversion DEFAULT = BEdgeIoTabularThermistorConversion.make("Thermistor Type 3|0.0,165.0;610.0,110.0;1060.0,90.0;1690.0,75.0;2320.0,65.0;3250.0,55.0;4620.0,45.0;6240.0,37.0;8197.0,30.0;10000.0,25.0;12268.0,20.0;15136.0,15.0;18787.0,10.0;23462.0,5.0;29490.0,0.0;37316.0,-5.0;47549.0,-10.0;61030.0,-15.0;78930.0,-20.0;100000.0,-25.0;");
    public static final Type TYPE = Sys.loadType(BEdgeIoTabularThermistorConversion.class);
    private static BUnit OHMS_UNIT = BUnit.getUnit((String)"ohm");
    private static BUnit CELSIUS_UNIT = BUnit.getUnit((String)"celsius");
    private ArrayList<XYPoint> points = new ArrayList();
    private double[] ohmsArray = null;
    private double[] celsiusArray = null;
    private String description = "";

    public Type getType() {
        return TYPE;
    }

    public static BEdgeIoTabularThermistorConversion make() {
        return new BEdgeIoTabularThermistorConversion();
    }

    public static BEdgeIoTabularThermistorConversion make(String encoding) {
        try {
            return (BEdgeIoTabularThermistorConversion)NULL.decodeFromString(encoding);
        }
        catch (Exception e) {
            return new BEdgeIoTabularThermistorConversion();
        }
    }

    private BEdgeIoTabularThermistorConversion() {
    }

    public ArrayList<XYPoint> getPoints() {
        return this.points;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void add(double x, double y) {
        XYPoint p = new XYPoint(x, y);
        this.points.add(p);
        this.refreshArrays();
    }

    public void convertDeviceToProxy(BProxyExt ext, BStatusValue deviceValue, BStatusValue proxyValue) throws Exception {
        if (deviceValue instanceof BStatusNumeric) {
            BUnit proxyUnit = (BUnit)ext.getPointFacets().get("units", (BObject)BUnit.NULL);
            BUnit deviceUnit = (BUnit)ext.getDeviceFacets().get("units", (BObject)BUnit.NULL);
            boolean deviceOk = deviceUnit.isConvertible(OHMS_UNIT) || deviceUnit.isNull();
            boolean proxyOk = proxyUnit.isConvertible(CELSIUS_UNIT);
            if (this.ohmsArray == null) {
                deviceValue.copyFrom((BComplex)proxyValue);
                throw new UnitException("Not convertible: invalid points table");
            }
            if (deviceOk && proxyOk) {
                double ohms = deviceUnit.convertTo(OHMS_UNIT, ((BStatusNumeric)deviceValue).getValue());
                double celsius = this.convertTo(ohms, this.ohmsArray, this.celsiusArray);
                proxyValue.setStatus(deviceValue.getStatus());
                ((BStatusNumeric)proxyValue).setValue(CELSIUS_UNIT.convertTo(proxyUnit, celsius));
                return;
            }
            proxyValue.copyFrom((BComplex)deviceValue);
            throw new UnitException("Not convertible: " + deviceUnit + " -> " + proxyUnit);
        }
        proxyValue.copyFrom((BComplex)deviceValue);
        throw new UnitException("Not convertible: invalid point type");
    }

    public void convertProxyToDevice(BProxyExt ext, BStatusValue proxyValue, BStatusValue deviceValue) throws Exception {
        if (proxyValue instanceof BStatusNumeric) {
            BUnit proxyUnit = (BUnit)ext.getPointFacets().get("units", (BObject)BUnit.NULL);
            BUnit deviceUnit = (BUnit)ext.getDeviceFacets().get("units", (BObject)BUnit.NULL);
            boolean deviceOk = deviceUnit.isConvertible(OHMS_UNIT) || deviceUnit.isNull();
            boolean proxyOk = proxyUnit.isConvertible(CELSIUS_UNIT);
            if (this.ohmsArray == null) {
                deviceValue.copyFrom((BComplex)proxyValue);
                throw new UnitException("Not convertible: invalid points table");
            }
            if (deviceOk && proxyOk) {
                double celsius = proxyUnit.convertTo(CELSIUS_UNIT, ((BStatusNumeric)proxyValue).getValue());
                double ohms = this.convertTo(celsius, this.celsiusArray, this.ohmsArray);
                deviceValue.setStatus(proxyValue.getStatus());
                ((BStatusNumeric)deviceValue).setValue(OHMS_UNIT.convertTo(deviceUnit, ohms));
                return;
            }
            deviceValue.copyFrom((BComplex)proxyValue);
            throw new UnitException("Not convertible: " + proxyUnit + " -> " + deviceUnit);
        }
        deviceValue.copyFrom((BComplex)proxyValue);
        throw new UnitException("Not convertible: invalid point type");
    }

    private double convertTo(double src, double[] srcArray, double[] destArray) {
        int band = 0;
        int count = srcArray.length;
        if (src < srcArray[0]) {
            return destArray[0];
        }
        if (src > srcArray[count - 1]) {
            return destArray[count - 1];
        }
        if (src == srcArray[count - 1]) {
            return destArray[count - 1];
        }
        for (int i = 0; i < count - 1; ++i) {
            if (!(src >= srcArray[i]) || !(src < srcArray[i + 1])) continue;
            band = i;
            break;
        }
        double p1 = srcArray[band];
        double p2 = srcArray[band + 1];
        double v1 = destArray[band];
        double v2 = destArray[band + 1];
        return v1 - (p1 - src) * (v1 - v2) / (p1 - p2);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BEdgeIoTabularThermistorConversion)) {
            return false;
        }
        BEdgeIoTabularThermistorConversion conv = (BEdgeIoTabularThermistorConversion)((Object)obj);
        ArrayList<XYPoint> objPoints = conv.getPoints();
        if (this.points.size() != objPoints.size()) {
            return false;
        }
        for (int i = 0; i < this.points.size(); ++i) {
            XYPoint pnt = this.points.get(i);
            if (pnt.equals(objPoints.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString(Context context) {
        return this.encodeToString();
    }

    public void regen() {
        this.points.sort(Comparator.naturalOrder());
        this.refreshArrays();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() {
        StringBuffer sb = new StringBuffer();
        String descriptionx = EscUtil.slot.escape(this.description);
        sb.append(descriptionx).append("|");
        for (int i = 0; i < this.points.size(); ++i) {
            XYPoint p = this.points.get(i);
            sb.append(p.x()).append(',').append(p.y()).append(';');
        }
        return sb.toString();
    }

    public BObject decodeFromString(String src) throws IOException {
        BEdgeIoTabularThermistorConversion conv = new BEdgeIoTabularThermistorConversion();
        int last = -1;
        int sep = src.indexOf(124);
        String descriptionx = src.substring(0, sep);
        conv.setDescription(EscUtil.slot.unescape(descriptionx));
        last = sep;
        sep = src.indexOf(59);
        while (true) {
            if (sep == -1) break;
            this.decodePoint(conv, src.substring(last + 1, sep));
            last = sep;
            sep = src.indexOf(59, last + 1);
        }
        this.decodePoint(conv, src.substring(last + 1));
        conv.regen();
        return conv;
    }

    private void decodePoint(BEdgeIoTabularThermistorConversion conv, String src) {
        int comma = src.indexOf(44);
        if (comma == -1) {
            return;
        }
        String xstr = src.substring(0, comma).trim();
        String ystr = src.substring(comma + 1).trim();
        if (xstr.length() > 0 && ystr.length() > 0) {
            try {
                double x = Double.parseDouble(xstr);
                double y = Double.parseDouble(ystr);
                conv.add(x, y);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void refreshArrays() {
        if (this.points.size() >= 2) {
            this.ohmsArray = new double[this.points.size()];
            this.celsiusArray = new double[this.points.size()];
            for (int i = 0; i < this.points.size(); ++i) {
                XYPoint pnt = this.points.get(i);
                this.ohmsArray[i] = pnt.x();
                this.celsiusArray[i] = pnt.y();
            }
        } else {
            this.celsiusArray = null;
            this.ohmsArray = null;
        }
    }

    public class XYPoint
    implements Comparable<Object> {
        private double x;
        private double y;

        public XYPoint(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double x() {
            return this.x;
        }

        public double y() {
            return this.y;
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof XYPoint) {
                XYPoint p = (XYPoint)o;
                if (p.x > this.x) {
                    return -1;
                }
                if (p.x < this.x) {
                    return 1;
                }
                return 0;
            }
            throw new ClassCastException("object not of type XYPoint.class");
        }

        public boolean equals(Object o) {
            if (o instanceof XYPoint) {
                XYPoint p = (XYPoint)o;
                return this.x == p.x && this.y == p.y;
            }
            return false;
        }

        public int hashCode() {
            long bits = Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.y);
            return (int)(bits >> 32) ^ (int)bits;
        }
    }
}

