/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.edgeIo.comm;

import com.tridium.edgeIo.BEdgeIoNetwork;
import com.tridium.edgeIo.messages.UpdateAnalog;
import com.tridium.edgeIo.messages.UpdateCount;
import com.tridium.edgeIo.messages.UpdateDigital;
import com.tridium.ndriver.io.TypedInputStream;

public class EdgeIoListener {
    BEdgeIoNetwork net;

    public EdgeIoListener(BEdgeIoNetwork net) {
        this.net = net;
    }

    public void receiveIncoming(byte[] amsg, int len) {
        TypedInputStream tin = new TypedInputStream(amsg, 0, len);
        int type = tin.readUnsigned8();
        switch (type) {
            case 5: {
                UpdateAnalog upAnalog = new UpdateAnalog();
                upAnalog.fromInputStream(tin);
                this.net.printMsgLog(upAnalog, true);
                this.net.getLocal().updateAnalog(upAnalog);
                break;
            }
            case 6: {
                UpdateDigital upDigital = new UpdateDigital();
                upDigital.fromInputStream(tin);
                this.net.printMsgLog(upDigital, true);
                this.net.getLocal().updateDigital(upDigital);
                break;
            }
            case 8: {
                UpdateCount upCount = new UpdateCount();
                upCount.fromInputStream(tin);
                this.net.printMsgLog(upCount, true);
                this.net.getLocal().updateCount(upCount);
                break;
            }
            case 9: {
                this.net.getLocal().receiveHeartBeat();
                break;
            }
            default: {
                this.net.log().warning("Received unknown message type:" + type);
                return;
            }
        }
    }
}

