/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.edgeIo;

import com.tridium.driver.util.DrByteArrayUtil;
import com.tridium.edgeIo.BEdgeIoDevice;
import com.tridium.edgeIo.comm.EdgeIoReceive;
import com.tridium.edgeIo.datatypes.BEdgeIoDriverParams;
import com.tridium.edgeIo.messages.BEdgeIoMessageTypeEnum;
import com.tridium.edgeIo.messages.EdgeIoMessage;
import com.tridium.edgeIo.messages.SetDriverParam;
import com.tridium.edgeIo.point.IoDefaultUtil;
import com.tridium.ndriver.BNNetwork;
import com.tridium.platEdgeIo.BEdgeIoPlatformService;
import com.tridium.sys.Nre;
import com.tridium.sys.station.Station;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enableCommLossDefaults", type="boolean", defaultValue="true", facets={@Facet(value="BFacets.makeBoolean(\"enabled\", \"disabled\")")}), @NiagaraProperty(name="commLossTimeout", type="int", defaultValue="8", facets={@Facet(value="BFacets.makeInt(BUnit.getUnit(\"second\"), 8, 3600)")}), @NiagaraProperty(name="debugLevel", type="int", defaultValue="0", flags=4), @NiagaraProperty(name="local", type="BEdgeIoDevice", defaultValue="new BEdgeIoDevice()")})
@NiagaraActions(value={@NiagaraAction(name="setDriverParam", parameterType="BEdgeIoDriverParams", defaultValue="new BEdgeIoDriverParams()", flags=0), @NiagaraAction(name="heartbeat", flags=4)})
public class BEdgeIoNetwork
extends BNNetwork {
    public static final Property enableCommLossDefaults = BEdgeIoNetwork.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property commLossTimeout = BEdgeIoNetwork.newProperty((int)0, (int)8, (BFacets)BFacets.makeInt((BUnit)BUnit.getUnit((String)"second"), (int)8, (int)3600));
    public static final Property debugLevel = BEdgeIoNetwork.newProperty((int)4, (int)0, null);
    public static final Property local = BEdgeIoNetwork.newProperty((int)0, (BValue)new BEdgeIoDevice(), null);
    public static final Action setDriverParam = BEdgeIoNetwork.newAction((int)0, (BValue)new BEdgeIoDriverParams(), null);
    public static final Action heartbeat = BEdgeIoNetwork.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BEdgeIoNetwork.class);
    boolean serviceInitialized = false;
    private HeartbeatThread heartbeatThread = null;
    private Station.SaveListener saveListener = new EdgeIoSaveListener();
    private EdgeIoReceive receiver;
    public static final BFacets showMilliSecs = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
    public static Lexicon LEX = Lexicon.make(BEdgeIoNetwork.class);
    public static final long HEARTBEAT_FREQUENCY = AccessController.doPrivileged(() -> Long.getLong("niagara.edgeIo.heartbeatFrequency", 3900L));
    public static final long HEARTBEAT_RECOVERY = AccessController.doPrivileged(() -> Long.getLong("niagara.edgeIo.heartbeatRecovery", 5000L));

    public boolean getEnableCommLossDefaults() {
        return this.getBoolean(enableCommLossDefaults);
    }

    public void setEnableCommLossDefaults(boolean v) {
        this.setBoolean(enableCommLossDefaults, v, null);
    }

    public int getCommLossTimeout() {
        return this.getInt(commLossTimeout);
    }

    public void setCommLossTimeout(int v) {
        this.setInt(commLossTimeout, v, null);
    }

    public int getDebugLevel() {
        return this.getInt(debugLevel);
    }

    public void setDebugLevel(int v) {
        this.setInt(debugLevel, v, null);
    }

    public BEdgeIoDevice getLocal() {
        return (BEdgeIoDevice)this.get(local);
    }

    public void setLocal(BEdgeIoDevice v) {
        this.set(local, (BValue)v, null);
    }

    public void setDriverParam(BEdgeIoDriverParams parameter) {
        this.invoke(setDriverParam, (BValue)parameter, null);
    }

    public void heartbeat() {
        this.invoke(heartbeat, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getNetworkName() {
        return "EdgeIoNetwork";
    }

    public Type getDeviceFolderType() {
        return null;
    }

    public Type getDeviceType() {
        return BEdgeIoDevice.TYPE;
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p == enabled) {
            this.checkServiceRunning();
        } else if (p == commLossTimeout || p == enableCommLossDefaults) {
            this.sendDriverParams();
        }
    }

    public final void serviceStarted() throws Exception {
        super.serviceStarted();
        try {
            BIService srv = (BIService)Nre.getServiceManager().getService("aceEdge:AceEdgeNetwork");
            if (srv != null) {
                String err = LEX.getText("edgeIoNetworkError.TwoTypesOfNetwork");
                this.configFatal(err);
                return;
            }
        }
        catch (ServiceNotFoundException srv) {
            // empty catch block
        }
        BComponent[] ca = Nre.getServiceManager().getServices("edgeIo:EdgeIoNetwork");
        if (ca.length > 1) {
            String err = LEX.getText("edgeIoNetworkError.MoreThanOneInstance");
            this.configFatal(err);
            return;
        }
        if (this.isAceRunning()) {
            String err = LEX.getText("edgeIoNetworkError.AceIsRunning");
            this.configFatal(err);
            return;
        }
        this.checkServiceRunning();
    }

    protected boolean isAceRunning() throws Exception {
        BEdgeIoPlatformService service = (BEdgeIoPlatformService)Sys.getService((Type)BEdgeIoPlatformService.TYPE);
        return service.isAceRunning();
    }

    protected void checkServiceRunning() {
        try {
            if (this.isFault()) {
                return;
            }
            if (this.getEnabled()) {
                this.initService();
            } else {
                this.shutDownService();
            }
        }
        catch (Exception e) {
            this.log().severe(e.getMessage());
            e.printStackTrace();
        }
    }

    private void initService() throws Exception {
        if (this.serviceInitialized) {
            return;
        }
        Station.addSaveListener((Station.SaveListener)this.saveListener);
        BEdgeIoPlatformService service = (BEdgeIoPlatformService)Sys.getService((Type)BEdgeIoPlatformService.TYPE);
        service.driverInit();
        this.receiver = new EdgeIoReceive(this);
        this.receiver.start();
        this.serviceInitialized = true;
        if (this.isRunning()) {
            this.sendDriverParams();
            this.initHeartbeat();
        }
    }

    public void serviceStopped() throws Exception {
        this.shutDownService();
    }

    private void shutDownService() throws Exception {
        if (!this.serviceInitialized) {
            return;
        }
        this.stopHeartbeat();
        Station.removeSaveListener((Station.SaveListener)this.saveListener);
        this.receiver.stop();
        this.receiver = null;
        this.serviceInitialized = false;
    }

    protected boolean useAutoManager() {
        return false;
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] kids = super.getNavChildren();
        Array acc = new Array(BINavNode.class);
        acc.add((Object)this.getLocal());
        for (int i = 0; i < kids.length; ++i) {
            acc.add((Object)kids[i]);
        }
        return (BINavNode[])acc.trim();
    }

    public final AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.remove("ndriver:NDeviceManager");
        return list;
    }

    public final void started() {
        if (Sys.isStationStarted()) {
            this.stationStarted();
        }
    }

    public final void stationStarted() {
        this.exportIoDefaults();
        if (this.getEnabled()) {
            this.sendDriverParams();
            this.initHeartbeat();
        }
    }

    public void sendMessage(EdgeIoMessage msg) {
        if (!this.getStatus().isOk()) {
            return;
        }
        SendMessage sndMsg = new SendMessage(msg);
        try {
            this.postAsync(sndMsg);
        }
        catch (Throwable e) {
            sndMsg.run();
        }
    }

    private void initHeartbeat() {
        this.stopHeartbeat();
        this.heartbeatThread = new HeartbeatThread();
        this.heartbeatThread.start();
    }

    private void stopHeartbeat() {
        if (this.heartbeatThread != null) {
            HeartbeatThread t = this.heartbeatThread;
            this.heartbeatThread = null;
            t.requestStop();
            try {
                t.join(HEARTBEAT_RECOVERY);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (t.isAlive()) {
                this.log().warning("Failed to stop heartbeat.");
            }
        }
    }

    public void doHeartbeat() {
        EdgeIoMessage msg = new EdgeIoMessage(BEdgeIoMessageTypeEnum.heartBeat);
        this.sendMessage(msg);
    }

    public void printMsgLog(EdgeIoMessage msg, boolean recv) {
        if (this.log().isLoggable(Level.FINE)) {
            System.out.println(this.debugHdr() + "\n" + (recv ? "rcv:" : "send:") + msg.toTraceString());
        }
    }

    public void printMsgByteLog(byte[] a, int len, boolean recv) {
        if (this.log().isLoggable(Level.FINER)) {
            System.out.println(this.debugHdr() + (recv ? "read:" : "write:") + DrByteArrayUtil.toString((byte[])a, (int)len));
        }
    }

    private String debugHdr() {
        return "[" + this.getNetworkName() + "]" + BAbsTime.make((long)System.currentTimeMillis()).toTimeString((Context)showMilliSecs) + "|";
    }

    public void doSetDriverParam(BEdgeIoDriverParams parm) {
        this.setEnableCommLossDefaults(parm.getEnableCommLossDefaults());
        this.setCommLossTimeout(parm.getCommLossTimeout());
        SetDriverParam msg = new SetDriverParam(parm);
        this.sendMessage(msg);
    }

    public void sendDriverParams() {
        BEdgeIoDriverParams parm = new BEdgeIoDriverParams();
        parm.setEnableCommLossDefaults(this.getEnableCommLossDefaults());
        parm.setCommLossTimeout(this.getCommLossTimeout());
        parm.setDebugLevel(this.getDebugLevel());
        SetDriverParam msg = new SetDriverParam(parm);
        this.sendMessage(msg);
    }

    private void exportIoDefaults() {
        IoDefaultUtil.exportIoDefaults(this);
    }

    private final class EdgeIoSaveListener
    implements Station.SaveListener {
        private EdgeIoSaveListener() {
        }

        public void stationSave() throws Exception {
            BEdgeIoNetwork.this.exportIoDefaults();
        }

        public void stationSaveOk() throws Exception {
        }

        public void stationSaveFail(String cause) throws Exception {
        }

        public final String toString() {
            return "EdgeIONetworkSaveListener " + BEdgeIoNetwork.this.getNavOrd();
        }
    }

    private class HeartbeatThread
    extends Thread {
        private volatile boolean done;

        public HeartbeatThread() {
            super("EdgeIo:HeartbeatThread");
            this.done = false;
        }

        @Override
        public void run() {
            while (!this.done) {
                BEdgeIoNetwork.this.doHeartbeat();
                try {
                    HeartbeatThread.sleep(HEARTBEAT_FREQUENCY);
                }
                catch (InterruptedException ignore) {
                    if (this.done) continue;
                    BEdgeIoNetwork.this.log().warning("Unexpected interruption of heartbeat.");
                }
            }
        }

        public void requestStop() {
            this.done = true;
            this.interrupt();
        }
    }

    public class SendMessage
    implements Runnable {
        EdgeIoMessage msg;

        SendMessage(EdgeIoMessage msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            try {
                byte[] a = this.msg.toByteArray();
                BEdgeIoPlatformService service = (BEdgeIoPlatformService)Sys.getService((Type)BEdgeIoPlatformService.TYPE);
                BEdgeIoNetwork.this.printMsgLog(this.msg, false);
                BEdgeIoNetwork.this.printMsgByteLog(a, a.length, false);
                service.write(a, a.length);
            }
            catch (Exception e) {
                BEdgeIoNetwork.this.log().severe("Error sending message:" + e.getMessage());
            }
        }
    }
}

