/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.ui.device;

import com.tridium.bacnetAws.job.BDeviceCommControlJob;
import com.tridium.bacnetAws.job.BReinitializeDeviceJob;
import com.tridium.bacnetAws.ui.device.BBacnetAwsDeviceManager;
import com.tridium.bacnetOws.ui.device.BBacnetOwsDeviceManager;
import com.tridium.bacnetOws.ui.device.BacnetOwsDeviceLearn;
import java.text.MessageFormat;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.sys.BString;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.util.UiLexicon;

public class BacnetAwsDeviceLearn
extends BacnetOwsDeviceLearn {
    UiLexicon awslex = UiLexicon.makeUiLexicon(BacnetAwsDeviceLearn.class);

    public BacnetAwsDeviceLearn(BBacnetAwsDeviceManager mgr) {
        super((BBacnetOwsDeviceManager)mgr);
    }

    public void jobComplete(BJob job) {
        Type jobType = job.getType();
        job.lease(1);
        if (jobType == BReinitializeDeviceJob.TYPE) {
            String msg = null;
            if (job.getJobState() == BJobState.success) {
                msg = this.awslex.getText("reinitDevice.success");
            } else {
                BString s = (BString)job.get("failureCause");
                String cause = s != null ? s.getString() : "";
                msg = MessageFormat.format(this.awslex.getText("reinitDevice.fail"), cause);
            }
            BDialog.message((BWidget)this.getManager(), (String)this.awslex.getText("reinitDevice.title"), (Object)msg);
        } else if (jobType == BDeviceCommControlJob.TYPE) {
            String msg = null;
            if (job.getJobState() == BJobState.success) {
                msg = this.awslex.getText("devCommCtrl.success");
            } else {
                BString s = (BString)job.get("failureCause");
                String cause = s != null ? s.getString() : "";
                msg = MessageFormat.format(this.awslex.getText("devCommCtrl.fail"), cause);
            }
            BDialog.message((BWidget)this.getManager(), (String)this.awslex.getText("devCommCtrl.title"), (Object)msg);
        } else {
            super.jobComplete(job);
        }
    }
}

