/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history.ext;

import java.io.IOException;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BIntervalHistoryExt
extends BHistoryExt {
    public static final Property interval = BIntervalHistoryExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Action intervalElapsed = BIntervalHistoryExt.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BIntervalHistoryExt.class);
    private Clock.Ticket ticket;
    private final Object lock = new Object();

    public BRelTime getInterval() {
        return (BRelTime)this.get(interval);
    }

    public void setInterval(BRelTime v) {
        this.set(interval, (BValue)v, null);
    }

    public void intervalElapsed() {
        this.invoke(intervalElapsed, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (this.isValidInterval(this.getInterval())) {
            BCollectionInterval collectionInterval = BCollectionInterval.make(this.getInterval());
            if (!this.getHistoryConfig().getInterval().equals((Object)collectionInterval)) {
                this.getHistoryConfig().setInterval(collectionInterval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopped() throws Exception {
        super.stopped();
        Object object = this.lock;
        synchronized (object) {
            if (this.ticket != null) {
                this.ticket.cancel();
                this.ticket = null;
            }
        }
    }

    @Override
    public void activated(BAbsTime startTime, BAbsTime currentTime, BStatusValue value) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            String s = this.getSlotPath() + ": activated (start=" + startTime.toString((Context)BHistoryRecord.TIMESTAMP_FACETS) + ", current=" + currentTime.toString((Context)BHistoryRecord.TIMESTAMP_FACETS) + ")";
            log.fine(s);
        }
        if (startTime.getMillis() + 5000L > currentTime.getMillis()) {
            this.writeRecord(currentTime, value);
        }
        this.scheduleCollection(currentTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivated(BAbsTime currentTime, BStatusValue value) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ticket != null) {
                this.ticket.cancel();
                this.ticket = null;
            }
        }
    }

    @Override
    public void pointChanged(BAbsTime timestamp, BStatusValue out) throws IOException {
    }

    protected abstract void writeRecord(BAbsTime var1, BStatusValue var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCollection(BAbsTime from) {
        BAbsTime start = null;
        BRelTime interval = this.getInterval();
        try {
            if (!this.isValidInterval(interval)) {
                return;
            }
            if (this.getActivePeriod().isActive(from)) {
                start = this.getActivePeriod().getActiveStart(from);
                while (!start.isAfter(from)) {
                    start = start.add(interval);
                }
            } else {
                start = this.getActivePeriod().getNextActive(from);
                if (start == null) {
                    start = BAbsTime.make((BAbsTime)from, (BTime)BTime.make((int)0, (int)0, (int)0, (int)0));
                    while (!start.isAfter(from)) {
                        start = start.add(interval);
                    }
                }
            }
            if (log.isLoggable(Level.FINE)) {
                String s = "Collection scheduled. (start=" + start.toString((Context)BHistoryRecord.TIMESTAMP_FACETS) + ", interval=" + this.getInterval().toString((Context)BHistoryRecord.TIMESTAMP_FACETS) + ")";
                log.fine(s);
            }
        }
        catch (RuntimeException e) {
            Object object = this.lock;
            synchronized (object) {
                if (this.ticket != null) {
                    this.ticket.cancel();
                    this.ticket = null;
                }
            }
            throw e;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.ticket != null) {
                this.ticket.cancel();
                this.ticket = null;
            }
            if (this.isRunning()) {
                this.ticket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)start, (BRelTime)interval, (Action)intervalElapsed, null);
            }
        }
    }

    public void doIntervalElapsed() {
        try {
            this.writeRecord(BAbsTime.make(), this.getParentPoint().getStatusValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clockChanged(BRelTime shift) throws Exception {
        super.clockChanged(shift);
        if (this.getActive()) {
            this.scheduleCollection(BAbsTime.make());
        }
    }

    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (cx == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(interval)) {
            if (!this.isValidInterval(this.getInterval())) {
                return;
            }
            this.getHistoryConfig().setInterval(BCollectionInterval.make(this.getInterval()));
            if (this.getActive()) {
                this.scheduleCollection(BAbsTime.make());
            }
        }
    }

    @Override
    public void updateStatus() {
        super.updateStatus();
        if (this.getStatus().isFault()) {
            return;
        }
        if (!this.isValidInterval(this.getInterval())) {
            BStatus newStatus = BStatus.makeFault((BStatus)this.getStatus(), (boolean)true);
            if (!this.getStatus().equals((Object)newStatus)) {
                this.setStatus(newStatus);
                this.setFaultCause("Invalid interval: " + this.getInterval().toString());
            }
        } else {
            this.setFaultCause("");
        }
    }

    private boolean isValidInterval(BRelTime interval) {
        return interval.getMillis() > 0L;
    }
}

