/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history.db;

import com.tridium.history.db.BSysHistories;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bql.BIRelational;
import javax.baja.collection.BITable;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryEvent;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.DatabaseClosedException;
import javax.baja.history.HistoryEventListener;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.InvalidHistoryIdException;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.BIProtected;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BHistoryDatabase
extends BHistorySpace
implements BIRelational<BIObject>,
BITable<BHistoryConfig> {
    public static final Type TYPE = Sys.loadType(BHistoryDatabase.class);
    private static final BIcon icon = BIcon.std((String)"historyDatabase.png");
    public static Logger log = Logger.getLogger("history.db");
    static final Logger eventLogger = Logger.getLogger("history.event");
    private boolean open = false;
    private final ArrayList<HistoryEventListener> listeners = new ArrayList();

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHistoryDatabase() {
    }

    @Override
    public HistorySpaceConnection getConnection(Context cx) throws HistoryException {
        return this.getDbConnection(cx);
    }

    public abstract HistoryDatabaseConnection getDbConnection(Context var1);

    public BITable<BIObject> getRelation(String id, Context cx) {
        BITable<BHistoryConfig> sysTable;
        if (id.startsWith("sys.") && (sysTable = this.getSystemTable(id, cx)) != null) {
            return sysTable;
        }
        BOrd histOrd = BOrd.make((OrdQuery)new HistoryQuery(id));
        try {
            BObject object = histOrd.get((BObject)this, cx);
            if (object instanceof BITable) {
                if (cx != null && cx.getUser() != null && object instanceof BIProtected && !cx.getUser().getPermissionsFor((BIProtected)object).hasOperatorRead()) {
                    return null;
                }
                return (BITable)object;
            }
            throw new IllegalStateException("Unexpected type " + object.getType());
        }
        catch (UnresolvedException e) {
            return null;
        }
    }

    public BFacets getTableFacets() {
        return BFacets.NULL;
    }

    public synchronized boolean isOpen() {
        return this.open;
    }

    protected void checkOpen() throws DatabaseClosedException {
        if (!this.open) {
            throw new DatabaseClosedException("The requested operation is not allowed while the database is closed.");
        }
    }

    public final synchronized void open() throws IOException {
        if (this.open) {
            return;
        }
        this.doOpen();
        this.open = true;
        if (this.hasHistoryEventListeners()) {
            this.fireHistoryEvent(BHistoryEvent.makeDbOpened());
        }
    }

    protected abstract void doOpen() throws IOException;

    public final void close() {
        if (!this.open) {
            return;
        }
        this.doClose();
        this.open = false;
        if (this.hasHistoryEventListeners()) {
            this.fireHistoryEvent(BHistoryEvent.makeDbClosed());
        }
    }

    protected abstract void doClose();

    public final void flush() throws IOException, HistoryException {
        if (!this.open) {
            return;
        }
        this.doFlush();
        if (this.hasHistoryEventListeners()) {
            this.fireHistoryEvent(BHistoryEvent.makeDbFlushed());
        }
    }

    protected abstract void doFlush();

    @Override
    public String getDeviceName() {
        return Sys.getStation().getStationName();
    }

    public abstract void setConfig(BHistoryConfig var1);

    public BITable<BHistoryConfig> getSystemTable(String id) {
        return this.getSystemTable(id, null);
    }

    public BITable<BHistoryConfig> getSystemTable(String id, Context cx) {
        if (id.equalsIgnoreCase("sys.histories")) {
            return new BSysHistories(this, cx);
        }
        return null;
    }

    private void validateConfig(BHistoryConfig config) throws HistoryException {
        if (!config.getId().isValid()) {
            throw new InvalidHistoryIdException(config.getId());
        }
    }

    public BIHistory[] getHistories() {
        this.checkOpen();
        ArrayList<BIHistory> arr = new ArrayList<BIHistory>();
        BHistoryDevice[] devices = this.listDevices();
        for (int i = 0; i < devices.length; ++i) {
            BHistoryDevice dev = devices[i];
            BHistorySpace hs = (BHistorySpace)dev.getSpace();
            arr.addAll(Arrays.asList(hs.listHistories(dev)));
        }
        return arr.toArray(new BIHistory[arr.size()]);
    }

    public boolean hasHistoryEventListeners() {
        return this.listeners.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoryEventListener[] getHistoryEventListeners() {
        HistoryEventListener[] r = null;
        ArrayList<HistoryEventListener> arrayList = this.listeners;
        synchronized (arrayList) {
            r = this.listeners.toArray(new HistoryEventListener[this.listeners.size()]);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryEventListener(HistoryEventListener listener) {
        ArrayList<HistoryEventListener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                if (this.listeners.get(i) != listener) continue;
                return;
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHistoryEventListener(HistoryEventListener listener) {
        ArrayList<HistoryEventListener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                if (this.listeners.get(i) != listener) continue;
                this.listeners.remove(i);
                break;
            }
        }
    }

    public void fireHistoryEvent(BHistoryEvent event) {
        if (eventLogger.isLoggable(Level.FINE)) {
            eventLogger.fine(event.toString());
        }
        HistoryEventListener[] x = this.getHistoryEventListeners();
        for (int i = 0; i < x.length; ++i) {
            try {
                x[i].historyEvent(event);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

