/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Base64;
import javax.baja.collection.AbstractCursor;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.util.BTypeSpec;

public abstract class HistoryCursor
extends AbstractCursor<BHistoryRecord> {
    private static final String HISTORY_REC_TYPE = "historyRecordTypeSpec";
    private static final String PRE_HISTORY_REC = "historyCursorPreRec";
    private static final String POST_HISTORY_REC = "historyCursorPostRec";
    private final BHistoryConfig config;
    private final BHistoryRecord iteratorRec;
    private final Context context;

    protected HistoryCursor(BHistoryConfig config, BHistoryRecord iteratorRec, Context context) {
        this.config = config;
        this.iteratorRec = iteratorRec;
        this.context = context;
    }

    public BHistoryConfig getConfig() {
        return this.config;
    }

    public Context getContext() {
        return this.context;
    }

    protected final boolean advanceCursor() {
        return this.doNext(this.iteratorRec);
    }

    protected abstract boolean doNext(BHistoryRecord var1);

    protected BHistoryRecord doGet() {
        return this.iteratorRec;
    }

    public static BFacets makeBoundaryRecordFacets(BHistoryRecord preRec, BHistoryRecord postRec) throws IOException {
        if (preRec != null && postRec != null) {
            ByteBuffer buf = new ByteBuffer();
            preRec.write((DataOutput)buf);
            byte[] preRecBytes = buf.toByteArray();
            buf.reset();
            postRec.write((DataOutput)buf);
            byte[] postRecBytes = buf.toByteArray();
            return BFacets.make((String)HISTORY_REC_TYPE, (BIDataValue)BString.make((String)preRec.getType().getTypeSpec().encodeToString()), (String)PRE_HISTORY_REC, (BIDataValue)BString.make((String)Base64.getEncoder().encodeToString(preRecBytes)), (String)POST_HISTORY_REC, (BIDataValue)BString.make((String)Base64.getEncoder().encodeToString(postRecBytes)));
        }
        if (preRec != null) {
            ByteBuffer buf = new ByteBuffer();
            preRec.write((DataOutput)buf);
            return BFacets.make((String)HISTORY_REC_TYPE, (BIDataValue)BString.make((String)preRec.getType().getTypeSpec().encodeToString()), (String)PRE_HISTORY_REC, (BIDataValue)BString.make((String)Base64.getEncoder().encodeToString(buf.toByteArray())));
        }
        if (postRec != null) {
            ByteBuffer buf = new ByteBuffer();
            postRec.write((DataOutput)buf);
            return BFacets.make((String)HISTORY_REC_TYPE, (BIDataValue)BString.make((String)postRec.getType().getTypeSpec().encodeToString()), (String)POST_HISTORY_REC, (BIDataValue)BString.make((String)Base64.getEncoder().encodeToString(buf.toByteArray())));
        }
        return BFacets.NULL;
    }

    public static BHistoryRecord extractPreRecord(BFacets facets) throws IOException {
        String historyRecTypeSpec = facets.gets(HISTORY_REC_TYPE, null);
        if (historyRecTypeSpec == null) {
            return null;
        }
        String encodedRec = facets.gets(PRE_HISTORY_REC, null);
        if (encodedRec == null) {
            return null;
        }
        BHistoryRecord rec = (BHistoryRecord)((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(historyRecTypeSpec)).getInstance();
        ByteBuffer buf = new ByteBuffer(Base64.getDecoder().decode(encodedRec));
        return rec.read((DataInput)buf);
    }

    public static BHistoryRecord extractPostRecord(BFacets facets) throws IOException {
        String historyRecTypeSpec = facets.gets(HISTORY_REC_TYPE, null);
        if (historyRecTypeSpec == null) {
            return null;
        }
        String encodedRec = facets.gets(POST_HISTORY_REC, null);
        if (encodedRec == null) {
            return null;
        }
        BHistoryRecord rec = (BHistoryRecord)((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(historyRecTypeSpec)).getInstance();
        ByteBuffer buf = new ByteBuffer(Base64.getDecoder().decode(encodedRec));
        return rec.read((DataInput)buf);
    }
}

