/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.history.BTrendFlags;
import javax.baja.history.BTrendRecord;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BStringTrendRecord
extends BTrendRecord
implements BIStatus {
    public static final Property value = BStringTrendRecord.newProperty((int)8, (String)"", null);
    public static final Type TYPE = Sys.loadType(BStringTrendRecord.class);

    public String getValue() {
        return this.getString(value);
    }

    public void setValue(String v) {
        this.setString(value, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BStringTrendRecord() {
    }

    public BStringTrendRecord(BAbsTime timestamp, String s, BStatus status) {
        super(timestamp, status);
        this.setValue(s);
    }

    @Override
    public Property getValueProperty() {
        return value;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    protected void doReadTrend(DataInput in) throws IOException {
        this.setValue(in.readUTF());
    }

    @Override
    protected void doWriteTrend(DataOutput out) throws IOException {
        out.writeUTF(this.getValue());
    }

    public BStringTrendRecord set(BAbsTime timestamp, String value, BStatus status) {
        this.setTimestamp(timestamp);
        this.setTrendFlags(BTrendFlags.DEFAULT);
        this.setValue(value);
        this.setStatus(status);
        return this;
    }

    @Override
    public String toString(Context ctx) {
        StringBuffer s = new StringBuffer(32);
        s.append(super.toString(ctx));
        s.append(" ");
        s.append(this.getValue());
        s.append(' ');
        s.append(this.getStatus());
        return s.toString();
    }
}

