/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import com.tridium.fox.sys.NiagaraStation;
import com.tridium.history.BHistoryDeltaQuery;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.space.BSpace;
import javax.baja.space.BSpaceScheme;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public class BHistoryScheme
extends BSpaceScheme {
    public static final BHistoryScheme INSTANCE = new BHistoryScheme();
    public static final Type TYPE = Sys.loadType(BHistoryScheme.class);

    protected BHistoryScheme() {
        super("history");
    }

    public Type getSpaceType() {
        return BHistorySpace.TYPE;
    }

    public OrdQuery parse(String queryBody) {
        return new HistoryQuery(this.getId(), queryBody);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OrdTarget resolve(OrdTarget base, OrdQuery query, BSpace space) {
        String histName;
        String devName;
        BHistorySpace hspace;
        HistoryQuery hq;
        block33: {
            block34: {
                String devName2;
                block31: {
                    BObject baseObj;
                    block32: {
                        block30: {
                            hq = (HistoryQuery)query;
                            hspace = (BHistorySpace)space;
                            if (hq.isHistoryFolderQuery()) {
                                String[] folderNames = hq.getHistoryFolderPath();
                                BINavNode child = null;
                                if (folderNames == null) return new OrdTarget(base, (BObject)child);
                                if (folderNames.length <= 0) return new OrdTarget(base, (BObject)child);
                                StringBuffer navName = new StringBuffer();
                                navName.append("history://").append(folderNames[0]);
                                child = hspace.getNavChild(navName.toString());
                                int idx = 1;
                                while (child != null) {
                                    if (idx >= folderNames.length) return new OrdTarget(base, (BObject)child);
                                    navName.append("/").append(folderNames[idx]);
                                    child = child.getNavChild(navName.toString());
                                    ++idx;
                                }
                                return new OrdTarget(base, (BObject)child);
                            }
                            if (hq.isSpaceQuery()) {
                                return new OrdTarget(base, (BObject)hspace);
                            }
                            if (!hq.isDeviceQuery()) break block30;
                            devName2 = hq.getDeviceName();
                            if (devName2.equals("^")) {
                                devName2 = hspace.getDeviceName();
                                return new OrdTarget(base, (BObject)hspace.getDevice(devName2));
                            }
                            break block31;
                        }
                        devName = hq.getDeviceName();
                        histName = hq.getHistoryName();
                        if (!devName.equals("^")) break block32;
                        devName = hspace.getDeviceName();
                        break block33;
                    }
                    if (!devName.equals("@") || !(baseObj = base.get()).isComplex()) break block33;
                    break block34;
                }
                if (!devName2.equals("@")) return new OrdTarget(base, (BObject)hspace.getDevice(devName2));
                BObject baseObj = base.get();
                if (!baseObj.isComplex()) return new OrdTarget(base, (BObject)hspace.getDevice(devName2));
                BComplex comp = (BComplex)baseObj;
                while (comp != null) {
                    if (comp instanceof NiagaraStation) {
                        devName2 = ((NiagaraStation)comp).getStationName();
                        return new OrdTarget(base, (BObject)hspace.getDevice(devName2));
                    }
                    comp = comp.getParent();
                }
                return new OrdTarget(base, (BObject)hspace.getDevice(devName2));
            }
            for (BComplex comp = (BComplex)baseObj; comp != null; comp = comp.getParent()) {
                if (!(comp instanceof NiagaraStation)) continue;
                devName = ((NiagaraStation)comp).getStationName();
                break;
            }
        }
        BHistoryId id = BHistoryId.make(devName, histName);
        try (HistorySpaceConnection conn = hspace.getConnection(null);){
            BIHistory history = conn.getHistory(id);
            if (history == null) {
                throw new HistoryNotFoundException();
            }
            if (hq.hasTimeRange()) {
                BAbsTime now = BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)history.getConfig().getTimeZone());
                BAbsTime start = hq.getStartTime(now);
                BAbsTime end = hq.getEndTime(now);
                BHistoryDeltaQuery result = null;
                result = hq.isDelta() ? new BHistoryDeltaQuery(history, start, end) : (BObject)conn.timeQuery(history, start, end, false);
                OrdTarget ordTarget = new OrdTarget(base, (BObject)result);
                return ordTarget;
            }
            if (hq.isDelta()) {
                BHistoryDeltaQuery deltaCollection = new BHistoryDeltaQuery(history, null, null);
                OrdTarget ordTarget = new OrdTarget(base, (BObject)deltaCollection);
                return ordTarget;
            }
            OrdTarget ordTarget = new OrdTarget(base, (BObject)history);
            return ordTarget;
        }
        catch (Exception e) {
            throw new UnresolvedException("Cannot resolve history: " + (Object)((Object)id), (Throwable)e);
        }
    }

    public Type getType() {
        return TYPE;
    }
}

