/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import com.tridium.history.BHistoryRecordGroup;
import com.tridium.history.audit.BAuditRecord;
import com.tridium.history.audit.BSecurityAuditRecord;
import com.tridium.history.log.BLogRecord;
import com.tridium.util.ValueByteBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Base64;
import java.util.Hashtable;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BCapacity;
import javax.baja.history.BEnumTrendRecord;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.io.BIEncodable;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public final class BHistoryEvent
extends BStruct
implements BIEncodable {
    public static final int CREATED = 0;
    public static final int DELETED = 1;
    public static final int APPENDED = 2;
    public static final int UPDATED = 3;
    public static final int CLEARED_ALL_RECORDS = 4;
    public static final int CLEARED_OLD_RECORDS = 5;
    public static final int RENAMED = 6;
    public static final int RESIZED = 7;
    public static final int DB_OPENED = 8;
    public static final int DB_CLOSED = 9;
    public static final int DB_FLUSHED = 10;
    public static final int DB_SAVED = 11;
    public static final int CONFIG_CHANGED = 12;
    private static String[] ID_STRINGS = new String[]{"created", "deleted", "appended", "updated", "clearedAllRecords", "clearedOldRecords", "renamed", "resized", "dbOpened", "dbClosed", "dbFlushed", "dbSaved", "configChanged"};
    private static Object seqLock = new Object();
    private static int seqNum = 0;
    public static final Type TYPE = Sys.loadType(BHistoryEvent.class);
    private static Hashtable<Type, Integer> typeToByte = new Hashtable(6);
    private static Type[] byteToType;
    static BHistoryEvent dbOpenedEvent;
    static BHistoryEvent dbClosedEvent;
    static BHistoryEvent dbFlushedEvent;
    static BHistoryEvent dbSavedEvent;
    private int eventId;
    private BHistoryId historyId = null;
    private BIHistoryRecordSet records = null;
    private BAbsTime clearOldTime = null;
    private String newHistoryName = null;
    private BCapacity capacity = null;
    private BFullPolicy fullPolicy = null;
    private BHistoryConfig config = null;
    private boolean useShorthand = false;
    private BIEncodable alternativeEncodable = null;

    @Deprecated
    public static BHistoryEvent makeCreated(BHistoryId historyId) {
        return new BHistoryEvent(0, historyId);
    }

    public static BHistoryEvent makeCreated(BHistoryId historyId, BHistoryConfig config) {
        BHistoryEvent event = new BHistoryEvent(0, historyId);
        event.config = config;
        return event;
    }

    public static BHistoryEvent makeDeleted(BHistoryId historyId) {
        return new BHistoryEvent(1, historyId);
    }

    public static BHistoryEvent makeAppended(BHistoryId historyId, BIHistoryRecordSet records) {
        BHistoryEvent event = new BHistoryEvent(2, historyId);
        event.records = records;
        return event;
    }

    public static BHistoryEvent makeUpdated(BHistoryId historyId, BIHistoryRecordSet record) {
        BHistoryEvent event = new BHistoryEvent(3, historyId);
        event.records = record;
        return event;
    }

    public static BHistoryEvent makeClearedAll(BHistoryId historyId) {
        return new BHistoryEvent(4, historyId);
    }

    public static BHistoryEvent makeClearedOld(BHistoryId historyId, BAbsTime clearOldTime) {
        BHistoryEvent event = new BHistoryEvent(5, historyId);
        event.clearOldTime = clearOldTime;
        return event;
    }

    public static BHistoryEvent makeRenamed(BHistoryId historyId, String newHistoryName) {
        BHistoryEvent event = new BHistoryEvent(6, historyId);
        event.newHistoryName = newHistoryName;
        return event;
    }

    public static BHistoryEvent makeResized(BHistoryId historyId, BCapacity capacity, BFullPolicy fullPolicy) {
        BHistoryEvent event = new BHistoryEvent(7, historyId);
        event.capacity = capacity;
        event.fullPolicy = fullPolicy;
        return event;
    }

    public static BHistoryEvent makeDbOpened() {
        return dbOpenedEvent;
    }

    public static BHistoryEvent makeDbClosed() {
        return dbClosedEvent;
    }

    public static BHistoryEvent makeDbFlushed() {
        return dbFlushedEvent;
    }

    public static BHistoryEvent makeDbSaved() {
        return dbSavedEvent;
    }

    public static BHistoryEvent makeConfigChanged(BHistoryId historyId, BHistoryConfig config) {
        BHistoryEvent event = new BHistoryEvent(12, historyId);
        event.config = config;
        return event;
    }

    public static BHistoryEvent makeShorthand(BHistoryEvent event, boolean useShorthand) {
        BHistoryEvent result = new BHistoryEvent();
        result.eventId = event.eventId;
        result.historyId = event.historyId;
        result.records = event.records;
        result.clearOldTime = event.clearOldTime;
        result.newHistoryName = event.newHistoryName;
        result.capacity = event.capacity;
        result.fullPolicy = event.fullPolicy;
        result.config = event.config;
        result.useShorthand = useShorthand;
        return result;
    }

    public static BHistoryEvent makeStorageEvent(BHistoryEvent event, BIEncodable alternativeEncodable, boolean useShorthand) {
        BHistoryEvent result = BHistoryEvent.makeShorthand(event, useShorthand);
        result.alternativeEncodable = alternativeEncodable;
        return result;
    }

    public static BHistoryEvent makeReplayEvent(BHistoryEvent event, BHistoryId alternativeId, boolean useShorthand) {
        BHistoryEvent result = BHistoryEvent.makeShorthand(event, useShorthand);
        result.historyId = alternativeId;
        return result;
    }

    public BHistoryEvent(int eventId) {
        this.eventId = eventId;
    }

    public BHistoryEvent(int eventId, BHistoryId historyId) {
        this.eventId = eventId;
        this.historyId = historyId;
    }

    public BHistoryEvent() {
    }

    public int getId() {
        return this.eventId;
    }

    public BHistoryId getHistoryId() {
        return this.historyId;
    }

    public BIHistoryRecordSet getRecordSet() {
        return this.records;
    }

    public BAbsTime getClearOldTime() {
        return this.clearOldTime;
    }

    public String getNewHistoryName() {
        return this.newHistoryName;
    }

    public BCapacity getCapacity() {
        return this.capacity;
    }

    public BFullPolicy getFullPolicy() {
        return this.fullPolicy;
    }

    public BHistoryConfig getConfig() {
        return this.config;
    }

    public boolean getUseShorthandEncoding() {
        return this.useShorthand;
    }

    public String toString(Context cx) {
        StringBuffer sb = new StringBuffer();
        sb.append(ID_STRINGS[this.eventId]).append(" ");
        if (this.historyId != null) {
            sb.append(this.historyId.toString());
        }
        if (this.records != null) {
            sb.append(": ").append(this.records.toString());
        }
        if (this.clearOldTime != null) {
            sb.append(": ").append(this.clearOldTime.toString());
        }
        if (this.newHistoryName != null) {
            sb.append(": ").append(this.newHistoryName);
        }
        if (this.capacity != null) {
            sb.append(": ").append(this.capacity.toString());
        }
        if (this.fullPolicy != null) {
            sb.append(": ").append(this.fullPolicy.toString());
        }
        return sb.toString();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeByte(this.eventId);
        switch (this.eventId) {
            case 2: 
            case 3: {
                this.idToShorthand().encode(out);
                int size = this.records.getRecordCount();
                if (size <= 127) {
                    out.writeBoolean(true);
                    out.writeByte(size);
                } else {
                    out.writeBoolean(false);
                    out.writeInt(size);
                }
                if (size > 0) {
                    BHistoryRecord rec = this.records.getRecord(0);
                    Type t = rec.getType();
                    Integer tByte = typeToByte.get(t);
                    boolean knownType = tByte != null;
                    out.writeBoolean(knownType);
                    if (knownType) {
                        out.writeByte(tByte);
                    } else {
                        t.getTypeSpec().encode(out);
                    }
                }
                for (int i = 0; i < size; ++i) {
                    this.records.getRecord(i).write(out);
                }
                break;
            }
            case 0: 
            case 12: {
                boolean hasConfig;
                this.idToShorthand().encode(out);
                boolean bl = hasConfig = this.config != null;
                if (hasConfig) {
                    byte[] bytes = ValueByteBuffer.marshal((BObject)this.config);
                    int size = bytes.length;
                    out.writeInt(size);
                    if (size > 0) {
                        out.write(bytes);
                    }
                } else {
                    out.writeInt(0);
                }
                out.writeInt(BHistoryEvent.nextSeqNum());
                break;
            }
            case 1: 
            case 4: {
                this.idToShorthand().encode(out);
                out.writeInt(BHistoryEvent.nextSeqNum());
                break;
            }
            case 5: {
                this.idToShorthand().encode(out);
                this.clearOldTime.encode(out);
                out.writeInt(BHistoryEvent.nextSeqNum());
                break;
            }
            case 6: {
                this.idToShorthand().encode(out);
                out.writeUTF(this.newHistoryName);
                out.writeInt(BHistoryEvent.nextSeqNum());
                break;
            }
            case 7: {
                this.idToShorthand().encode(out);
                this.capacity.encode(out);
                this.fullPolicy.encode(out);
                out.writeInt(BHistoryEvent.nextSeqNum());
                break;
            }
            default: {
                out.writeInt(BHistoryEvent.nextSeqNum());
            }
        }
    }

    public BObject decode(DataInput in) throws IOException {
        byte eId = in.readByte();
        switch (eId) {
            case 8: {
                in.readInt();
                return dbOpenedEvent;
            }
            case 9: {
                in.readInt();
                return dbClosedEvent;
            }
            case 10: {
                in.readInt();
                return dbFlushedEvent;
            }
            case 11: {
                in.readInt();
                return dbSavedEvent;
            }
        }
        BHistoryEvent event = new BHistoryEvent(eId);
        switch (eId) {
            case 2: 
            case 3: {
                event.historyId = BHistoryEvent.idFromShorthand((BHistoryId)BHistoryId.DEFAULT.decode(in));
                int size = 0;
                size = in.readBoolean() ? in.readByte() : in.readInt();
                BHistoryRecord[] recs = size > 1 ? new BHistoryRecord[size] : null;
                Type t = null;
                if (size > 0) {
                    t = in.readBoolean() ? byteToType[in.readByte()] : ((BTypeSpec)BTypeSpec.DEFAULT.decode(in)).getResolvedType();
                }
                BHistoryRecord rec = null;
                for (int i = 0; i < size; ++i) {
                    rec = (BHistoryRecord)t.getInstance();
                    rec = rec.read(in);
                    if (recs == null) continue;
                    recs[i] = rec;
                }
                if (recs == null) {
                    event.records = rec;
                    break;
                }
                event.records = new BHistoryRecordGroup(recs);
                break;
            }
            case 0: 
            case 12: {
                event.historyId = BHistoryEvent.idFromShorthand((BHistoryId)BHistoryId.DEFAULT.decode(in));
                int size = in.readInt();
                if (size > 0) {
                    byte[] bytes = new byte[size];
                    in.readFully(bytes);
                    try {
                        event.config = (BHistoryConfig)ValueByteBuffer.unmarshal((byte[])bytes);
                    }
                    catch (IOException io) {
                        throw io;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                in.readInt();
                break;
            }
            case 1: 
            case 4: {
                event.historyId = BHistoryEvent.idFromShorthand((BHistoryId)BHistoryId.DEFAULT.decode(in));
                in.readInt();
                break;
            }
            case 5: {
                event.historyId = BHistoryEvent.idFromShorthand((BHistoryId)BHistoryId.DEFAULT.decode(in));
                event.clearOldTime = (BAbsTime)BAbsTime.DEFAULT.decode(in);
                in.readInt();
                break;
            }
            case 6: {
                event.historyId = BHistoryEvent.idFromShorthand((BHistoryId)BHistoryId.DEFAULT.decode(in));
                event.newHistoryName = in.readUTF();
                in.readInt();
                break;
            }
            case 7: {
                event.historyId = BHistoryEvent.idFromShorthand((BHistoryId)BHistoryId.DEFAULT.decode(in));
                event.capacity = (BCapacity)BCapacity.DEFAULT.decode(in);
                event.fullPolicy = (BFullPolicy)BFullPolicy.roll.decode(in);
                in.readInt();
                break;
            }
        }
        return event;
    }

    public String encodeToString() throws IOException {
        ByteBuffer buf = new ByteBuffer();
        this.encode((DataOutput)buf);
        return Base64.getEncoder().encodeToString(buf.toByteArray());
    }

    public BObject decodeFromString(String s) throws IOException {
        ByteBuffer buf = new ByteBuffer(Base64.getDecoder().decode(s));
        return this.decode((DataInput)buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextSeqNum() {
        Object object = seqLock;
        synchronized (object) {
            return seqNum++;
        }
    }

    private BIEncodable idToShorthand() {
        if (this.alternativeEncodable != null) {
            return this.alternativeEncodable;
        }
        BHistoryId id = this.historyId;
        try {
            id = this.getUseShorthandEncoding() ? id.toShorthand(Sys.getStation().getStationName()) : id.fromShorthand(Sys.getStation().getStationName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return id;
    }

    private static BHistoryId idFromShorthand(BHistoryId id) {
        try {
            id = id.fromShorthand(Sys.getStation().getStationName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return id;
    }

    public Object clone() {
        BHistoryEvent event = new BHistoryEvent();
        event.eventId = this.eventId;
        event.historyId = this.historyId;
        event.records = this.records;
        event.clearOldTime = this.clearOldTime;
        event.newHistoryName = this.newHistoryName;
        event.capacity = this.capacity;
        event.fullPolicy = this.fullPolicy;
        event.config = this.config;
        return event;
    }

    public Type getType() {
        return TYPE;
    }

    static {
        typeToByte.put(BBooleanTrendRecord.TYPE, new Integer(0));
        typeToByte.put(BEnumTrendRecord.TYPE, new Integer(1));
        typeToByte.put(BNumericTrendRecord.TYPE, new Integer(2));
        typeToByte.put(BStringTrendRecord.TYPE, new Integer(3));
        typeToByte.put(BAuditRecord.TYPE, new Integer(4));
        typeToByte.put(BLogRecord.TYPE, new Integer(5));
        typeToByte.put(BSecurityAuditRecord.TYPE, new Integer(6));
        byteToType = new Type[]{BBooleanTrendRecord.TYPE, BEnumTrendRecord.TYPE, BNumericTrendRecord.TYPE, BStringTrendRecord.TYPE, BAuditRecord.TYPE, BLogRecord.TYPE, BSecurityAuditRecord.TYPE};
        dbOpenedEvent = new BHistoryEvent(8);
        dbClosedEvent = new BHistoryEvent(9);
        dbFlushedEvent = new BHistoryEvent(10);
        dbSavedEvent = new BHistoryEvent(11);
    }
}

